/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionEventDispatcher;
import com.intellij.remoteServer.impl.runtime.ServerConnectionManagerImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.impl.runtime.deployment.LocalDeploymentImpl;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnectionData;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnectionDataNotAvailableException;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConnectionImpl<D extends DeploymentConfiguration>
implements ServerConnection<D> {
    private static final Logger LOG = Logger.getInstance(ServerConnectionImpl.class);
    private final RemoteServer<?> myServer;
    private final ServerConnector<D> myConnector;
    private final ServerConnectionEventDispatcher myEventDispatcher;
    private final ServerConnectionManagerImpl myConnectionManager;
    private volatile ConnectionStatus myStatus = ConnectionStatus.DISCONNECTED;
    private volatile String myStatusText;
    private volatile ServerRuntimeInstance<D> myRuntimeInstance;
    private final Map<String, DeploymentLogManagerImpl> myLogManagers = ContainerUtil.newConcurrentMap();
    private final MyDeployments myAllDeployments;

    public ServerConnectionImpl(RemoteServer<?> server, ServerConnector<D> connector, @Nullable ServerConnectionManagerImpl connectionManager, ServerConnectionEventDispatcher eventDispatcher) {
        this.myServer = server;
        this.myConnector = connector;
        this.myConnectionManager = connectionManager;
        this.myEventDispatcher = eventDispatcher;
        this.myAllDeployments = new MyDeployments(server.getType().getDeploymentComparator());
    }

    @NotNull
    public RemoteServer<?> getServer() {
        RemoteServer<?> remoteServer = this.myServer;
        if (remoteServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getServer"));
        }
        return remoteServer;
    }

    @NotNull
    public ConnectionStatus getStatus() {
        ConnectionStatus connectionStatus = this.myStatus;
        if (connectionStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getStatus"));
        }
        return connectionStatus;
    }

    @NotNull
    public String getStatusText() {
        String string = this.myStatusText != null ? this.myStatusText : this.myStatus.getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getStatusText"));
        }
        return string;
    }

    public void connect(final @NotNull Runnable onFinished) {
        if (onFinished == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onFinished", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "connect"));
        }
        this.doDisconnect();
        this.connectIfNeeded(new ServerConnector.ConnectionCallback<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverRuntimeInstance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$1", "connected"));
                }
                onFinished.run();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$1", "errorOccurred"));
                }
                onFinished.run();
            }
        });
    }

    public void disconnect() {
        if (this.myConnectionManager != null) {
            this.myConnectionManager.removeConnection(this.myServer);
        }
        this.doDisconnect();
    }

    private void doDisconnect() {
        if (this.myStatus == ConnectionStatus.CONNECTED) {
            if (this.myRuntimeInstance != null) {
                this.myRuntimeInstance.disconnect();
                this.myRuntimeInstance = null;
            }
            this.setStatus(ConnectionStatus.DISCONNECTED);
            for (DeploymentLogManagerImpl logManager : this.myLogManagers.values()) {
                logManager.disposeLogs();
            }
        }
    }

    public void deploy(final @NotNull DeploymentTask<D> task, final @NotNull java.util.function.Consumer<String> onDeploymentStarted) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "deploy"));
        }
        if (onDeploymentStarted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDeploymentStarted", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "deploy"));
        }
        this.connectIfNeeded(new ConnectionCallbackBase<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$2", "connected"));
                }
                LocalDeploymentImpl deployment = new LocalDeploymentImpl(instance, ServerConnectionImpl.this, DeploymentStatus.DEPLOYING, null, null, task);
                String deploymentName = deployment.getName();
                ServerConnectionImpl.this.myAllDeployments.addLocal(deployment);
                DeploymentLogManagerImpl logManager = new DeploymentLogManagerImpl(task.getProject(), new ChangeListener()).withMainHandlerVisible(true);
                LoggingHandlerImpl handler2 = logManager.getMainLoggingHandler();
                ServerConnectionImpl.this.myLogManagers.put(deploymentName, logManager);
                handler2.printlnSystemMessage("Deploying '" + deploymentName + "'...");
                onDeploymentStarted.accept(deploymentName);
                instance.deploy(task, (DeploymentLogManager)logManager, (ServerRuntimeInstance.DeploymentOperationCallback)new DeploymentOperationCallbackImpl(deploymentName, (DeploymentTaskImpl)task, handler2, deployment));
            }
        });
    }

    @Nullable
    public DeploymentLogManager getLogManager(@NotNull Deployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getLogManager"));
        }
        return this.myLogManagers.get(deployment.getName());
    }

    @NotNull
    public DeploymentLogManager getOrCreateLogManager(@NotNull Project project2, @NotNull Deployment deployment) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getOrCreateLogManager"));
        }
        if (deployment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getOrCreateLogManager"));
        }
        DeploymentLogManagerImpl result2 = (DeploymentLogManagerImpl)this.getLogManager(deployment);
        if (result2 == null) {
            result2 = new DeploymentLogManagerImpl(project2, new ChangeListener());
            this.myLogManagers.put(deployment.getName(), result2);
        }
        DeploymentLogManagerImpl deploymentLogManagerImpl = result2;
        if (deploymentLogManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getOrCreateLogManager"));
        }
        return deploymentLogManagerImpl;
    }

    public void computeDeployments(final @NotNull Runnable onFinished) {
        if (onFinished == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onFinished", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "computeDeployments"));
        }
        this.connectIfNeeded(new ConnectionCallbackBase<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$3", "connected"));
                }
                ServerConnectionImpl.this.computeDeployments(instance, onFinished);
            }
        });
    }

    private void computeDeployments(ServerRuntimeInstance<D> instance, final Runnable onFinished) {
        instance.computeDeployments(new ServerRuntimeInstance.ComputeDeploymentsCallback(){
            private final List<DeploymentImpl> myCollectedDeployments = Collections.synchronizedList(new ArrayList());

            public void addDeployment(@NotNull String deploymentName) {
                if (deploymentName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$4", "addDeployment"));
                }
                this.addDeployment(deploymentName, null);
            }

            public void addDeployment(@NotNull String deploymentName, @Nullable DeploymentRuntime deploymentRuntime) {
                if (deploymentName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$4", "addDeployment"));
                }
                this.addDeployment(deploymentName, deploymentRuntime, null, null);
            }

            public Deployment addDeployment(@NotNull String name2, @Nullable DeploymentRuntime runtime, @Nullable DeploymentStatus status, @Nullable String statusText) {
                DeploymentImpl result2;
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$4", "addDeployment"));
                }
                if (status == null) {
                    status = DeploymentStatus.DEPLOYED;
                }
                if ((result2 = ServerConnectionImpl.this.myAllDeployments.updateRemoteState(name2, runtime, status, statusText)) == null) {
                    result2 = new DeploymentImpl(ServerConnectionImpl.this, name2, status, statusText, runtime, null);
                }
                this.myCollectedDeployments.add(result2);
                return result2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void succeeded() {
                List<DeploymentImpl> list2 = this.myCollectedDeployments;
                synchronized (list2) {
                    ServerConnectionImpl.this.myAllDeployments.replaceRemotesWith(this.myCollectedDeployments);
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                onFinished.run();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$4", "errorOccurred"));
                }
                ServerConnectionImpl.this.myAllDeployments.replaceRemotesWith(Collections.emptyList());
                ServerConnectionImpl.this.myStatusText = "Cannot obtain deployments: " + errorMessage;
                ServerConnectionImpl.this.myEventDispatcher.queueConnectionStatusChanged(ServerConnectionImpl.this);
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                onFinished.run();
            }
        });
    }

    public void undeploy(@NotNull Deployment deployment, @NotNull DeploymentRuntime runtime) {
        if (deployment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "undeploy"));
        }
        if (runtime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtime", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "undeploy"));
        }
        final String deploymentName = deployment.getName();
        final UndeployTransition undeployInProgress = this.myAllDeployments.startUndeploy(deploymentName);
        this.myEventDispatcher.queueDeploymentsChanged(this);
        DeploymentLogManagerImpl logManager = this.myLogManagers.get(deploymentName);
        LoggingHandlerImpl loggingHandler = logManager == null ? null : logManager.getMainLoggingHandler();
        final Consumer logConsumer = message2 -> {
            if (loggingHandler == null) {
                LOG.info(message2);
            } else {
                loggingHandler.printlnSystemMessage((String)message2);
            }
        };
        logConsumer.consume((Object)("Undeploying '" + deploymentName + "'..."));
        runtime.undeploy(new DeploymentRuntime.UndeploymentTaskCallback(){

            public void succeeded() {
                DeploymentLogManagerImpl logManager;
                logConsumer.consume((Object)("'" + deploymentName + "' has been undeployed successfully."));
                if (undeployInProgress != null) {
                    undeployInProgress.succeeded();
                }
                if ((logManager = (DeploymentLogManagerImpl)ServerConnectionImpl.this.myLogManagers.remove(deploymentName)) != null) {
                    logManager.disposeLogs();
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                ServerConnectionImpl.this.computeDeployments(ServerConnectionImpl.this.myRuntimeInstance, EmptyRunnable.INSTANCE);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$5", "errorOccurred"));
                }
                logConsumer.consume((Object)("Failed to undeploy '" + deploymentName + "': " + errorMessage));
                if (undeployInProgress != null) {
                    undeployInProgress.failed();
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
            }
        });
    }

    @NotNull
    public Collection<Deployment> getDeployments() {
        Collection<Deployment> collection = this.myAllDeployments.listDeployments();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "getDeployments"));
        }
        return collection;
    }

    public void connectIfNeeded(final ServerConnector.ConnectionCallback<D> callback) {
        ServerRuntimeInstance<D> instance = this.myRuntimeInstance;
        if (instance != null) {
            callback.connected(instance);
            return;
        }
        this.setStatus(ConnectionStatus.CONNECTING);
        this.myConnector.connect(new ServerConnector.ConnectionCallback<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$6", "connected"));
                }
                ServerConnectionImpl.this.setStatus(ConnectionStatus.CONNECTED);
                ServerConnectionImpl.this.myRuntimeInstance = instance;
                callback.connected(instance);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$6", "errorOccurred"));
                }
                ServerConnectionImpl.this.setStatus(ConnectionStatus.DISCONNECTED, errorMessage);
                ServerConnectionImpl.this.myRuntimeInstance = null;
                callback.errorOccurred(errorMessage);
            }
        });
    }

    private void setStatus(ConnectionStatus status) {
        this.setStatus(status, null);
    }

    private void setStatus(ConnectionStatus status, String statusText) {
        this.myStatus = status;
        this.myStatusText = statusText;
        this.myEventDispatcher.queueConnectionStatusChanged(this);
    }

    public void changeDeploymentState(@NotNull DeploymentImpl deployment, @Nullable DeploymentRuntime deploymentRuntime, @NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText) {
        if (deployment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "changeDeploymentState"));
        }
        if (oldStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldStatus", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "changeDeploymentState"));
        }
        if (newStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatus", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl", "changeDeploymentState"));
        }
        if (this.myAllDeployments.updateAnyState(deployment, deploymentRuntime, oldStatus, newStatus, statusText)) {
            this.myEventDispatcher.queueDeploymentsChanged(this);
        }
    }

    private static abstract class UndeployTransition {
        private final DeploymentImpl myDeployment;

        public UndeployTransition(@NotNull DeploymentImpl deployment) {
            if (deployment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$UndeployTransition", "<init>"));
            }
            this.myDeployment = deployment;
            this.myDeployment.changeState(DeploymentStatus.DEPLOYED, DeploymentStatus.DEPLOYING, null, null);
        }

        public abstract void succeeded();

        public abstract void failed();

        protected boolean tryChangeToTerminalState(DeploymentStatus terminalState) {
            return this.myDeployment.changeState(DeploymentStatus.DEPLOYING, terminalState, null, null);
        }

        protected DeploymentImpl getDeployment() {
            return this.myDeployment;
        }
    }

    private static class MyDeployments {
        private final Object myLocalLock = new Object();
        private final Object myRemoteLock = new Object();
        private final Map<String, DeploymentImpl> myRemoteDeployments = new HashMap<String, DeploymentImpl>();
        private final Map<String, LocalDeploymentImpl> myLocalDeployments = new HashMap<String, LocalDeploymentImpl>();
        private List<Deployment> myCachedAllDeployments;
        private final Comparator<Deployment> myDeploymentComparator;

        public MyDeployments(Comparator<Deployment> deploymentComparator) {
            this.myDeploymentComparator = deploymentComparator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLocal(@NotNull LocalDeploymentImpl<?> deployment) {
            if (deployment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments", "addLocal"));
            }
            Object object = this.myLocalLock;
            synchronized (object) {
                this.myLocalDeployments.put(deployment.getName(), deployment);
                this.myCachedAllDeployments = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceRemotesWith(@NotNull Collection<DeploymentImpl> newDeployments) {
            if (newDeployments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDeployments", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments", "replaceRemotesWith"));
            }
            Object object = this.myRemoteLock;
            synchronized (object) {
                this.myRemoteDeployments.clear();
                this.myCachedAllDeployments = null;
                for (DeploymentImpl deployment : newDeployments) {
                    this.myRemoteDeployments.put(deployment.getName(), deployment);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public DeploymentImpl updateRemoteState(@NotNull String deploymentName, @Nullable DeploymentRuntime deploymentRuntime, @NotNull DeploymentStatus deploymentStatus, @Nullable String deploymentStatusText) {
            if (deploymentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments", "updateRemoteState"));
            }
            if (deploymentStatus == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentStatus", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments", "updateRemoteState"));
            }
            Object object = this.myRemoteLock;
            synchronized (object) {
                DeploymentImpl result2 = this.myRemoteDeployments.get(deploymentName);
                if (result2 != null && !result2.getStatus().isTransition()) {
                    result2.changeState(result2.getStatus(), deploymentStatus, deploymentStatusText, deploymentRuntime);
                }
                return result2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateAnyState(@NotNull DeploymentImpl deployment, @Nullable DeploymentRuntime deploymentRuntime, @NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText) {
            if (deployment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments", "updateAnyState"));
            }
            if (oldStatus == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldStatus", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments", "updateAnyState"));
            }
            if (newStatus == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatus", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments", "updateAnyState"));
            }
            Object object = this.myLocalLock;
            synchronized (object) {
                Object object2 = this.myRemoteLock;
                synchronized (object2) {
                    return deployment.changeState(oldStatus, newStatus, statusText, deploymentRuntime);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public Collection<Deployment> listDeployments() {
            Object object = this.myLocalLock;
            // MONITORENTER : object
            Object object2 = this.myRemoteLock;
            // MONITORENTER : object2
            if (this.myCachedAllDeployments == null) {
                Collection<Deployment> result2 = this.doListDeployments();
                this.myCachedAllDeployments = Collections.unmodifiableList(new ArrayList<Deployment>(result2));
            }
            List<Deployment> list2 = this.myCachedAllDeployments;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            if (list2 != null) return list2;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments", "listDeployments"));
        }

        private Collection<Deployment> doListDeployments() {
            LinkedHashSet<Deployment> result2 = new LinkedHashSet<Deployment>();
            TreeMap<Deployment, DeploymentImpl> orderedDeployments = new TreeMap<Deployment, DeploymentImpl>(this.myDeploymentComparator);
            for (LocalDeploymentImpl localDeployment : this.myLocalDeployments.values()) {
                localDeployment.setRemoteDeployment(null);
                orderedDeployments.put(localDeployment, localDeployment);
            }
            result2.addAll(orderedDeployments.keySet());
            for (DeploymentImpl remoteDeployment : this.myRemoteDeployments.values()) {
                DeploymentImpl deployment = (DeploymentImpl)orderedDeployments.get(remoteDeployment);
                if (deployment != null) {
                    if (!(deployment instanceof LocalDeploymentImpl)) continue;
                    ((LocalDeploymentImpl)deployment).setRemoteDeployment(remoteDeployment);
                    continue;
                }
                orderedDeployments.put(remoteDeployment, remoteDeployment);
            }
            result2.addAll(orderedDeployments.keySet());
            return result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public UndeployTransition startUndeploy(@NotNull String deploymentName) {
            if (deploymentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments", "startUndeploy"));
            }
            Object object = this.myLocalLock;
            synchronized (object) {
                Object object2 = this.myRemoteLock;
                synchronized (object2) {
                    DeploymentImpl local = this.myLocalDeployments.get(deploymentName);
                    if (local != null) {
                        return new UndeployTransition(local){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void succeeded() {
                                Object object = myLocalLock;
                                synchronized (object) {
                                    if (this.tryChangeToTerminalState(DeploymentStatus.NOT_DEPLOYED)) {
                                        myLocalDeployments.remove(this.getDeployment().getName());
                                        myCachedAllDeployments = null;
                                    }
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void failed() {
                                Object object = myLocalLock;
                                synchronized (object) {
                                    this.tryChangeToTerminalState(DeploymentStatus.DEPLOYED);
                                }
                            }
                        };
                    }
                    DeploymentImpl remote = this.myRemoteDeployments.get(deploymentName);
                    if (remote != null) {
                        return new UndeployTransition(remote){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void succeeded() {
                                Object object = myRemoteLock;
                                synchronized (object) {
                                    if (this.tryChangeToTerminalState(DeploymentStatus.NOT_DEPLOYED)) {
                                        myRemoteDeployments.remove(this.getDeployment().getName());
                                        myCachedAllDeployments = null;
                                    }
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void failed() {
                                Object object = myRemoteLock;
                                synchronized (object) {
                                    this.tryChangeToTerminalState(DeploymentStatus.DEPLOYED);
                                }
                            }
                        };
                    }
                    return null;
                }
            }
        }
    }

    private class ChangeListener
    implements Runnable {
        private ChangeListener() {
        }

        @Override
        public void run() {
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
        }
    }

    private class DeploymentOperationCallbackImpl
    implements ServerRuntimeInstance.DeploymentOperationCallback {
        private final String myDeploymentName;
        private final DeploymentTaskImpl<D> myDeploymentTask;
        private final LoggingHandlerImpl myLoggingHandler;
        private final DeploymentImpl myDeployment;

        public DeploymentOperationCallbackImpl(String deploymentName, DeploymentTaskImpl<D> deploymentTask, LoggingHandlerImpl handler2, DeploymentImpl deployment) {
            this.myDeploymentName = deploymentName;
            this.myDeploymentTask = deploymentTask;
            this.myLoggingHandler = handler2;
            this.myDeployment = deployment;
        }

        public Deployment succeeded(@NotNull DeploymentRuntime deploymentRuntime) {
            if (deploymentRuntime == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentRuntime", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl", "succeeded"));
            }
            this.myLoggingHandler.printlnSystemMessage("'" + this.myDeploymentName + "' has been deployed successfully.");
            this.myDeployment.changeState(DeploymentStatus.DEPLOYING, DeploymentStatus.DEPLOYED, null, deploymentRuntime);
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
            DebugConnector<?, ?> debugConnector = this.myDeploymentTask.getDebugConnector();
            if (debugConnector != null) {
                this.launchDebugger(debugConnector, deploymentRuntime);
            }
            return this.myDeployment;
        }

        private <D extends DebugConnectionData, R extends DeploymentRuntime> void launchDebugger(@NotNull DebugConnector<D, R> debugConnector, @NotNull DeploymentRuntime runtime) {
            if (debugConnector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugConnector", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl", "launchDebugger"));
            }
            if (runtime == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtime", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl", "launchDebugger"));
            }
            try {
                DebugConnectionData debugInfo = debugConnector.getConnectionData(runtime);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (debugConnector == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugConnector", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl", "lambda$launchDebugger$0"));
                    }
                    try {
                        debugConnector.getLauncher().startDebugSession(debugInfo, this.myDeploymentTask.getExecutionEnvironment(), ServerConnectionImpl.this.myServer);
                    }
                    catch (ExecutionException e) {
                        this.myLoggingHandler.print("Cannot start debugger: " + e.getMessage() + "\n");
                        LOG.info((Throwable)e);
                    }
                });
            }
            catch (DebugConnectionDataNotAvailableException e) {
                this.myLoggingHandler.print("Cannot retrieve debug connection: " + e.getMessage() + "\n");
                LOG.info((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl", "errorOccurred"));
            }
            this.myLoggingHandler.printlnSystemMessage("Failed to deploy '" + this.myDeploymentName + "': " + errorMessage);
            Object object = ServerConnectionImpl.this.myAllDeployments.myLocalLock;
            synchronized (object) {
                this.myDeployment.changeState(DeploymentStatus.DEPLOYING, DeploymentStatus.NOT_DEPLOYED, errorMessage, null);
            }
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
        }
    }

    private static abstract class ConnectionCallbackBase<D extends DeploymentConfiguration>
    implements ServerConnector.ConnectionCallback<D> {
        private ConnectionCallbackBase() {
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$ConnectionCallbackBase", "errorOccurred"));
            }
        }
    }
}

