/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LoggingHandlerImpl
extends LoggingHandlerBase
implements LoggingHandler {
    private final ConsoleView myConsole;

    public LoggingHandlerImpl(String presentableName, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "<init>"));
        }
        super(presentableName);
        this.myConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project2).getConsole();
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
    }

    @Override
    public JComponent getComponent() {
        return this.myConsole.getComponent();
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "getConsole"));
        }
        return consoleView;
    }

    public void print(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "print"));
        }
        this.printText(s, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    protected void printText(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "printText"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "printText"));
        }
        this.myConsole.print(text2, contentType);
    }

    public void printHyperlink(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "printHyperlink"));
        }
        this.printHyperlink(url, (HyperlinkInfo)new BrowserHyperlinkInfo(url));
    }

    public void printHyperlink(@NotNull String text2, HyperlinkInfo info) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "printHyperlink"));
        }
        this.myConsole.printHyperlink(text2, info);
    }

    public void printlnSystemMessage(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "printlnSystemMessage"));
        }
        this.printText(s + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void attachToProcess(@NotNull ProcessHandler handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "attachToProcess"));
        }
        this.myConsole.attachToProcess(handler2);
    }

    public void clear() {
        this.myConsole.clear();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public static class Colored
    extends LoggingHandlerImpl {
        private final AnsiEscapeDecoder myAnsiEscapeDecoder;

        public Colored(String presentableName, @NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl$Colored", "<init>"));
            }
            super(presentableName, project2);
            this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        }

        @Override
        public void print(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl$Colored", "print"));
            }
            this.myAnsiEscapeDecoder.escapeText(s, ProcessOutputTypes.STDOUT, this::printTextWithOutputKey);
        }

        private void printTextWithOutputKey(@NotNull String text2, Key outputType) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl$Colored", "printTextWithOutputKey"));
            }
            this.printText(text2, ConsoleViewContentType.getConsoleViewType((Key)outputType));
        }
    }
}

