/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContribution;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ServersToolWindowFactory
implements ToolWindowFactory,
Condition<Project>,
DumbAware {
    private final RemoteServersViewContribution myContribution;

    public ServersToolWindowFactory(RemoteServersViewContribution contribution) {
        this.myContribution = contribution;
    }

    public void createToolWindowContent(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowFactory", "createToolWindowContent"));
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ServersToolWindowContent serversContent = this.doCreateToolWindowContent(project2);
        Content content = contentFactory.createContent((JComponent)serversContent.getMainPanel(), null, false);
        Disposer.register((Disposable)content, (Disposable)serversContent);
        toolWindow.getContentManager().addContent(content);
    }

    @NotNull
    protected ServersToolWindowContent doCreateToolWindowContent(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowFactory", "doCreateToolWindowContent"));
        }
        ServersToolWindowContent serversToolWindowContent = new ServersToolWindowContent(project2, this.myContribution, ServersToolWindowContent.ActionGroups.SHARED_ACTION_GROUPS);
        if (serversToolWindowContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowFactory", "doCreateToolWindowContent"));
        }
        return serversToolWindowContent;
    }

    public boolean value(Project project2) {
        return this.myContribution.canContribute(project2);
    }

    public RemoteServersViewContribution getContribution() {
        return this.myContribution;
    }
}

