/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowFactory;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class ServersToolWindowManager {
    @NotNull
    private final Project myProject;
    private final String myWindowId;
    private final Icon myIcon;

    public ServersToolWindowManager(@NotNull Project project2, String windowId, Icon icon) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowManager", "<init>"));
        }
        this.myProject = project2;
        this.myWindowId = windowId;
        this.myIcon = icon;
        StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> this.setupListeners());
    }

    public void setupListeners() {
        this.getFactory().getContribution().setupAvailabilityListener(this.myProject, () -> this.updateWindowAvailable(true));
        this.myProject.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowManager$1", "serverAdded"));
                }
                ServersToolWindowManager.this.updateWindowAvailable(true);
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowManager$1", "serverRemoved"));
                }
                ServersToolWindowManager.this.updateWindowAvailable(false);
            }
        });
    }

    private void updateWindowAvailable(boolean showIfAvailable) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(() -> {
            boolean doShow;
            boolean available = this.getFactory().getContribution().canContribute(this.myProject);
            ToolWindow toolWindow = toolWindowManager.getToolWindow(this.myWindowId);
            if (toolWindow == null) {
                if (available) {
                    this.createToolWindow(this.myProject, toolWindowManager).show(null);
                }
                return;
            }
            boolean bl = doShow = !toolWindow.isAvailable() && available;
            if (toolWindow.isAvailable() && !available) {
                toolWindow.hide(null);
            }
            toolWindow.setAvailable(available, null);
            if (showIfAvailable && doShow) {
                toolWindow.show(null);
            }
        });
    }

    private ToolWindow createToolWindow(Project project2, ToolWindowManager toolWindowManager) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(this.myWindowId, false, ToolWindowAnchor.BOTTOM);
        toolWindow.setIcon(this.myIcon);
        this.getFactory().createToolWindowContent(project2, toolWindow);
        return toolWindow;
    }

    @NotNull
    protected abstract ServersToolWindowFactory getFactory();
}

