/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceHandler;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SlicePanel;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceToolwindowSettings;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

@State(name="SliceManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SliceManager
implements PersistentStateComponent<StoredSettingsBean> {
    private final Project myProject;
    private ContentManager myBackContentManager;
    private ContentManager myForthContentManager;
    private final StoredSettingsBean myStoredSettings;
    private static final String BACK_TOOLWINDOW_ID = "Analyze Dataflow to";
    private static final String FORTH_TOOLWINDOW_ID = "Analyze Dataflow from";

    public static SliceManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/slicer/SliceManager", "getInstance"));
        }
        return (SliceManager)ServiceManager.getService((Project)project2, SliceManager.class);
    }

    public SliceManager(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/slicer/SliceManager", "<init>"));
        }
        this.myStoredSettings = new StoredSettingsBean();
        this.myProject = project2;
    }

    private ContentManager getContentManager(boolean dataFlowToThis) {
        if (dataFlowToThis) {
            if (this.myBackContentManager == null) {
                ToolWindow backToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(BACK_TOOLWINDOW_ID, true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject);
                this.myBackContentManager = backToolWindow.getContentManager();
                new ContentManagerWatcher(backToolWindow, this.myBackContentManager);
            }
            return this.myBackContentManager;
        }
        if (this.myForthContentManager == null) {
            ToolWindow forthToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(FORTH_TOOLWINDOW_ID, true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject);
            this.myForthContentManager = forthToolWindow.getContentManager();
            new ContentManagerWatcher(forthToolWindow, this.myForthContentManager);
        }
        return this.myForthContentManager;
    }

    public void slice(@NotNull PsiElement element, boolean dataFlowToThis, @NotNull SliceHandler handler2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceManager", "slice"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/slicer/SliceManager", "slice"));
        }
        String dialogTitle = SliceManager.getElementDescription((dataFlowToThis ? BACK_TOOLWINDOW_ID : FORTH_TOOLWINDOW_ID) + " ", element, null);
        dialogTitle = Pattern.compile("(<style>.*</style>)|<[^<>]*>", 32).matcher(dialogTitle).replaceAll("");
        SliceAnalysisParams params = handler2.askForParams(element, dataFlowToThis, this.myStoredSettings, dialogTitle);
        if (params == null) {
            return;
        }
        SliceRootNode rootNode = new SliceRootNode(this.myProject, new DuplicateMap(), LanguageSlicing.getProvider(element).createRootUsage(element, params));
        this.createToolWindow(dataFlowToThis, rootNode, false, SliceManager.getElementDescription(null, element, null));
    }

    public void createToolWindow(boolean dataFlowToThis, @NotNull SliceRootNode rootNode, boolean splitByLeafExpressions, @NotNull String displayName) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/slicer/SliceManager", "createToolWindow"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/slicer/SliceManager", "createToolWindow"));
        }
        final SliceToolwindowSettings sliceToolwindowSettings = SliceToolwindowSettings.getInstance(this.myProject);
        final ContentManager contentManager = this.getContentManager(dataFlowToThis);
        final Content[] myContent = new Content[1];
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(dataFlowToThis ? BACK_TOOLWINDOW_ID : FORTH_TOOLWINDOW_ID);
        SlicePanel slicePanel = new SlicePanel(this.myProject, dataFlowToThis, rootNode, splitByLeafExpressions, toolWindow){

            @Override
            protected void close() {
                super.close();
                contentManager.removeContent(myContent[0], true);
            }

            @Override
            public boolean isAutoScroll() {
                return sliceToolwindowSettings.isAutoScroll();
            }

            @Override
            public void setAutoScroll(boolean autoScroll) {
                sliceToolwindowSettings.setAutoScroll(autoScroll);
            }

            @Override
            public boolean isPreview() {
                return sliceToolwindowSettings.isPreview();
            }

            @Override
            public void setPreview(boolean preview) {
                sliceToolwindowSettings.setPreview(preview);
            }
        };
        myContent[0] = contentManager.getFactory().createContent((JComponent)slicePanel, displayName, true);
        contentManager.addContent(myContent[0]);
        contentManager.setSelectedContent(myContent[0]);
        toolWindow.activate(null);
    }

    public static String getElementDescription(String prefix, PsiElement element, String suffix) {
        SliceLanguageSupportProvider provider = LanguageSlicing.getProvider(element);
        if (provider != null) {
            element = provider.getElementForDescription(element);
        }
        String desc = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT);
        return "<html><head>" + UIUtil.getCssFontDeclaration((Font)BaseLabel.getLabelFont()) + "</head><body>" + (prefix == null ? "" : prefix) + StringUtil.first((String)desc, (int)100, (boolean)true) + (suffix == null ? "" : suffix) + "</body></html>";
    }

    public StoredSettingsBean getState() {
        return this.myStoredSettings;
    }

    public void loadState(StoredSettingsBean state) {
        this.myStoredSettings.analysisUIOptions.save(state.analysisUIOptions);
    }

    static class StoredSettingsBean {
        boolean showDereferences = true;
        AnalysisUIOptions analysisUIOptions = new AnalysisUIOptions();

        StoredSettingsBean() {
        }
    }
}

