/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceLeafValueClassNode;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SliceNullnessAnalyzer {
    private static void groupByNullness(NullAnalysisResult result2, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map2) {
        SliceRootNode root = SliceNullnessAnalyzer.createNewTree(result2, oldRoot, map2);
        SliceUsage rootUsage = (SliceUsage)((Object)((SliceNode)oldRoot.myCachedChildren.get(0)).getValue());
        SliceManager.getInstance(root.getProject()).createToolWindow(true, root, true, SliceManager.getElementDescription(null, rootUsage.getElement(), " Grouped by Nullness"));
    }

    @NotNull
    public static SliceRootNode createNewTree(NullAnalysisResult result2, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map2) {
        SliceRootNode root = oldRoot.copy();
        assert (oldRoot.myCachedChildren.size() == 1);
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        root.setChanged();
        root.targetEqualUsages.clear();
        root.myCachedChildren = new ArrayList();
        SliceNullnessAnalyzer.createValueRootNode(result2, oldRoot, map2, root, oldRootStart, "Null Values", 0);
        SliceNullnessAnalyzer.createValueRootNode(result2, oldRoot, map2, root, oldRootStart, "NotNull Values", 1);
        SliceNullnessAnalyzer.createValueRootNode(result2, oldRoot, map2, root, oldRootStart, "Other Values", 2);
        SliceRootNode sliceRootNode = root;
        if (sliceRootNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "createNewTree"));
        }
        return sliceRootNode;
    }

    private static void createValueRootNode(NullAnalysisResult result2, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map2, SliceRootNode root, SliceNode oldRootStart, String nodeName, int group) {
        Collection<PsiElement> groupedByValue = result2.groupedByValue[group];
        if (groupedByValue.isEmpty()) {
            return;
        }
        SliceLeafValueClassNode valueRoot = new SliceLeafValueClassNode(root.getProject(), root, nodeName);
        root.myCachedChildren.add(valueRoot);
        THashSet uniqueValues = new THashSet(groupedByValue, SliceLeafAnalyzer.LEAF_ELEMENT_EQUALITY);
        for (PsiElement expression2 : uniqueValues) {
            SliceNode newRoot = SliceLeafAnalyzer.filterTree(oldRootStart, (NullableFunction<SliceNode, SliceNode>)((NullableFunction)oldNode -> {
                if (oldNode.getDuplicate() != null) {
                    return null;
                }
                for (PsiElement nullSuspect : SliceNullnessAnalyzer.group(oldNode, map2, group)) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nullSuspect, (PsiElement)expression2)) continue;
                    return oldNode.copy();
                }
                return null;
            }), (PairProcessor<SliceNode, List<SliceNode>>)((PairProcessor)(node, children2) -> {
                if (!children2.isEmpty()) {
                    return true;
                }
                PsiElement element = ((SliceUsage)((Object)((Object)node.getValue()))).getElement();
                if (element == null) {
                    return false;
                }
                return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)expression2);
            }));
            valueRoot.myCachedChildren.add(new SliceLeafValueRootNode(root.getProject(), expression2, valueRoot, Collections.singletonList(newRoot), ((SliceUsage)((Object)oldRoot.getValue())).params));
        }
    }

    static void startAnalyzeNullness(final @NotNull AbstractTreeStructure treeStructure, final @NotNull Runnable finish) {
        if (treeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeStructure", "com/intellij/slicer/SliceNullnessAnalyzer", "startAnalyzeNullness"));
        }
        if (finish == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finish", "com/intellij/slicer/SliceNullnessAnalyzer", "startAnalyzeNullness"));
        }
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref leafExpressions = Ref.create(null);
        final Map<SliceNode, NullAnalysisResult> map2 = SliceNullnessAnalyzer.createMap();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(root.getProject(), "Expanding all nodes... (may very well take the whole day)", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/slicer/SliceNullnessAnalyzer$1", "run"));
                }
                NullAnalysisResult l = SliceNullnessAnalyzer.calcNullableLeaves(root, treeStructure, map2);
                leafExpressions.set((Object)l);
            }

            public void onCancel() {
                finish.run();
            }

            public void onSuccess() {
                try {
                    NullAnalysisResult leaves = (NullAnalysisResult)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    SliceNullnessAnalyzer.groupByNullness(leaves, root, map2);
                }
                finally {
                    finish.run();
                }
            }
        });
    }

    public static Map<SliceNode, NullAnalysisResult> createMap() {
        return new FactoryMap<SliceNode, NullAnalysisResult>(){

            protected NullAnalysisResult create(SliceNode key2) {
                return new NullAnalysisResult();
            }

            protected Map<SliceNode, NullAnalysisResult> createMap() {
                return ContainerUtil.newIdentityTroveMap();
            }
        };
    }

    private static NullAnalysisResult node(@NotNull SliceNode node, @NotNull Map<SliceNode, NullAnalysisResult> nulls) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/slicer/SliceNullnessAnalyzer", "node"));
        }
        if (nulls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nulls", "com/intellij/slicer/SliceNullnessAnalyzer", "node"));
        }
        return nulls.get(node);
    }

    private static Collection<PsiElement> group(@NotNull SliceNode node, @NotNull Map<SliceNode, NullAnalysisResult> nulls, int group) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/slicer/SliceNullnessAnalyzer", "group"));
        }
        if (nulls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nulls", "com/intellij/slicer/SliceNullnessAnalyzer", "group"));
        }
        return nulls.get((Object)node).groupedByValue[group];
    }

    @NotNull
    public static NullAnalysisResult calcNullableLeaves(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final @NotNull Map<SliceNode, NullAnalysisResult> map2) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/slicer/SliceNullnessAnalyzer", "calcNullableLeaves"));
        }
        if (treeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeStructure", "com/intellij/slicer/SliceNullnessAnalyzer", "calcNullableLeaves"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/slicer/SliceNullnessAnalyzer", "calcNullableLeaves"));
        }
        final SliceLeafAnalyzer.SliceNodeGuide guide = new SliceLeafAnalyzer.SliceNodeGuide(treeStructure);
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            public void visit(@NotNull SliceNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceNullnessAnalyzer$3", "visit"));
                }
                element.calculateDupNode();
                SliceNullnessAnalyzer.node(element, map2).clear();
                SliceNode duplicate = element.getDuplicate();
                if (duplicate != null) {
                    SliceNullnessAnalyzer.node(element, map2).add(SliceNullnessAnalyzer.node(duplicate, map2));
                } else {
                    PsiElement value2 = (PsiElement)ReadAction.compute(() -> {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceNullnessAnalyzer$3", "lambda$visit$0"));
                        }
                        return ((SliceUsage)((Object)((Object)element.getValue()))).getElement();
                    });
                    Nullness nullness = (Nullness)((Object)ReadAction.compute(() -> SliceNullnessAnalyzer.checkNullness(value2)));
                    if (nullness == Nullness.NULLABLE) {
                        SliceNullnessAnalyzer.group(element, map2, 0).add(value2);
                    } else if (nullness == Nullness.NOT_NULL) {
                        SliceNullnessAnalyzer.group(element, map2, 1).add(value2);
                    } else {
                        Collection children2 = (Collection)ReadAction.compute(() -> {
                            if (element == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceNullnessAnalyzer$3", "lambda$visit$2"));
                            }
                            return element.getChildren();
                        });
                        if (children2.isEmpty()) {
                            SliceNullnessAnalyzer.group(element, map2, 2).add(value2);
                        }
                        super.visit((Object)element);
                    }
                }
            }

            public void elementFinished(@NotNull SliceNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceNullnessAnalyzer$3", "elementFinished"));
                }
                SliceNode parent = guide.getParent(element);
                if (parent != null) {
                    SliceNullnessAnalyzer.node(parent, map2).add(SliceNullnessAnalyzer.node(element, map2));
                }
            }
        };
        walkingState.visit((Object)root);
        NullAnalysisResult nullAnalysisResult = SliceNullnessAnalyzer.node(root, map2);
        if (nullAnalysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "calcNullableLeaves"));
        }
        return nullAnalysisResult;
    }

    @NotNull
    private static Nullness checkNullness(PsiElement element) {
        Nullness result2;
        PsiElement value2 = element;
        if (value2 instanceof PsiExpression) {
            value2 = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiExpression)value2));
        }
        if (value2 instanceof PsiLiteralExpression) {
            Nullness nullness = ((PsiLiteralExpression)value2).getValue() == null ? Nullness.NULLABLE : Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        if (value2 instanceof PsiNewExpression) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        if (value2 instanceof PsiThisExpression) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        if (value2 instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)value2).resolveMethod();
            if (method != null && NullableNotNullManager.isNotNull((PsiModifierListOwner)method)) {
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
                }
                return nullness;
            }
            if (method != null && NullableNotNullManager.isNullable((PsiModifierListOwner)method)) {
                Nullness nullness = Nullness.NULLABLE;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
                }
                return nullness;
            }
        }
        if (value2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)value2).getOperationTokenType() == JavaTokenType.PLUS) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        PsiElement context = value2;
        if (value2 instanceof PsiReference) {
            PsiElement resolved = ((PsiReference)value2).resolve();
            if (resolved instanceof PsiCompiledElement) {
                resolved = resolved.getNavigationElement();
            }
            value2 = resolved;
        }
        if (value2 instanceof PsiParameter && ((PsiParameter)value2).getDeclarationScope() instanceof PsiCatchSection) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        if ((value2 instanceof PsiLocalVariable || value2 instanceof PsiParameter) && (result2 = DfaUtil.checkNullness((PsiVariable)value2, context)) != Nullness.UNKNOWN) {
            Nullness nullness = result2;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        if (value2 instanceof PsiModifierListOwner) {
            if (NullableNotNullManager.isNotNull((PsiModifierListOwner)((PsiModifierListOwner)value2))) {
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
                }
                return nullness;
            }
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)((PsiModifierListOwner)value2))) {
                Nullness nullness = Nullness.NULLABLE;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
                }
                return nullness;
            }
        }
        if (value2 instanceof PsiEnumConstant) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
        }
        return nullness;
    }

    public static class NullAnalysisResult {
        static final int NULLS = 0;
        static final int NOT_NULLS = 1;
        static final int UNKNOWNS = 2;
        final Collection<PsiElement>[] groupedByValue = new Collection[]{new THashSet(), new THashSet(), new THashSet()};

        public void clear() {
            for (Collection<PsiElement> elements : this.groupedByValue) {
                elements.clear();
            }
        }

        private void add(NullAnalysisResult duplicate) {
            for (int i2 = 0; i2 < this.groupedByValue.length; ++i2) {
                Collection<PsiElement> elements = this.groupedByValue[i2];
                Collection<PsiElement> other = duplicate.groupedByValue[i2];
                elements.addAll(other);
            }
        }
    }
}

