/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSplitter
implements Splitter {
    public static final int MIN_RANGE_LENGTH = 3;

    protected static void addWord(@NotNull Consumer<TextRange> consumer, boolean ignore, @Nullable TextRange found) {
        boolean tooShort;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/inspections/BaseSplitter", "addWord"));
        }
        if (found == null || ignore) {
            return;
        }
        boolean bl = tooShort = found.getEndOffset() - found.getStartOffset() <= 3;
        if (tooShort) {
            return;
        }
        consumer.consume((Object)found);
    }

    protected static boolean isAllWordsAreUpperCased(@NotNull String text2, @NotNull List<TextRange> words) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/spellchecker/inspections/BaseSplitter", "isAllWordsAreUpperCased"));
        }
        if (words == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/intellij/spellchecker/inspections/BaseSplitter", "isAllWordsAreUpperCased"));
        }
        for (TextRange word : words) {
            StringCharacterIterator it = new StringCharacterIterator(text2, word.getStartOffset(), word.getEndOffset(), word.getStartOffset());
            char c = it.first();
            while (c != '\uffff') {
                if (!Character.isUpperCase(c)) {
                    return false;
                }
                c = it.next();
            }
        }
        return true;
    }

    protected static boolean containsShortWord(@NotNull List<TextRange> words) {
        if (words == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/intellij/spellchecker/inspections/BaseSplitter", "containsShortWord"));
        }
        for (TextRange word : words) {
            if (word.getLength() >= 3) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range, @NotNull Matcher matcher) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spellchecker/inspections/BaseSplitter", "matcherRange"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/spellchecker/inspections/BaseSplitter", "matcherRange"));
        }
        TextRange textRange = BaseSplitter.subRange(range, matcher.start(), matcher.end());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/BaseSplitter", "matcherRange"));
        }
        return textRange;
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range, @NotNull Matcher matcher, int group) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spellchecker/inspections/BaseSplitter", "matcherRange"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/spellchecker/inspections/BaseSplitter", "matcherRange"));
        }
        TextRange textRange = BaseSplitter.subRange(range, matcher.start(group), matcher.end(group));
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/BaseSplitter", "matcherRange"));
        }
        return textRange;
    }

    @NotNull
    protected static TextRange subRange(@NotNull TextRange range, int start, int end) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spellchecker/inspections/BaseSplitter", "subRange"));
        }
        TextRange textRange = TextRange.from((int)(range.getStartOffset() + start), (int)(end - start));
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/BaseSplitter", "subRange"));
        }
        return textRange;
    }

    protected static boolean badSize(int from, int till) {
        int l = till - from;
        return l <= 3;
    }

    @NotNull
    protected static List<TextRange> excludeByPattern(String text2, TextRange range, @NotNull Pattern toExclude, int groupToInclude) {
        int till;
        boolean addLast;
        int from;
        SmartList toCheck;
        block12: {
            SmartList smartList;
            if (toExclude == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toExclude", "com/intellij/spellchecker/inspections/BaseSplitter", "excludeByPattern"));
            }
            toCheck = new SmartList();
            from = range.getStartOffset();
            addLast = true;
            Matcher matcher = toExclude.matcher(StringUtil.newBombedCharSequence((CharSequence)range.substring(text2), (long)500L));
            try {
                while (matcher.find()) {
                    TextRange contentFound;
                    BaseSplitter.checkCancelled();
                    TextRange found = BaseSplitter.matcherRange(range, matcher);
                    till = found.getStartOffset();
                    if (range.getEndOffset() - found.getEndOffset() < 3) {
                        addLast = false;
                    }
                    if (!BaseSplitter.badSize(from, till)) {
                        toCheck.add(new TextRange(from, till));
                    }
                    if (groupToInclude > 0 && BaseSplitter.badSize((contentFound = BaseSplitter.matcherRange(range, matcher, groupToInclude)).getEndOffset(), contentFound.getStartOffset())) {
                        toCheck.add(TextRange.create((Segment)contentFound));
                    }
                    from = found.getEndOffset();
                }
                till = range.getEndOffset();
                if (!BaseSplitter.badSize(from, till)) break block12;
                smartList = toCheck;
            }
            catch (ProcessCanceledException e) {
                List<TextRange> list2 = Collections.singletonList(range);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/BaseSplitter", "excludeByPattern"));
                }
                return list2;
            }
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/BaseSplitter", "excludeByPattern"));
            }
            return smartList;
        }
        if (addLast) {
            toCheck.add(new TextRange(from, till));
        }
        SmartList smartList = toCheck;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/BaseSplitter", "excludeByPattern"));
        }
        return smartList;
    }

    public static void checkCancelled() {
        if (ApplicationManager.getApplication() != null) {
            ProgressIndicatorProvider.checkCanceled();
        }
    }
}

