/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import icons.SpellcheckerIcons;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShowSuggestions
implements LocalQuickFix,
Iconable {
    private List<String> suggestions;
    private boolean processed;
    private final String myWordWithTypo;

    public ShowSuggestions(String wordWithTypo) {
        this.myWordWithTypo = wordWithTypo;
    }

    @NotNull
    public List<String> getSuggestions(Project project2) {
        if (!this.processed) {
            this.suggestions = SpellCheckerManager.getInstance(project2).getSuggestions(this.myWordWithTypo);
            this.processed = true;
        }
        List<String> list2 = this.suggestions;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/ShowSuggestions", "getSuggestions"));
        }
        return list2;
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    @Nullable
    protected Editor getEditor(PsiElement element, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spellchecker/quickfixes/ShowSuggestions", "getEditor"));
        }
        Editor editor = ShowSuggestions.getEditorFromFocus();
        if (editor == null) {
            editor = InjectedLanguageUtil.openEditorFor(element.getContainingFile(), project2);
        }
        return editor;
    }

    @Nullable
    private static Editor getEditorFromFocus() {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c instanceof EditorComponentImpl) {
            return ((EditorComponentImpl)c).getEditor();
        }
        return null;
    }
}

