/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.ide.highlighter.custom.CustomFileTypeLexer;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

class CustomFileTypeTokenizer
extends Tokenizer<PsiElement> {
    private final SyntaxTable mySyntaxTable;

    public CustomFileTypeTokenizer(@NotNull SyntaxTable syntaxTable) {
        if (syntaxTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxTable", "com/intellij/spellchecker/tokenizer/CustomFileTypeTokenizer", "<init>"));
        }
        this.mySyntaxTable = syntaxTable;
    }

    @Override
    public void tokenize(@NotNull PsiElement element, TokenConsumer consumer) {
        IElementType tokenType;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/tokenizer/CustomFileTypeTokenizer", "tokenize"));
        }
        CustomFileTypeLexer lexer = new CustomFileTypeLexer(this.mySyntaxTable);
        String text2 = element.getText();
        lexer.start(text2);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (!CustomFileTypeTokenizer.isKeyword(tokenType)) {
                consumer.consumeToken(element, text2, false, 0, new TextRange(lexer.getTokenStart(), lexer.getTokenEnd()), PlainTextSplitter.getInstance());
            }
            lexer.advance();
        }
    }

    private static boolean isKeyword(IElementType tokenType) {
        return tokenType == CustomHighlighterTokenType.KEYWORD_1 || tokenType == CustomHighlighterTokenType.KEYWORD_2 || tokenType == CustomHighlighterTokenType.KEYWORD_3 || tokenType == CustomHighlighterTokenType.KEYWORD_4;
    }
}

