/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class PsiIdentifierOwnerTokenizer
extends Tokenizer<PsiNameIdentifierOwner> {
    @Override
    public void tokenize(@NotNull PsiNameIdentifierOwner element, TokenConsumer consumer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/tokenizer/PsiIdentifierOwnerTokenizer", "tokenize"));
        }
        PsiElement identifier = element.getNameIdentifier();
        if (identifier == null) {
            return;
        }
        PsiNameIdentifierOwner parent = element;
        TextRange range = identifier.getTextRange();
        if (range.isEmpty()) {
            return;
        }
        int offset = range.getStartOffset() - parent.getTextRange().getStartOffset();
        if (offset < 0) {
            parent = PsiTreeUtil.findCommonParent((PsiElement)identifier, (PsiElement)element);
            offset = range.getStartOffset() - parent.getTextRange().getStartOffset();
        }
        String text2 = identifier.getText();
        consumer.consumeToken((PsiElement)parent, text2, true, offset, TextRange.allOf((String)text2), IdentifierSplitter.getInstance());
    }
}

