/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.text.StringCharacterIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Strings {
    private Strings() {
    }

    public static boolean isCapitalized(String word) {
        if (word.length() == 0) {
            return false;
        }
        boolean lowCase = true;
        for (int i2 = 1; i2 < word.length() && lowCase; ++i2) {
            lowCase = Character.isLowerCase(word.charAt(i2));
        }
        return Character.isUpperCase(word.charAt(0)) && lowCase;
    }

    public static boolean isCapitalized(@NotNull String text2, @NotNull TextRange range) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/spellchecker/util/Strings", "isCapitalized"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spellchecker/util/Strings", "isCapitalized"));
        }
        if (range.getLength() == 0) {
            return false;
        }
        StringCharacterIterator it = new StringCharacterIterator(text2, range.getStartOffset() + 1, range.getEndOffset(), range.getStartOffset() + 1);
        boolean lowCase = true;
        char c = it.first();
        while (c != '\uffff') {
            lowCase = Character.isLowerCase(c);
            c = it.next();
        }
        return Character.isUpperCase(text2.charAt(range.getStartOffset())) && lowCase;
    }

    public static boolean isUpperCased(@NotNull String text2, @NotNull TextRange range) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/spellchecker/util/Strings", "isUpperCased"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spellchecker/util/Strings", "isUpperCased"));
        }
        if (range.getLength() == 0) {
            return false;
        }
        StringCharacterIterator it = new StringCharacterIterator(text2, range.getStartOffset(), range.getEndOffset(), range.getStartOffset());
        char c = it.first();
        while (c != '\uffff') {
            if (!Character.isUpperCase(c)) {
                return false;
            }
            c = it.next();
        }
        return true;
    }

    public static boolean isUpperCase(String word) {
        boolean upperCase = true;
        for (int i2 = 0; i2 < word.length() && upperCase; ++i2) {
            upperCase = Character.isUpperCase(word.charAt(i2));
        }
        return upperCase;
    }

    public static boolean isMixedCase(String word) {
        String lowerCase;
        if (word.length() < 2) {
            return false;
        }
        String tail = word.substring(1);
        return !tail.equals(lowerCase = tail.toLowerCase()) && !Strings.isUpperCase(word);
    }

    public static void capitalize(List<String> words) {
        for (int i2 = 0; i2 < words.size(); ++i2) {
            words.set(i2, StringUtil.capitalize((String)words.get(i2)));
        }
    }

    public static void upperCase(List<String> words) {
        for (int i2 = 0; i2 < words.size(); ++i2) {
            words.set(i2, words.get(i2).toUpperCase());
        }
    }
}

