/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPIFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    public static final SPIFileType INSTANCE = new SPIFileType();

    private SPIFileType() {
        super((Language)SPILanguage.INSTANCE);
    }

    @Override
    public boolean isMyFileType(@NotNull VirtualFile file2) {
        VirtualFile gParent;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spi/SPIFileType", "isMyFileType"));
        }
        VirtualFile parent = file2.getParent();
        if (parent != null && Comparing.equal((CharSequence)"services", (CharSequence)parent.getNameSequence()) && (gParent = parent.getParent()) != null && Comparing.equal((CharSequence)"META-INF", (CharSequence)gParent.getNameSequence())) {
            String fileName = file2.getName();
            for (Object condition2 : Extensions.getExtensions((String)"com.intellij.vetoSPICondition")) {
                if (!((Condition)condition2).value((Object)fileName)) continue;
                return false;
            }
            return FileTypeRegistry.getInstance().getFileTypeByFileName(fileName) == FileTypes.UNKNOWN;
        }
        return false;
    }

    @NotNull
    public String getName() {
        if ("SPI" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spi/SPIFileType", "getName"));
        }
        return "SPI";
    }

    @NotNull
    public String getDescription() {
        if ("Service Provider Interface" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spi/SPIFileType", "getDescription"));
        }
        return "Service Provider Interface";
    }

    @NotNull
    public String getDefaultExtension() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spi/SPIFileType", "getDefaultExtension"));
        }
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Nullable
    public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spi/SPIFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/spi/SPIFileType", "getCharset"));
        }
        return "UTF-8";
    }
}

