/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.iterators.HierarchyNodeIterator;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;

public class ExprTypePredicate
extends MatchPredicate {
    private final RegExpPredicate delegate;
    private final boolean withinHierarchy;

    public ExprTypePredicate(String type2, String baseName, boolean _withinHierarchy, boolean caseSensitiveMatch, boolean target2) {
        this.delegate = new RegExpPredicate(type2, caseSensitiveMatch, baseName, false, target2);
        this.withinHierarchy = _withinHierarchy;
    }

    @Override
    public boolean match(PsiElement match, int start, int end, MatchContext context) {
        if (match instanceof PsiIdentifier) {
            match = match.getParent();
        } else if (match instanceof PsiExpressionStatement) {
            match = ((PsiExpressionStatement)match).getExpression();
        }
        if (!(match instanceof PsiExpression)) {
            return false;
        }
        PsiType type2 = this.evalType((PsiExpression)match, context);
        return type2 != null && this.doMatchWithTheType(type2, context, match);
    }

    protected PsiType evalType(PsiExpression match, MatchContext context) {
        PsiElement parent;
        if (match instanceof PsiReferenceExpression && (parent = match.getParent()) instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)parent).getType();
        }
        return match.getType();
    }

    private boolean doMatchWithTheType(PsiType type2, MatchContext context, PsiElement matchedNode) {
        PsiClass clazz;
        if (type2 instanceof PsiClassType && (clazz = ((PsiClassType)type2).resolve()) != null) {
            return this.checkClass(clazz, context);
        }
        if (type2 != null) {
            PsiClass clazz2;
            String presentableText = type2.getPresentableText();
            boolean result2 = this.delegate.doMatch(presentableText, context, matchedNode);
            if (!result2 && type2 instanceof PsiArrayType && ((PsiArrayType)type2).getComponentType() instanceof PsiClassType && (clazz2 = ((PsiClassType)((PsiArrayType)type2).getComponentType()).resolve()) != null) {
                result2 = this.delegate.doMatch(clazz2.getQualifiedName() + "[]", context, matchedNode);
            }
            return result2;
        }
        return false;
    }

    private boolean checkClass(PsiClass clazz, MatchContext context) {
        if (this.withinHierarchy) {
            HierarchyNodeIterator parents = new HierarchyNodeIterator((PsiElement)clazz, true, true);
            while (((NodeIterator)parents).hasNext() && !this.delegate.match(((NodeIterator)parents).current(), context)) {
                ((NodeIterator)parents).advance();
            }
            return ((NodeIterator)parents).hasNext();
        }
        return this.delegate.match((PsiElement)clazz, context);
    }
}

