/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class RegExpPredicate
extends MatchPredicate {
    private Pattern pattern;
    private final String baseHandlerName;
    private boolean simpleString;
    private final boolean couldBeOptimized;
    private final String regexp;
    private final boolean caseSensitive;
    private boolean multiline;
    private final boolean wholeWords;
    private final boolean target;
    private NodeTextGenerator myNodeTextGenerator;

    public RegExpPredicate(String regexp, boolean caseSensitive, String _baseHandlerName, boolean _wholeWords, boolean _target) {
        boolean bl = this.couldBeOptimized = !StructuralSearchUtil.containsRegExpMetaChar(regexp);
        if (!_wholeWords) {
            this.simpleString = this.couldBeOptimized;
        }
        this.regexp = regexp;
        this.caseSensitive = caseSensitive;
        this.wholeWords = _wholeWords;
        this.baseHandlerName = _baseHandlerName;
        if (!this.simpleString) {
            this.compilePattern();
        }
        this.target = _target;
    }

    private void compilePattern() {
        try {
            String realRegexp = this.regexp;
            if (this.wholeWords) {
                realRegexp = ".*?\\b(?:" + realRegexp + ")\\b.*?";
            }
            this.pattern = Pattern.compile(realRegexp, (this.caseSensitive ? 0 : 2) | (this.multiline ? 32 : 0));
        }
        catch (PatternSyntaxException ex) {
            throw new MalformedPatternException(SSRBundle.message("error.incorrect.regexp.constraint", this.regexp, this.baseHandlerName));
        }
    }

    public boolean couldBeOptimized() {
        return this.couldBeOptimized;
    }

    public String getRegExp() {
        return this.regexp;
    }

    @Override
    public boolean match(PsiElement matchedNode, int start, int end, MatchContext context) {
        if (matchedNode == null) {
            return false;
        }
        String text2 = this.myNodeTextGenerator != null ? this.myNodeTextGenerator.getText(matchedNode) : RegExpPredicate.getMeaningfulText(matchedNode);
        boolean result2 = this.doMatch(text2, start, end, context, matchedNode);
        if (!result2) {
            matchedNode = StructuralSearchUtil.getParentIfIdentifier(matchedNode);
            String alternativeText = context.getPattern().getAlternativeTextToMatch(matchedNode, text2);
            if (alternativeText != null) {
                result2 = this.doMatch(alternativeText, start, end, context, matchedNode);
            }
        }
        return result2;
    }

    public static String getMeaningfulText(PsiElement matchedNode) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile2 != null ? profile2.getMeaningfulText(matchedNode) : matchedNode.getText();
    }

    boolean doMatch(String text2, MatchContext context, PsiElement matchedElement) {
        return this.doMatch(text2, 0, -1, context, matchedElement);
    }

    boolean doMatch(String text2, int from, int end, MatchContext context, PsiElement matchedElement) {
        Matcher matcher;
        if (from > 0 || end != -1) {
            text2 = text2.substring(from, end == -1 || end >= text2.length() ? text2.length() : end);
        }
        if (this.simpleString) {
            return this.caseSensitive ? text2.equals(this.regexp) : text2.equalsIgnoreCase(this.regexp);
        }
        if (!this.multiline && text2.contains("\n")) {
            this.setMultiline(true);
        }
        if ((matcher = this.pattern.matcher(text2)).matches()) {
            for (int i2 = 1; i2 <= matcher.groupCount(); ++i2) {
                context.getResult().addSon(new MatchResultImpl(this.baseHandlerName + "_" + i2, matcher.group(i2), new SmartPsiPointer(matchedElement), matcher.start(i2), matcher.end(i2), this.target));
            }
            return true;
        }
        return false;
    }

    public void setNodeTextGenerator(NodeTextGenerator nodeTextGenerator) {
        this.myNodeTextGenerator = nodeTextGenerator;
    }

    public void setMultiline(boolean b) {
        this.multiline = b;
        this.compilePattern();
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public static interface NodeTextGenerator {
        public String getText(PsiElement var1);
    }
}

