/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.terminal.AppendableTerminalDataStream;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ProcessHandlerTtyConnector;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalKeyEncoder;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.ui.TerminalSession;
import java.awt.Color;
import java.io.IOException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalExecutionConsole
implements ConsoleView {
    private JBTerminalWidget myTerminalWidget;
    private Project myProject;
    private final AppendableTerminalDataStream myDataStream;
    private final TerminalKeyEncoder myKeyEncoder;

    public TerminalExecutionConsole(@NotNull Project project2, @NotNull ProcessHandler processHandler2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/terminal/TerminalExecutionConsole", "<init>"));
        }
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/terminal/TerminalExecutionConsole", "<init>"));
        }
        this.myKeyEncoder = new TerminalKeyEncoder();
        this.myKeyEncoder.setAutoNewLine(true);
        this.myProject = project2;
        JBTerminalSystemSettingsProviderBase provider = new JBTerminalSystemSettingsProviderBase(){

            public HyperlinkStyle.HighlightMode getHyperlinkHighlightingMode() {
                return HyperlinkStyle.HighlightMode.ALWAYS;
            }
        };
        this.myDataStream = new AppendableTerminalDataStream();
        this.myTerminalWidget = new JBTerminalWidget(project2, 200, 24, provider, (Disposable)this){

            @Override
            protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
                return new TerminalStarter((Terminal)terminal, connector, TerminalExecutionConsole.this.myDataStream){

                    public byte[] getCode(int key2, int modifiers) {
                        if (key2 == 10) {
                            return TerminalExecutionConsole.this.myKeyEncoder.getCode(key2, modifiers);
                        }
                        return super.getCode(key2, modifiers);
                    }
                };
            }
        };
        final TerminalSession session2 = this.myTerminalWidget.createTerminalSession(new ProcessHandlerTtyConnector(processHandler2, EncodingProjectManager.getInstance((Project)project2).getDefaultCharset()));
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                session2.start();
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                try {
                    ConsoleViewContentType contentType = null;
                    if (outputType != ProcessOutputTypes.STDOUT) {
                        contentType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                    }
                    TerminalExecutionConsole.this.printText(event.getText(), contentType);
                    if (outputType == ProcessOutputTypes.SYSTEM) {
                        TerminalExecutionConsole.this.myDataStream.append('\r');
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void processTerminated(ProcessEvent event) {
                TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().setCursorVisible(false);
            }
        });
    }

    private void printText(@NotNull String text2, @Nullable ConsoleViewContentType contentType) throws IOException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/terminal/TerminalExecutionConsole", "printText"));
        }
        if (contentType != null) {
            this.myDataStream.append(TerminalExecutionConsole.encodeColor(contentType.getAttributes().getForegroundColor()));
        }
        this.myDataStream.append(text2);
        if (contentType != null) {
            this.myDataStream.append("\u001b[39m");
        }
    }

    private static String encodeColor(Color color) {
        return String.valueOf('\u001b') + "[38;2;" + color.getRed() + ";" + color.getGreen() + ";" + color.getBlue() + "m";
    }

    public void addMessageFilter(Project project2, Filter filter) {
        this.myTerminalWidget.addMessageFilter(project2, filter);
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/terminal/TerminalExecutionConsole", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/terminal/TerminalExecutionConsole", "print"));
        }
        this.myTerminalWidget.getTerminal().writeCharacters(text2);
    }

    public void clear() {
        this.myTerminalWidget.getTerminal().clearScreen();
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler2) {
    }

    public void setOutputPaused(boolean value2) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/terminal/TerminalExecutionConsole", "performWhenNoDeferredOutput"));
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/terminal/TerminalExecutionConsole", "setHelpId"));
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/terminal/TerminalExecutionConsole", "addMessageFilter"));
        }
        this.addMessageFilter(this.myProject, filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinkText", "com/intellij/terminal/TerminalExecutionConsole", "printHyperlink"));
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/terminal/TerminalExecutionConsole", "createConsoleActions"));
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public void dispose() {
        this.myTerminalWidget = null;
    }
}

