/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.testFramework.ApplicationRule;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.FixtureRuleKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.ProjectRule;
import com.intellij.testFramework.TemporaryDirectoryKt;
import com.intellij.util.io.PathKt;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/ProjectRule;", "Lcom/intellij/testFramework/ApplicationRule;", "projectDescriptor", "Lcom/intellij/testFramework/LightProjectDescriptor;", "(Lcom/intellij/testFramework/LightProjectDescriptor;)V", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/ex/ProjectEx;", "getProject", "()Lcom/intellij/openapi/project/ex/ProjectEx;", "getProjectDescriptor", "()Lcom/intellij/testFramework/LightProjectDescriptor;", "projectIfOpened", "getProjectIfOpened", "after", "", "Companion", "testFramework"})
public final class ProjectRule
extends ApplicationRule {
    @NotNull
    private final LightProjectDescriptor projectDescriptor;
    private static ProjectEx sharedProject;
    private static final AtomicBoolean projectOpened;
    public static final Companion Companion;

    public void after() {
        block1: {
            if (!ProjectRule.Companion.getProjectOpened().compareAndSet(true, false)) break block1;
            ProjectEx projectEx = ProjectRule.Companion.getSharedProject();
            if (projectEx != null) {
                ProjectEx projectEx2;
                ProjectEx it = projectEx2 = projectEx;
                EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)new Function0<Unit>(it){
                    final /* synthetic */ ProjectEx $it;

                    public final void invoke() {
                        ProjectManager projectManager = ProjectManager.getInstance();
                        if (projectManager == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.project.impl.ProjectManagerImpl");
                        }
                        ((ProjectManagerImpl)projectManager).forceCloseProject(this.$it, false);
                    }
                    {
                        this.$it = projectEx;
                        super(0);
                    }
                }));
            }
        }
    }

    @Nullable
    public final ProjectEx getProjectIfOpened() {
        return ProjectRule.Companion.getProjectOpened().get() ? ProjectRule.Companion.getSharedProject() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ProjectEx getProject() {
        ProjectEx result2 = ProjectRule.Companion.getSharedProject();
        if (result2 == null) {
            IdeaTestApplication ideaTestApplication = IdeaTestApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideaTestApplication, (String)"IdeaTestApplication.getInstance()");
            IdeaTestApplication ideaTestApplication2 = ideaTestApplication;
            synchronized (ideaTestApplication2) {
                result2 = ProjectRule.Companion.getSharedProject();
                if (result2 == null) {
                    result2 = ProjectRule.Companion.createLightProject();
                    ProjectRule.Companion.setSharedProject(result2);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        if (ProjectRule.Companion.getProjectOpened().compareAndSet(false, true)) {
            EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ProjectRule this$0;

                public final void invoke() {
                    ProjectManagerEx.getInstanceEx().openTestProject(this.this$0.getProject());
                }
                {
                    this.this$0 = projectRule;
                    super(0);
                }
            }));
        }
        ProjectEx projectEx = result2;
        if (projectEx == null) {
            Intrinsics.throwNpe();
        }
        return projectEx;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Module getModule() {
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = FixtureRuleKt.access$getSharedModule$p();
        if ((Module)result2.element == null) {
            EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)new Function0<Unit>(this, (Ref.ObjectRef)result2){
                final /* synthetic */ ProjectRule this$0;
                final /* synthetic */ Ref.ObjectRef $result;

                public final void invoke() {
                    this.this$0.getProjectDescriptor().setUpProject(this.this$0.getProject(), new LightProjectDescriptor.SetupHandler(this){
                        final /* synthetic */ module.1 this$0;

                        public void moduleCreated(@NotNull Module module2) {
                            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
                            this.this$0.$result.element = module2;
                            FixtureRuleKt.access$setSharedModule$p(module2);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    });
                }
                {
                    this.this$0 = projectRule;
                    this.$result = objectRef;
                    super(0);
                }
            }));
        }
        Module module2 = (Module)result2.element;
        if (module2 == null) {
            Intrinsics.throwNpe();
        }
        return module2;
    }

    @NotNull
    public final LightProjectDescriptor getProjectDescriptor() {
        return this.projectDescriptor;
    }

    public ProjectRule(@NotNull LightProjectDescriptor projectDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)projectDescriptor, (String)"projectDescriptor");
        this.projectDescriptor = projectDescriptor;
    }

    public /* synthetic */ ProjectRule(LightProjectDescriptor lightProjectDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            lightProjectDescriptor = new LightProjectDescriptor();
        }
        this(lightProjectDescriptor);
    }

    public ProjectRule() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        projectOpened = new AtomicBoolean();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/testFramework/ProjectRule$Companion;", "", "()V", "projectOpened", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getProjectOpened", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "sharedProject", "Lcom/intellij/openapi/project/ex/ProjectEx;", "getSharedProject", "()Lcom/intellij/openapi/project/ex/ProjectEx;", "setSharedProject", "(Lcom/intellij/openapi/project/ex/ProjectEx;)V", "createLightProject", "disposeProject", "", "testFramework"})
    public static final class Companion {
        private final ProjectEx getSharedProject() {
            return sharedProject;
        }

        private final void setSharedProject(ProjectEx projectEx) {
            sharedProject = projectEx;
        }

        private final AtomicBoolean getProjectOpened() {
            return projectOpened;
        }

        private final ProjectEx createLightProject() {
            PersistentFS persistentFS = PersistentFS.getInstance();
            if (persistentFS == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl");
            }
            ((PersistentFSImpl)persistentFS).cleanPersistedContents();
            Path projectFile = TemporaryDirectoryKt.generateTemporaryPath("light_temp_shared_project.ipr");
            String projectPath = PathKt.getSystemIndependentPath((Path)projectFile);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            new Throwable(projectPath, null).printStackTrace(new PrintStream(buffer));
            Project project2 = PlatformTestCase.createProject(projectPath, "Light project: " + buffer);
            if (project2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.project.ex.ProjectEx");
            }
            ProjectEx project3 = (ProjectEx)project2;
            PlatformTestUtil.registerProjectCleanup(new Runnable(projectFile){
                final /* synthetic */ Path $projectFile;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        com.intellij.testFramework.ProjectRule$Companion.access$disposeProject(ProjectRule.Companion);
                    }
                    finally {
                        Files.deleteIfExists(this.$projectFile);
                    }
                }
                {
                    this.$projectFile = path;
                }
            });
            VirtualFilePointerManager virtualFilePointerManager = VirtualFilePointerManager.getInstance();
            if (virtualFilePointerManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl");
            }
            ((VirtualFilePointerManagerImpl)virtualFilePointerManager).storePointers();
            return project3;
        }

        private final void disposeProject() {
            ProjectEx projectEx = this.getSharedProject();
            if (projectEx == null) {
                return;
            }
            ProjectEx project2 = projectEx;
            this.setSharedProject(null);
            FixtureRuleKt.access$setSharedModule$p(null);
            ProjectManager projectManager = ProjectManager.getInstance();
            if (projectManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.project.impl.ProjectManagerImpl");
            }
            ((ProjectManagerImpl)projectManager).forceCloseProject(project2, true);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$disposeProject(Companion $this) {
            $this.disposeProject();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

