/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.tools.FilterDialog;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class OutputFiltersDialog
extends DialogWrapper {
    private final DefaultListModel myFiltersModel = new DefaultListModel();
    private final JList myFiltersList = new JBList((ListModel)this.myFiltersModel);
    private boolean myModified = false;
    private FilterInfo[] myFilters;

    public OutputFiltersDialog(Component parent, FilterInfo[] filters) {
        super(parent, true);
        this.myFilters = filters;
        this.setTitle(ToolsBundle.message("tools.filters.title", new Object[0]));
        this.init();
        this.initGui();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/OutputFiltersDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.settings.ide.settings.external.tools.output.filters");
    }

    private void initGui() {
        this.myFiltersList.setSelectionMode(0);
        this.myFiltersList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/tools/OutputFiltersDialog$1", "customizeCellRenderer"));
                }
                FilterInfo info = (FilterInfo)value2;
                this.append(info.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        });
        ScrollingUtil.ensureSelectionExists((JList)this.myFiltersList);
    }

    private String suggestFilterName() {
        String prefix = ToolsBundle.message("tools.filters.name.template", new Object[0]) + " ";
        int number = 1;
        for (int i2 = 0; i2 < this.myFiltersModel.getSize(); ++i2) {
            FilterInfo wrapper = (FilterInfo)this.myFiltersModel.getElementAt(i2);
            String name2 = wrapper.getName();
            if (!name2.startsWith(prefix)) continue;
            try {
                int n = Integer.valueOf(name2.substring(prefix.length()).trim());
                number = Math.max(number, n + 1);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return prefix + number;
    }

    protected void doOKAction() {
        if (this.myModified) {
            this.myFilters = new FilterInfo[this.myFiltersModel.getSize()];
            for (int i2 = 0; i2 < this.myFiltersModel.getSize(); ++i2) {
                this.myFilters[i2] = (FilterInfo)this.myFiltersModel.get(i2);
            }
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        for (FilterInfo myFilter : this.myFilters) {
            this.myFiltersModel.addElement(myFilter.createCopy());
        }
        JPanel panel2 = ToolbarDecorator.createDecorator((JList)this.myFiltersList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.setName(OutputFiltersDialog.this.suggestFilterName());
                boolean wasCreated = FilterDialog.editFilter(filterInfo, OutputFiltersDialog.this.myFiltersList, ToolsBundle.message("tools.filters.add.title", new Object[0]));
                if (wasCreated) {
                    OutputFiltersDialog.this.myFiltersModel.addElement(filterInfo);
                    OutputFiltersDialog.this.setModified(true);
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)OutputFiltersDialog.this.myFiltersList, true));
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int index = OutputFiltersDialog.this.myFiltersList.getSelectedIndex();
                FilterInfo filterInfo = (FilterInfo)OutputFiltersDialog.this.myFiltersModel.getElementAt(index);
                boolean wasEdited = FilterDialog.editFilter(filterInfo, OutputFiltersDialog.this.myFiltersList, ToolsBundle.message("tools.filters.edit.title", new Object[0]));
                if (wasEdited) {
                    OutputFiltersDialog.this.setModified(true);
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)OutputFiltersDialog.this.myFiltersList, true));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (OutputFiltersDialog.this.myFiltersList.getSelectedIndex() >= 0) {
                    OutputFiltersDialog.this.myFiltersModel.removeElementAt(OutputFiltersDialog.this.myFiltersList.getSelectedIndex());
                    OutputFiltersDialog.this.setModified(true);
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)OutputFiltersDialog.this.myFiltersList, true));
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int movedCount = ListUtil.moveSelectedItemsUp((JList)OutputFiltersDialog.this.myFiltersList);
                if (movedCount > 0) {
                    OutputFiltersDialog.this.setModified(true);
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)OutputFiltersDialog.this.myFiltersList, true));
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int movedCount = ListUtil.moveSelectedItemsDown((JList)OutputFiltersDialog.this.myFiltersList);
                if (movedCount > 0) {
                    OutputFiltersDialog.this.setModified(true);
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)OutputFiltersDialog.this.myFiltersList, true));
            }
        }).createPanel();
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFiltersList;
    }

    private void setModified(boolean modified) {
        this.myModified = modified;
    }

    public FilterInfo[] getData() {
        return this.myFilters;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.tools.OutputFiltersDialog";
    }
}

