/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.ColorChooser;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TwoColorsIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private final ElementColorProvider[] myExtensions = (ElementColorProvider[])ElementColorProvider.EP_NAME.getExtensions();

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ui/ColorLineMarkerProvider", "getLineMarkerInfo"));
        }
        for (ElementColorProvider colorProvider : this.myExtensions) {
            Color color = colorProvider.getColorFrom(element);
            if (color == null) continue;
            MyInfo info = new MyInfo(element, color, colorProvider);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)"Choose color", null);
            return info;
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ui/ColorLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ui/ColorLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }

    public String getName() {
        return "Color preview";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Gutter.Colors;
    }

    private static class MyInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private final Color myColor;

        public MyInfo(@NotNull PsiElement element, final Color color, final ElementColorProvider colorProvider) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ui/ColorLineMarkerProvider$MyInfo", "<init>"));
            }
            super(element, element.getTextRange(), (Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(12, color)), 11, (Function)FunctionUtil.nullConstant(), (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(){

                public void navigate(MouseEvent e, PsiElement elt) {
                    if (!elt.isWritable()) {
                        return;
                    }
                    Editor editor = PsiUtilBase.findEditor((PsiElement)elt);
                    assert (editor != null);
                    Color c = ColorChooser.chooseColor((Component)editor.getComponent(), (String)"Choose Color", (Color)color, (boolean)true);
                    if (c != null) {
                        WriteAction.run(() -> colorProvider.setColorTo(elt, c));
                    }
                }
            }, GutterIconRenderer.Alignment.LEFT);
            this.myColor = color;
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/ui/ColorLineMarkerProvider$MyInfo", "canMergeWith"));
            }
            return info instanceof MyInfo;
        }

        public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/ui/ColorLineMarkerProvider$MyInfo", "getCommonIcon"));
            }
            if (infos.size() == 2 && infos.get(0) instanceof MyInfo && infos.get(1) instanceof MyInfo) {
                return JBUI.scale((JBUI.JBIcon)new TwoColorsIcon(12, ((MyInfo)infos.get((int)0)).myColor, ((MyInfo)infos.get((int)1)).myColor));
            }
            return AllIcons.Gutter.Colors;
        }

        @NotNull
        public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/ui/ColorLineMarkerProvider$MyInfo", "getCommonTooltip"));
            }
            NullableFunction nullableFunction = FunctionUtil.nullConstant();
            if (nullableFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/ColorLineMarkerProvider$MyInfo", "getCommonTooltip"));
            }
            return nullableFunction;
        }
    }
}

