/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorPickerListener;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColorPickerListenerFactory {
    private static final ExtensionPointName<ColorPickerListenerFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.colorPickerListenerFactory");

    @NotNull
    public static List<ColorPickerListener> createListenersFor(@Nullable PsiElement element) {
        List listeners = null;
        for (ColorPickerListenerFactory factory : (ColorPickerListenerFactory[])EP_NAME.getExtensions()) {
            ColorPickerListener listener2 = factory.createListener(element);
            if (listener2 == null) continue;
            if (listeners == null) {
                listeners = new SmartList();
            }
            listeners.add(listener2);
        }
        List list2 = ContainerUtil.notNullize(listeners);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/ColorPickerListenerFactory", "createListenersFor"));
        }
        return list2;
    }

    @Nullable
    public abstract ColorPickerListener createListener(@Nullable PsiElement var1);
}

