/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import com.intellij.util.LocalTimeCounter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageTextField
extends EditorTextField {
    private final Language myLanguage;
    private final Project myProject;

    public LanguageTextField() {
        this(null, null, "");
    }

    public LanguageTextField(Language language, @Nullable Project project2, @NotNull String value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        this(language, project2, value2, true);
    }

    public LanguageTextField(Language language, @Nullable Project project2, @NotNull String value2, boolean oneLineMode) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        this(language, project2, value2, new SimpleDocumentCreator(), oneLineMode);
    }

    public LanguageTextField(@Nullable Language language, @Nullable Project project2, @NotNull String value2, @NotNull DocumentCreator documentCreator) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        if (documentCreator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentCreator", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        this(language, project2, value2, documentCreator, true);
    }

    public LanguageTextField(@Nullable Language language, @Nullable Project project2, @NotNull String value2, @NotNull DocumentCreator documentCreator, boolean oneLineMode) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        if (documentCreator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentCreator", "com/intellij/ui/LanguageTextField", "<init>"));
        }
        super(documentCreator.createDocument(value2, language, project2), project2, (FileType)(language != null ? language.getAssociatedFileType() : StdFileTypes.PLAIN_TEXT), language == null, oneLineMode);
        this.myLanguage = language;
        this.myProject = project2;
        this.setEnabled(language != null);
    }

    public static Document createDocument(String value2, @Nullable Language language, Project project2, @NotNull SimpleDocumentCreator documentCreator) {
        if (documentCreator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentCreator", "com/intellij/ui/LanguageTextField", "createDocument"));
        }
        if (language != null) {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
            LanguageFileType fileType = language.getAssociatedFileType();
            assert (fileType != null);
            long stamp = LocalTimeCounter.currentTime();
            PsiFile psiFile = factory.createFileFromText("Dummy." + fileType.getDefaultExtension(), (FileType)fileType, (CharSequence)value2, stamp, true, false);
            documentCreator.customizePsiFile(psiFile);
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
            assert (document != null);
            return document;
        }
        return EditorFactory.getInstance().createDocument((CharSequence)value2);
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx ex = super.createEditor();
        if (this.myLanguage != null) {
            LanguageFileType fileType = this.myLanguage.getAssociatedFileType();
            ex.setHighlighter(HighlighterFactory.createHighlighter((Project)this.myProject, (FileType)fileType));
        }
        ex.setEmbeddedIntoDialogWrapper(true);
        return ex;
    }

    public static class SimpleDocumentCreator
    implements DocumentCreator {
        @Override
        public Document createDocument(String value2, @Nullable Language language, Project project2) {
            return LanguageTextField.createDocument(value2, language, project2, this);
        }

        public void customizePsiFile(PsiFile file2) {
        }
    }

    public static interface DocumentCreator {
        public Document createDocument(String var1, @Nullable Language var2, Project var3);
    }
}

