/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notification.impl.NotificationsConfigurable;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBRectangle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationBalloonActionProvider
implements BalloonImpl.ActionProvider {
    private final BalloonImpl myBalloon;
    private final BalloonLayoutData myLayoutData;
    private final String myDisplayGroupId;
    private final Component myRepaintPanel;
    private BalloonImpl.ActionButton mySettingButton;
    private BalloonImpl.ActionButton myCloseButton;
    private List<BalloonImpl.ActionButton> myActions;
    private static final Rectangle CloseHoverBounds = new JBRectangle(5, 5, 12, 10);

    public NotificationBalloonActionProvider(@NotNull BalloonImpl balloon, @Nullable Component repaintPanel, @NotNull BalloonLayoutData layoutData, @Nullable String displayGroupId) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/NotificationBalloonActionProvider", "<init>"));
        }
        if (layoutData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutData", "com/intellij/ui/NotificationBalloonActionProvider", "<init>"));
        }
        this.myLayoutData = layoutData;
        this.myDisplayGroupId = displayGroupId;
        this.myBalloon = balloon;
        this.myRepaintPanel = repaintPanel;
    }

    @Override
    @NotNull
    public List<BalloonImpl.ActionButton> createActions() {
        this.myActions = new ArrayList<BalloonImpl.ActionButton>();
        if (!this.myLayoutData.showSettingButton || this.myDisplayGroupId == null || !NotificationsConfigurationImpl.getInstanceImpl().isRegistered(this.myDisplayGroupId)) {
            this.mySettingButton = null;
        } else {
            BalloonImpl balloonImpl = this.myBalloon;
            balloonImpl.getClass();
            this.mySettingButton = new BalloonImpl.ActionButton(balloonImpl, AllIcons.Ide.Notification.Gear, AllIcons.Ide.Notification.GearHover, "Turn notification off or change its behavior", event -> this.myBalloon.runWithSmartFadeoutPause(() -> {
                NotificationsConfigurable configurable = new NotificationsConfigurable();
                ShowSettingsUtil.getInstance().editConfigurable(this.myLayoutData.project, (Configurable)configurable, () -> configurable.enableSearch(this.myDisplayGroupId).run());
            })){
                {
                    BalloonImpl balloonImpl = x0;
                    balloonImpl.getClass();
                    super(icon, hoverIcon, hint, (Consumer<MouseEvent>)listener2);
                }

                public void repaint() {
                    super.repaint();
                    if (NotificationBalloonActionProvider.this.myRepaintPanel != null) {
                        NotificationBalloonActionProvider.this.myRepaintPanel.repaint();
                    }
                }
            };
            this.myActions.add(this.mySettingButton);
            if (this.myRepaintPanel != null) {
                this.myLayoutData.showActions = () -> {
                    for (BalloonImpl.ActionButton action : this.myActions) {
                        if (action.isShowing() && action.hasPaint()) continue;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                };
            }
        }
        BalloonImpl balloonImpl = this.myBalloon;
        balloonImpl.getClass();
        this.myCloseButton = new BalloonImpl.ActionButton(balloonImpl, AllIcons.Ide.Notification.Close, AllIcons.Ide.Notification.CloseHover, "Close. Alt-click to close all notifications", event -> {
            int modifiers = event.getModifiers();
            SwingUtilities.invokeLater(() -> {
                if ((modifiers & 8) != 0) {
                    this.myLayoutData.closeAll.run();
                } else {
                    this.myBalloon.hide();
                }
            });
        }){
            {
                BalloonImpl balloonImpl = x0;
                balloonImpl.getClass();
                super(icon, hoverIcon, hint, (Consumer<MouseEvent>)listener2);
            }

            @Override
            protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon) {
                if (g == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/NotificationBalloonActionProvider$2", "paintIcon"));
                }
                if (icon == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/NotificationBalloonActionProvider$2", "paintIcon"));
                }
                icon.paintIcon((Component)((Object)this), g, CloseHoverBounds.x, CloseHoverBounds.y);
            }
        };
        this.myActions.add(this.myCloseButton);
        List<BalloonImpl.ActionButton> list2 = this.myActions;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/NotificationBalloonActionProvider", "createActions"));
        }
        return list2;
    }

    @Override
    public void layout(@NotNull Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/ui/NotificationBalloonActionProvider", "layout"));
        }
        Dimension closeSize = this.myCloseButton.getPreferredSize();
        Insets borderInsets = this.myBalloon.getShadowBorderInsets();
        int x = bounds.x + bounds.width - borderInsets.right - closeSize.width - this.myLayoutData.configuration.rightActionsOffset.width;
        int y = bounds.y + borderInsets.top + this.myLayoutData.configuration.rightActionsOffset.height;
        this.myCloseButton.setBounds(x - NotificationBalloonActionProvider.CloseHoverBounds.x, y - NotificationBalloonActionProvider.CloseHoverBounds.y, closeSize.width + NotificationBalloonActionProvider.CloseHoverBounds.width, closeSize.height + NotificationBalloonActionProvider.CloseHoverBounds.height);
        if (this.mySettingButton != null) {
            Dimension size = this.mySettingButton.getPreferredSize();
            this.mySettingButton.setBounds(x - size.width - this.myLayoutData.configuration.gearCloseSpace, y, size.width, size.height);
        }
    }
}

