/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpeedSearchBase<Comp extends JComponent>
extends SpeedSearchSupply {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.SpeedSearchBase");
    private SearchPopup mySearchPopup;
    private JLayeredPane myPopupLayeredPane;
    protected final Comp myComponent;
    private final ToolWindowManagerListener myWindowManagerListener = new MyToolWindowManagerListener();
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport((Object)this);
    private String myRecentEnteredPrefix;
    private SpeedSearchComparator myComparator = new SpeedSearchComparator(false);
    private boolean myClearSearchOnNavigateNoMatch = false;
    private Disposable myListenerDisposable;

    public SpeedSearchBase(Comp component) {
        this.myComponent = component;
        ((Component)this.myComponent).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event) {
                SpeedSearchBase.this.manageSearchPopup(null);
            }

            @Override
            public void componentMoved(ComponentEvent event) {
                SpeedSearchBase.this.moveSearchPopup();
            }

            @Override
            public void componentResized(ComponentEvent event) {
                SpeedSearchBase.this.moveSearchPopup();
            }
        });
        ((Component)this.myComponent).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SpeedSearchBase.this.manageSearchPopup(null);
            }
        });
        ((Component)this.myComponent).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SpeedSearchBase.this.processKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                SpeedSearchBase.this.processKeyEvent(e);
            }
        });
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                String prefix = SpeedSearchBase.this.getEnteredPrefix();
                assert (prefix != null);
                String[] strings = NameUtil.splitNameIntoWords((String)prefix);
                String last = strings[strings.length - 1];
                int i = prefix.lastIndexOf(last);
                SpeedSearchBase.this.mySearchPopup.mySearchField.setText(prefix.substring(0, i).trim());
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(SpeedSearchBase.this.isPopupActive() && !StringUtil.isEmpty((String)SpeedSearchBase.this.getEnteredPrefix()));
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{SystemInfo.isMac ? "meta BACK_SPACE" : "control BACK_SPACE"}), this.myComponent);
        this.installSupplyTo((JComponent)component);
    }

    @Nullable
    public JTextField getSearchField() {
        if (this.mySearchPopup != null) {
            return this.mySearchPopup.mySearchField;
        }
        return null;
    }

    public static boolean hasActiveSpeedSearch(JComponent component) {
        return SpeedSearchBase.getSupply((JComponent)component) != null;
    }

    public void setClearSearchOnNavigateNoMatch(boolean clearSearchOnNavigateNoMatch) {
        this.myClearSearchOnNavigateNoMatch = clearSearchOnNavigateNoMatch;
    }

    public boolean isPopupActive() {
        return this.mySearchPopup != null && this.mySearchPopup.isVisible();
    }

    public Iterable<TextRange> matchingFragments(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/SpeedSearchBase", "matchingFragments"));
        }
        if (!this.isPopupActive()) {
            return null;
        }
        SpeedSearchComparator comparator2 = this.getComparator();
        String recentSearchText = comparator2.getRecentSearchText();
        return StringUtil.isNotEmpty((String)recentSearchText) ? comparator2.matchingFragments(recentSearchText, text2) : null;
    }

    protected abstract int getSelectedIndex();

    protected abstract Object[] getAllElements();

    @Nullable
    protected abstract String getElementText(Object var1);

    protected int getElementCount() {
        return this.getAllElements().length;
    }

    protected int convertIndexToModel(int viewIndex) {
        return viewIndex;
    }

    protected abstract void selectElement(Object var1, String var2);

    protected ListIterator<Object> getElementIterator(int startingIndex) {
        return new ViewIterator(this, startingIndex < 0 ? this.getElementCount() : startingIndex);
    }

    public void addChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/SpeedSearchBase", "addChangeListener"));
        }
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removeChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/SpeedSearchBase", "removeChangeListener"));
        }
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    private void fireStateChanged() {
        String enteredPrefix = this.getEnteredPrefix();
        this.myChangeSupport.firePropertyChange("enteredPrefix", this.myRecentEnteredPrefix, enteredPrefix);
        this.myRecentEnteredPrefix = enteredPrefix;
    }

    protected boolean isMatchingElement(Object element, String pattern) {
        String str = this.getElementText(element);
        return str != null && this.compare(str, pattern);
    }

    protected boolean compare(@NotNull String text2, @Nullable String pattern) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/SpeedSearchBase", "compare"));
        }
        return pattern != null && this.myComparator.matchingFragments(pattern, text2) != null;
    }

    public SpeedSearchComparator getComparator() {
        return this.myComparator;
    }

    public void setComparator(SpeedSearchComparator comparator2) {
        this.myComparator = comparator2;
    }

    @Nullable
    private Object findNextElement(String s) {
        Object current;
        String _s = s.trim();
        int selectedIndex = this.getSelectedIndex();
        ListIterator<Object> it = this.getElementIterator(selectedIndex + 1);
        if (it.hasPrevious()) {
            current = it.previous();
            it.next();
        } else {
            current = null;
        }
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (UISettings.getInstance().getCycleScrolling()) {
            ListIterator<Object> i = this.getElementIterator(0);
            while (i.hasNext()) {
                Object element = i.next();
                if (!this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        return current != null && this.isMatchingElement(current, _s) ? current : null;
    }

    @Nullable
    private Object findPreviousElement(String s) {
        Object current;
        String _s = s.trim();
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        if (it.hasNext()) {
            current = it.next();
            it.previous();
        } else {
            current = null;
        }
        while (it.hasPrevious()) {
            Object element = it.previous();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (UISettings.getInstance().getCycleScrolling()) {
            ListIterator<Object> i = this.getElementIterator(this.getElementCount());
            while (i.hasPrevious()) {
                Object element = i.previous();
                if (!this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        return selectedIndex != -1 && this.isMatchingElement(current, _s) ? current : null;
    }

    @Nullable
    protected Object findElement(String s) {
        Object element;
        String _s = s.trim();
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        while (it.hasNext()) {
            element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (selectedIndex > 0) {
            while (it.hasPrevious()) {
                it.previous();
            }
            while (it.hasNext() && it.nextIndex() != selectedIndex) {
                element = it.next();
                if (!this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        return null;
    }

    @Nullable
    private Object findFirstElement(String s) {
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(0);
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private Object findLastElement(String s) {
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(-1);
        while (it.hasPrevious()) {
            Object element = it.previous();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        return null;
    }

    public void showPopup(String searchText) {
        this.manageSearchPopup(new SearchPopup(searchText));
    }

    public void showPopup() {
        this.showPopup("");
    }

    public void hidePopup() {
        this.manageSearchPopup(null);
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.isAltDown()) {
            return;
        }
        if (e.isShiftDown() && SpeedSearchBase.isNavigationKey(e.getKeyCode())) {
            return;
        }
        if (this.mySearchPopup != null) {
            this.mySearchPopup.processKeyEvent(e);
            return;
        }
        if (!this.isSpeedSearchEnabled()) {
            return;
        }
        if (e.getID() == 400) {
            if (!UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                return;
            }
            char c = e.getKeyChar();
            if (Character.isLetterOrDigit(c) || c == '_' || c == '*' || c == '/' || c == ':' || c == '.' || c == '#' || c == '$') {
                this.manageSearchPopup(new SearchPopup(String.valueOf(c)));
                e.consume();
            }
        }
    }

    public Comp getComponent() {
        return this.myComponent;
    }

    protected boolean isSpeedSearchEnabled() {
        return true;
    }

    @Nullable
    public String getEnteredPrefix() {
        return this.mySearchPopup != null ? this.mySearchPopup.mySearchField.getText() : null;
    }

    public void refreshSelection() {
        if (this.mySearchPopup != null) {
            this.mySearchPopup.refreshSelection();
        }
    }

    public void findAndSelectElement(@NotNull String searchQuery) {
        if (searchQuery == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchQuery", "com/intellij/ui/SpeedSearchBase", "findAndSelectElement"));
        }
        this.selectElement(this.findElement(searchQuery), searchQuery);
    }

    protected void onSearchFieldUpdated(String pattern) {
    }

    private static boolean isUpDownHomeEnd(int keyCode) {
        return keyCode == 36 || keyCode == 35 || keyCode == 38 || keyCode == 40;
    }

    private static boolean isPgUpPgDown(int keyCode) {
        return keyCode == 33 || keyCode == 34;
    }

    private static boolean isNavigationKey(int keyCode) {
        return SpeedSearchBase.isPgUpPgDown(keyCode) || SpeedSearchBase.isUpDownHomeEnd(keyCode);
    }

    private void manageSearchPopup(@Nullable SearchPopup searchPopup) {
        JRootPane rootPane;
        Project project2 = null;
        if (ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isDisposed()) {
            project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(this.myComponent));
        }
        if (project2 != null && project2.isDefault()) {
            project2 = null;
        }
        if (this.mySearchPopup != null) {
            if (this.myPopupLayeredPane != null) {
                this.myPopupLayeredPane.remove(this.mySearchPopup);
                this.myPopupLayeredPane.validate();
                this.myPopupLayeredPane.repaint();
                this.myPopupLayeredPane = null;
            }
            if (this.myListenerDisposable != null) {
                Disposer.dispose((Disposable)this.myListenerDisposable);
                this.myListenerDisposable = null;
            }
        } else if (searchPopup != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("ui.tree.speedsearch");
        }
        this.mySearchPopup = !((Component)this.myComponent).isShowing() ? null : searchPopup;
        this.fireStateChanged();
        if (this.mySearchPopup == null || !((Component)this.myComponent).isDisplayable()) {
            return;
        }
        if (project2 != null) {
            this.myListenerDisposable = Disposer.newDisposable();
            ToolWindowManagerEx toolWindowManager = (ToolWindowManagerEx)ToolWindowManager.getInstance((Project)project2);
            toolWindowManager.addToolWindowManagerListener(this.myWindowManagerListener, this.myListenerDisposable);
        }
        this.myPopupLayeredPane = (rootPane = ((JComponent)this.myComponent).getRootPane()) != null ? rootPane.getLayeredPane() : null;
        if (this.myPopupLayeredPane == null) {
            LOG.error(((Object)((Object)this)).toString() + " in " + this.myComponent);
            return;
        }
        this.myPopupLayeredPane.add((Component)this.mySearchPopup, JLayeredPane.POPUP_LAYER);
        this.moveSearchPopup();
    }

    private void moveSearchPopup() {
        if (this.myComponent == null || this.mySearchPopup == null || this.myPopupLayeredPane == null) {
            return;
        }
        Point lPaneP = this.myPopupLayeredPane.getLocationOnScreen();
        Point componentP = this.getComponentLocationOnScreen();
        Rectangle r = this.getComponentVisibleRect();
        Dimension prefSize = this.mySearchPopup.getPreferredSize();
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.myComponent);
        Point windowP = window instanceof JDialog ? ((JDialog)window).getContentPane().getLocationOnScreen() : (window instanceof JFrame ? ((JFrame)window).getContentPane().getLocationOnScreen() : window.getLocationOnScreen());
        int y = r.y + componentP.y - lPaneP.y - prefSize.height;
        y = Math.max(y, windowP.y - lPaneP.y);
        this.mySearchPopup.setLocation(componentP.x - lPaneP.x + r.x, y);
        this.mySearchPopup.setSize(prefSize);
        this.mySearchPopup.setVisible(true);
        this.mySearchPopup.validate();
    }

    protected Rectangle getComponentVisibleRect() {
        return ((JComponent)this.myComponent).getVisibleRect();
    }

    protected Point getComponentLocationOnScreen() {
        return ((Component)this.myComponent).getLocationOnScreen();
    }

    protected class ViewIterator
    implements ListIterator<Object> {
        private final SpeedSearchBase mySpeedSearch;
        private int myCurrentIndex;
        private final Object[] myElements;

        public ViewIterator(SpeedSearchBase speedSearch, int startIndex) {
            if (speedSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "speedSearch", "com/intellij/ui/SpeedSearchBase$ViewIterator", "<init>"));
            }
            this.mySpeedSearch = speedSearch;
            this.myCurrentIndex = startIndex;
            this.myElements = speedSearch.getAllElements();
            if (startIndex < 0 || startIndex > this.myElements.length) {
                throw new IndexOutOfBoundsException("Index: " + startIndex + " in: " + ((Object)((Object)SpeedSearchBase.this)).getClass());
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.myCurrentIndex != 0;
        }

        @Override
        public Object previous() {
            int i = this.myCurrentIndex - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            Object previous = this.myElements[this.mySpeedSearch.convertIndexToModel(i)];
            this.myCurrentIndex = i;
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.myCurrentIndex;
        }

        @Override
        public int previousIndex() {
            return this.myCurrentIndex - 1;
        }

        @Override
        public boolean hasNext() {
            return this.myCurrentIndex != this.myElements.length;
        }

        @Override
        public Object next() {
            if (this.myCurrentIndex + 1 > this.myElements.length) {
                throw new NoSuchElementException();
            }
            return this.myElements[this.mySpeedSearch.convertIndexToModel(this.myCurrentIndex++)];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented in: " + this.getClass().getCanonicalName());
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException("Not implemented in: " + this.getClass().getCanonicalName());
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException("Not implemented in: " + this.getClass().getCanonicalName());
        }
    }

    private class MyToolWindowManagerListener
    extends ToolWindowManagerAdapter {
        private MyToolWindowManagerListener() {
        }

        @Override
        public void stateChanged() {
            SpeedSearchBase.this.manageSearchPopup(null);
        }
    }

    private class SearchField
    extends JTextField {
        SearchField() {
            this.setFocusable(false);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 10;
            return dim;
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            int i = e.getKeyCode();
            if (i == 8 && this.getDocument().getLength() == 0) {
                e.consume();
                return;
            }
            if (i == 10 || i == 27 || i == 33 || i == 34 || i == 37 || i == 39) {
                SpeedSearchBase.this.manageSearchPopup(null);
                if (i == 27) {
                    e.consume();
                }
                return;
            }
            if (SpeedSearchBase.isUpDownHomeEnd(i)) {
                e.consume();
                return;
            }
            super.processKeyEvent(e);
            if (i == 8) {
                e.consume();
            }
        }
    }

    private class SearchPopup
    extends JPanel {
        private final SearchField mySearchField;

        public SearchPopup(String initialString) {
            final Color foregroundColor = UIUtil.getToolTipForeground();
            JBColor color1 = new JBColor(UIUtil.getToolTipBackground().brighter(), (Color)Gray._111);
            this.mySearchField = new SearchField();
            JLabel searchLabel = new JLabel(" " + UIBundle.message((String)"search.popup.search.for.label", (Object[])new Object[0]) + " ");
            searchLabel.setFont(searchLabel.getFont().deriveFont(1));
            searchLabel.setForeground(foregroundColor);
            this.mySearchField.setBorder(null);
            this.mySearchField.setBackground((Color)color1);
            this.mySearchField.setForeground(foregroundColor);
            this.mySearchField.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    String oldText;
                    try {
                        oldText = this.getText(0, this.getLength());
                    }
                    catch (BadLocationException e1) {
                        oldText = "";
                    }
                    String newText = oldText.substring(0, offs) + str + oldText.substring(offs);
                    super.insertString(offs, str, a);
                    if (SpeedSearchBase.this.findElement(newText) == null) {
                        SearchPopup.this.mySearchField.setForeground((Color)JBColor.RED);
                    } else {
                        SearchPopup.this.mySearchField.setForeground(foregroundColor);
                    }
                }
            });
            this.mySearchField.setText(initialString);
            this.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.setBackground((Color)color1);
            this.setLayout(new BorderLayout());
            this.add((Component)searchLabel, "West");
            this.add((Component)this.mySearchField, "East");
            Object element = SpeedSearchBase.this.findElement(this.mySearchField.getText());
            SpeedSearchBase.this.onSearchFieldUpdated(initialString);
            this.updateSelection(element);
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            this.mySearchField.processKeyEvent(e);
            if (e.isConsumed()) {
                Object element;
                String s = this.mySearchField.getText();
                SpeedSearchBase.this.onSearchFieldUpdated(s);
                int keyCode = e.getKeyCode();
                if (SpeedSearchBase.isUpDownHomeEnd(keyCode)) {
                    element = this.findTargetElement(keyCode, s);
                    if (SpeedSearchBase.this.myClearSearchOnNavigateNoMatch && element == null) {
                        SpeedSearchBase.this.manageSearchPopup(null);
                        element = this.findTargetElement(keyCode, "");
                    }
                } else {
                    element = SpeedSearchBase.this.findElement(s);
                }
                this.updateSelection(element);
            }
        }

        @Nullable
        private Object findTargetElement(int keyCode, String searchPrefix) {
            if (keyCode == 38) {
                return SpeedSearchBase.this.findPreviousElement(searchPrefix);
            }
            if (keyCode == 40) {
                return SpeedSearchBase.this.findNextElement(searchPrefix);
            }
            if (keyCode == 36) {
                return SpeedSearchBase.this.findFirstElement(searchPrefix);
            }
            assert (keyCode == 35);
            return SpeedSearchBase.this.findLastElement(searchPrefix);
        }

        public void refreshSelection() {
            SpeedSearchBase.this.findAndSelectElement(this.mySearchField.getText());
        }

        private void updateSelection(Object element) {
            if (element != null) {
                SpeedSearchBase.this.selectElement(element, this.mySearchField.getText());
                this.mySearchField.setForeground(UIUtil.getLabelForeground());
            } else {
                this.mySearchField.setForeground((Color)JBColor.red);
            }
            if (SpeedSearchBase.this.mySearchPopup != null) {
                SpeedSearchBase.this.mySearchPopup.setSize(SpeedSearchBase.this.mySearchPopup.getPreferredSize());
                SpeedSearchBase.this.mySearchPopup.validate();
            }
            SpeedSearchBase.this.fireStateChanged();
        }
    }
}

