/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.containers.Convertor;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeTableSpeedSearch
extends SpeedSearchBase<TreeTable> {
    private static final Convertor<TreePath, String> TO_STRING = object -> {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object.getLastPathComponent();
        return node.toString();
    };
    private final Convertor<TreePath, String> myToStringConvertor;

    public TreeTableSpeedSearch(TreeTable tree, Convertor<TreePath, String> toStringConvertor) {
        super(tree);
        this.myToStringConvertor = toStringConvertor;
    }

    public TreeTableSpeedSearch(TreeTable tree) {
        this(tree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING);
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        return !((TreeTable)this.getComponent()).isEditing() && super.isSpeedSearchEnabled();
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        TreePath treePath = (TreePath)element;
        int row = ((TreeTable)this.myComponent).getTree().getRowForPath(treePath);
        TableUtil.selectRows((JTable)((JTable)this.myComponent), (int[])new int[]{((TreeTable)this.myComponent).convertRowIndexToView(row)});
        TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
    }

    @Override
    protected int getSelectedIndex() {
        int[] selectionRows = ((TreeTable)this.myComponent).getTree().getSelectionRows();
        return selectionRows == null || selectionRows.length == 0 ? -1 : selectionRows[0];
    }

    @Override
    protected Object[] getAllElements() {
        Object[] paths = new TreePath[((TreeTable)this.myComponent).getTree().getRowCount()];
        for (int i2 = 0; i2 < paths.length; ++i2) {
            paths[i2] = ((TreeTable)this.myComponent).getTree().getPathForRow(i2);
        }
        return paths;
    }

    @Override
    protected String getElementText(Object element) {
        TreePath path = (TreePath)element;
        String string = (String)this.myToStringConvertor.convert((Object)path);
        if (string == null) {
            return (String)TO_STRING.convert((Object)path);
        }
        return string;
    }
}

