/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.picker;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.picker.ColorListener;
import com.intellij.ui.picker.ColorPipette;
import com.intellij.ui.picker.MacColorPipette;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColorPipetteBase
implements ColorPipette {
    private final Alarm myColorListenersNotifier;
    protected final JComponent myParent;
    private final ColorListener myColorListener;
    protected final Robot myRobot;
    private JDialog myPickerFrame;
    private Color myCurrentColor;
    private Color myInitialColor;

    public ColorPipetteBase(@NotNull JComponent parent, @NotNull ColorListener colorListener) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/picker/ColorPipetteBase", "<init>"));
        }
        if (colorListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorListener", "com/intellij/ui/picker/ColorPipetteBase", "<init>"));
        }
        this.myColorListenersNotifier = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myParent = parent;
        this.myColorListener = colorListener;
        this.myRobot = ColorPipetteBase.createRobot();
    }

    public static boolean canUseMacPipette() {
        return SystemInfo.isMac && Registry.is((String)"ide.mac.new.color.picker");
    }

    @Override
    public void pickAndClose() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Color pixelColor = this.getPixelColor(pointerInfo.getLocation());
        this.cancelPipette();
        this.notifyListener(pixelColor, 0);
        this.setInitialColor(pixelColor);
    }

    protected Color getPixelColor(Point location) {
        BufferedImage image;
        if (SystemInfo.isMac && (image = MacColorPipette.captureScreen(this.myPickerFrame, new Rectangle(location.x, location.y, 1, 1))) != null) {
            return new Color(image.getRGB(0, 0));
        }
        return this.myRobot.getPixelColor(location.x, location.y);
    }

    @Nullable
    protected Color getInitialColor() {
        return this.myInitialColor;
    }

    @Override
    public void setInitialColor(@Nullable Color initialColor) {
        this.myInitialColor = initialColor;
        this.setColor(initialColor);
    }

    protected void setColor(@Nullable Color color) {
        this.myCurrentColor = color;
    }

    @Override
    @Nullable
    public Color getColor() {
        return this.myCurrentColor;
    }

    @Override
    public Dialog show() {
        Dialog picker = this.getOrCreatePickerDialog();
        this.updateLocation();
        picker.setVisible(true);
        return picker;
    }

    @Nullable
    protected Point updateLocation() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return null;
        }
        Point mouseLocation = pointerInfo.getLocation();
        Dialog pickerDialog = this.getPickerDialog();
        if (pickerDialog != null && mouseLocation != null) {
            pickerDialog.setLocation(mouseLocation.x - pickerDialog.getWidth() / 2, mouseLocation.y - pickerDialog.getHeight() / 2);
        }
        return mouseLocation;
    }

    @Nullable
    protected Dialog getPickerDialog() {
        return this.myPickerFrame;
    }

    @NotNull
    protected Dialog getOrCreatePickerDialog() {
        if (this.myPickerFrame == null) {
            Window owner2 = SwingUtilities.getWindowAncestor(this.myParent);
            this.myPickerFrame = owner2 instanceof Dialog ? new JDialog((Dialog)owner2) : (owner2 instanceof Frame ? new JDialog((Frame)owner2) : new JDialog(new JFrame()));
            this.myPickerFrame.setTitle("intellijPickerDialog");
        }
        this.myPickerFrame.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
                ColorPipetteBase.this.pickAndClose();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }
        });
        this.myPickerFrame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        ColorPipetteBase.this.cancelPipette();
                        break;
                    }
                    case 10: {
                        ColorPipetteBase.this.pickAndClose();
                    }
                }
            }
        });
        this.myPickerFrame.setUndecorated(true);
        this.myPickerFrame.setAlwaysOnTop(!SystemInfo.isJavaVersionAtLeast((String)"1.8.0") || ColorPipetteBase.canUseMacPipette());
        JRootPane rootPane = this.myPickerFrame.getRootPane();
        rootPane.putClientProperty("Window.shadow", Boolean.FALSE);
        JDialog jDialog = this.myPickerFrame;
        if (jDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/picker/ColorPipetteBase", "getOrCreatePickerDialog"));
        }
        return jDialog;
    }

    protected void notifyListener(@NotNull Color c, int delayMillis) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ui/picker/ColorPipetteBase", "notifyListener"));
        }
        if (!this.myColorListenersNotifier.isDisposed()) {
            this.myColorListenersNotifier.cancelAllRequests();
            this.myColorListenersNotifier.addRequest(() -> {
                if (c == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ui/picker/ColorPipetteBase", "lambda$notifyListener$0"));
                }
                this.myColorListener.colorChanged(c, this);
            }, delayMillis);
        }
    }

    @Override
    public boolean imageUpdate(Image image, int i2, int i1, int i22, int i3, int i4) {
        return false;
    }

    @Override
    public void cancelPipette() {
        Color initialColor;
        Dialog pickerDialog = this.getPickerDialog();
        if (pickerDialog != null) {
            pickerDialog.setVisible(false);
        }
        if ((initialColor = this.getInitialColor()) != null) {
            this.notifyListener(initialColor, 0);
        }
    }

    public void dispose() {
        UIUtil.dispose((Component)this.myPickerFrame);
        this.myPickerFrame = null;
        this.setInitialColor(null);
        this.setColor(null);
    }

    @Nullable
    private static Robot createRobot() {
        try {
            return new Robot();
        }
        catch (AWTException e) {
            return null;
        }
    }
}

