/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.util.ReflectionUtil;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayDeque;
import javax.swing.JWindow;

final class HeavyWeightPopupCache
implements ComponentListener {
    private final ArrayDeque<Window> myWindows = new ArrayDeque();

    HeavyWeightPopupCache() {
    }

    public static Window create(Window owner2) {
        Window popup;
        HeavyWeightPopupCache cache;
        if (owner2 != null && (cache = HeavyWeightPopupCache.getCache(owner2)) != null && (popup = cache.poll()) != null) {
            return popup;
        }
        JWindow popup2 = new JWindow(owner2);
        popup2.setType(Window.Type.POPUP);
        return popup2;
    }

    public static void dispose(Window popup) {
        if (popup != null) {
            HeavyWeightPopupCache.hide(popup);
            Window owner2 = popup.getOwner();
            if (owner2 == null || !owner2.isDisplayable()) {
                popup.dispose();
            } else {
                HeavyWeightPopupCache cache = HeavyWeightPopupCache.getCache(owner2);
                if (cache == null) {
                    cache = new HeavyWeightPopupCache();
                    owner2.addComponentListener(cache);
                }
                cache.push(popup);
            }
        }
    }

    private static HeavyWeightPopupCache getCache(Window owner2) {
        for (ComponentListener listener2 : owner2.getComponentListeners()) {
            if (!(listener2 instanceof HeavyWeightPopupCache)) continue;
            return (HeavyWeightPopupCache)listener2;
        }
        return null;
    }

    private static Window poll(ArrayDeque<Window> windows) {
        return windows.poll();
    }

    private static void push(ArrayDeque<Window> windows, Window popup) {
        windows.push(popup);
    }

    private static void hide(ArrayDeque<Window> windows) {
        for (Window window : windows) {
            HeavyWeightPopupCache.hide(window);
        }
    }

    private static void hide(Window window) {
        ReflectionUtil.setField(Window.class, (Object)window, Boolean.TYPE, (String)"showWithParent", (Object)false);
    }

    private Window poll() {
        return HeavyWeightPopupCache.poll(this.myWindows);
    }

    private void push(Window popup) {
        HeavyWeightPopupCache.push(this.myWindows, popup);
    }

    private void hide() {
        HeavyWeightPopupCache.hide(this.myWindows);
    }

    @Override
    public void componentResized(ComponentEvent event) {
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
        HeavyWeightPopupCache cache;
        Object source = event.getSource();
        if (source instanceof Window && (cache = HeavyWeightPopupCache.getCache((Window)source)) != null) {
            cache.hide();
        }
    }
}

