/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.Identifiable;
import com.intellij.ui.tree.MapBasedTree;
import com.intellij.ui.tree.Navigatable;
import com.intellij.ui.tree.Searchable;
import com.intellij.util.concurrency.Command;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class AsyncTreeModel
extends AbstractTreeModel
implements Disposable,
Identifiable,
Searchable,
Navigatable {
    private static final Logger LOG = Logger.getInstance(AsyncTreeModel.class);
    private final AtomicReference<AsyncPromise<MapBasedTree.Entry<Object>>> rootLoader;
    private final Command.Processor processor;
    private final MapBasedTree<Object, Object> tree;
    private final TreeModel model;
    private final boolean showLoadingNode;
    private final TreeModelListener listener;

    public AsyncTreeModel(@NotNull TreeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ui/tree/AsyncTreeModel", "<init>"));
        }
        this(model, false);
    }

    public AsyncTreeModel(@NotNull TreeModel model, boolean showLoadingNode) {
        Invoker.EDT foreground;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ui/tree/AsyncTreeModel", "<init>"));
        }
        this.rootLoader = new AtomicReference();
        this.tree = new MapBasedTree<Object, Object>(true, object -> object);
        this.listener = new TreeModelAdapter(){

            protected void process(TreeModelEvent event, TreeModelAdapter.EventType type2) {
                TreePath path = event.getTreePath();
                if (path == null) {
                    AsyncTreeModel.this.processor.process(new CmdGetRoot("Reload root", null));
                    return;
                }
                Object object = path.getLastPathComponent();
                if (path.getParentPath() == null && type2 == TreeModelAdapter.EventType.StructureChanged) {
                    AsyncTreeModel.this.processor.process(new CmdGetRoot("Update root", object));
                    return;
                }
                ((AsyncTreeModel)AsyncTreeModel.this).processor.foreground.invokeLaterIfNeeded(() -> {
                    MapBasedTree.Entry<Object> entry = AsyncTreeModel.this.tree.findEntry(object);
                    if (entry == null || entry.isLoadingRequired()) {
                        LOG.debug("ignore updating of nonexistent node: ", new Object[]{object});
                    } else if (type2 == TreeModelAdapter.EventType.NodesChanged) {
                        AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), event.getChildIndices(), event.getChildren());
                    } else if (type2 == TreeModelAdapter.EventType.NodesInserted) {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Insert children", entry, false));
                    } else if (type2 == TreeModelAdapter.EventType.NodesRemoved) {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Remove children", entry, false));
                    } else {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Update children", entry, true));
                    }
                });
            }
        };
        if (model instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)model));
        }
        Invoker background = foreground = new Invoker.EDT(this);
        if (model instanceof InvokerSupplier) {
            InvokerSupplier supplier = (InvokerSupplier)((Object)model);
            background = supplier.getInvoker();
        }
        this.processor = new Command.Processor(foreground, background);
        this.model = model;
        this.model.addTreeModelListener(this.listener);
        this.showLoadingNode = showLoadingNode;
    }

    public void dispose() {
        this.model.removeTreeModelListener(this.listener);
    }

    @Override
    public Object getUniqueID(@NotNull TreePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ui/tree/AsyncTreeModel", "getUniqueID"));
        }
        return this.model instanceof Identifiable ? ((Identifiable)((Object)this.model)).getUniqueID(path) : null;
    }

    @Override
    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        Promise<TreePath> promise2 = this.model instanceof Searchable ? this.resolve(((Searchable)((Object)this.model)).getTreePath(object)) : Promises.rejectedPromise();
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tree/AsyncTreeModel", "getTreePath"));
        }
        return promise2;
    }

    @Override
    @NotNull
    public Promise<TreePath> nextTreePath(@NotNull TreePath path, Object object) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ui/tree/AsyncTreeModel", "nextTreePath"));
        }
        Promise<TreePath> promise2 = this.model instanceof Navigatable ? this.resolve(((Navigatable)((Object)this.model)).nextTreePath(path, object)) : Promises.rejectedPromise();
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tree/AsyncTreeModel", "nextTreePath"));
        }
        return promise2;
    }

    @Override
    @NotNull
    public Promise<TreePath> prevTreePath(@NotNull TreePath path, Object object) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ui/tree/AsyncTreeModel", "prevTreePath"));
        }
        Promise<TreePath> promise2 = this.model instanceof Navigatable ? this.resolve(((Navigatable)((Object)this.model)).prevTreePath(path, object)) : Promises.rejectedPromise();
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tree/AsyncTreeModel", "prevTreePath"));
        }
        return promise2;
    }

    @NotNull
    public Promise<TreePath> resolve(TreePath path) {
        AsyncPromise async = new AsyncPromise();
        this.processor.foreground.invokeLaterIfNeeded(() -> this.resolve((AsyncPromise<TreePath>)async, path, entry -> async.setResult(entry)));
        AsyncPromise asyncPromise = async;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tree/AsyncTreeModel", "resolve"));
        }
        return asyncPromise;
    }

    private Promise<TreePath> resolve(Promise<TreePath> promise2) {
        AsyncPromise async = new AsyncPromise();
        promise2.rejected(error -> this.processor.foreground.invokeLaterIfNeeded(() -> async.setError(error)));
        promise2.done(result2 -> this.processor.foreground.invokeLaterIfNeeded(() -> this.resolve((AsyncPromise<TreePath>)async, (TreePath)result2, entry -> async.setResult(entry))));
        return async;
    }

    private void resolve(final AsyncPromise<TreePath> async, TreePath path, final Consumer<MapBasedTree.Entry<Object>> consumer) {
        if (path == null) {
            async.setError("path is null");
            return;
        }
        final Object object = path.getLastPathComponent();
        if (object == null) {
            async.setError("path is wrong");
            return;
        }
        if (!AsyncTreeModel.consume(consumer, this.tree.findEntry(object))) {
            TreePath parent = path.getParentPath();
            if (parent == null) {
                this.promiseRootEntry().done(entry -> {
                    if (entry == null) {
                        async.setError("root is null");
                    } else if (object != entry.getNode()) {
                        async.setError("root is wrong");
                    } else {
                        consumer.accept((MapBasedTree.Entry<Object>)entry);
                    }
                });
            } else {
                this.resolve(async, parent, entry -> this.processor.process(new Command<List<Pair<Object, Boolean>>>(){
                    private CmdGetChildren command;
                    {
                        this.command = new CmdGetChildren("Sync children", entry, false);
                    }

                    @Override
                    public List<Pair<Object, Boolean>> get() {
                        return this.command.get();
                    }

                    @Override
                    public void accept(List<Pair<Object, Boolean>> children2) {
                        this.command.accept(children2);
                        if (!AsyncTreeModel.consume(consumer, AsyncTreeModel.this.tree.findEntry(object))) {
                            async.setError("path not found");
                        }
                    }
                }));
            }
        }
    }

    private static boolean consume(Consumer<MapBasedTree.Entry<Object>> consumer, MapBasedTree.Entry<Object> entry) {
        if (entry == null) {
            return false;
        }
        consumer.accept(entry);
        return true;
    }

    public Object getRoot() {
        if (!this.isValidThread()) {
            return null;
        }
        this.promiseRootEntry();
        MapBasedTree.Entry<Object> entry = this.tree.getRootEntry();
        return entry == null ? null : entry.getNode();
    }

    public Object getChild(Object object, int index) {
        MapBasedTree.Entry<Object> entry = this.getEntry(object, true);
        return entry == null ? null : entry.getChild(index);
    }

    public int getChildCount(Object object) {
        MapBasedTree.Entry<Object> entry = this.getEntry(object, true);
        return entry == null ? 0 : entry.getChildCount();
    }

    public boolean isLeaf(Object object) {
        MapBasedTree.Entry<Object> entry = this.getEntry(object, false);
        return entry == null || entry.isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object value2) {
        this.processor.background.invokeLaterIfNeeded(() -> this.model.valueForPathChanged(path, value2));
    }

    public int getIndexOfChild(Object object, Object child) {
        MapBasedTree.Entry<Object> entry = this.getEntry(object, true);
        return entry == null ? -1 : entry.getIndexOf(child);
    }

    private boolean isValidThread() {
        if (this.processor.foreground.isValidThread()) {
            return true;
        }
        LOG.warn("AsyncTreeModel is used from unexpected thread");
        return false;
    }

    private static <T> AsyncPromise<T> create(AtomicReference<AsyncPromise<T>> reference) {
        AsyncPromise newPromise = new AsyncPromise();
        AsyncPromise oldPromise = reference.getAndSet(newPromise);
        if (oldPromise != null && Promise.State.PENDING == oldPromise.getState()) {
            newPromise.notify(oldPromise);
        }
        return newPromise;
    }

    private Promise<MapBasedTree.Entry<Object>> promiseRootEntry() {
        AsyncPromise<MapBasedTree.Entry<Object>> promise2 = this.rootLoader.get();
        if (promise2 != null) {
            return promise2;
        }
        CmdGetRoot command = new CmdGetRoot("Load root", null);
        this.processor.process(command);
        return command.promise;
    }

    private MapBasedTree.Entry<Object> getEntry(Object object, boolean loadChildren) {
        MapBasedTree.Entry<Object> entry;
        MapBasedTree.Entry<Object> entry2 = entry = object == null || !this.isValidThread() ? null : this.tree.findEntry(object);
        if (entry != null && loadChildren && entry.isLoadingRequired()) {
            this.loadChildren(entry, true);
        }
        return entry;
    }

    private void loadChildren(MapBasedTree.Entry<Object> entry, boolean insertLoadingNode) {
        String name2;
        String string = name2 = insertLoadingNode ? "Load children" : "Reload children";
        if (insertLoadingNode && this.showLoadingNode) {
            entry.setLoadingChildren(new LoadingNode());
        }
        this.processor.process(new CmdGetChildren(name2, entry, true));
    }

    private final class CmdGetChildren
    implements Command<List<Pair<Object, Boolean>>> {
        private final String name;
        private final MapBasedTree.Entry<Object> entry;
        private final boolean deep;

        public CmdGetChildren(String name2, MapBasedTree.Entry<Object> entry, boolean deep) {
            this.name = name2;
            this.entry = entry;
            this.deep = deep;
        }

        public String toString() {
            return this.name + ": " + this.entry.getNode();
        }

        @Override
        public List<Pair<Object, Boolean>> get() {
            Object object = this.entry.getNode();
            if (AsyncTreeModel.this.model.isLeaf(object)) {
                return null;
            }
            if (AsyncTreeModel.this.model instanceof ChildrenProvider) {
                ChildrenProvider provider = (ChildrenProvider)((Object)AsyncTreeModel.this.model);
                ArrayList children2 = new ArrayList();
                provider.getChildren(object).forEach(child -> this.add(children2, child));
                return Collections.unmodifiableList(children2);
            }
            int count = AsyncTreeModel.this.model.getChildCount(object);
            if (count <= 0) {
                return Collections.emptyList();
            }
            ArrayList<Pair<Object, Boolean>> children3 = new ArrayList<Pair<Object, Boolean>>(count);
            for (int i2 = 0; i2 < count; ++i2) {
                this.add(children3, AsyncTreeModel.this.model.getChild(object, i2));
            }
            return Collections.unmodifiableList(children3);
        }

        private void add(List<Pair<Object, Boolean>> children2, Object child) {
            if (child != null) {
                children2.add((Pair<Object, Boolean>)Pair.create((Object)child, (Object)AsyncTreeModel.this.model.isLeaf(child)));
            }
        }

        @Override
        public void accept(List<Pair<Object, Boolean>> children2) {
            boolean contained;
            Object object = this.entry.getNode();
            if (this.entry != AsyncTreeModel.this.tree.findEntry(object)) {
                LOG.debug("ignore updating of changed node: ", new Object[]{object});
                return;
            }
            MapBasedTree.UpdateResult<Object> update2 = AsyncTreeModel.this.tree.update(this.entry, children2);
            boolean removed = !update2.getRemoved().isEmpty();
            boolean inserted = !update2.getInserted().isEmpty();
            boolean bl = contained = !update2.getContained().isEmpty();
            if (!(removed || inserted || contained)) {
                return;
            }
            if (!this.deep || !contained) {
                if (!removed && inserted) {
                    if (AsyncTreeModel.this.listeners.isEmpty()) {
                        return;
                    }
                    AsyncTreeModel.this.listeners.treeNodesInserted(update2.getEvent(AsyncTreeModel.this, this.entry, update2.getInserted()));
                    return;
                }
                if (!inserted && removed) {
                    if (AsyncTreeModel.this.listeners.isEmpty()) {
                        return;
                    }
                    AsyncTreeModel.this.listeners.treeNodesRemoved(update2.getEvent(AsyncTreeModel.this, this.entry, update2.getRemoved()));
                    return;
                }
            }
            if (!AsyncTreeModel.this.listeners.isEmpty()) {
                if (removed) {
                    AsyncTreeModel.this.listeners.treeNodesRemoved(update2.getEvent(AsyncTreeModel.this, this.entry, update2.getRemoved()));
                }
                if (inserted) {
                    AsyncTreeModel.this.listeners.treeNodesInserted(update2.getEvent(AsyncTreeModel.this, this.entry, update2.getInserted()));
                }
                if (contained) {
                    AsyncTreeModel.this.listeners.treeNodesChanged(update2.getEvent(AsyncTreeModel.this, this.entry, update2.getContained()));
                }
            }
            for (MapBasedTree.Entry<Object> entry : update2.getContained()) {
                if (entry.isLoadingRequired()) continue;
                AsyncTreeModel.this.loadChildren(entry, false);
            }
        }
    }

    private final class CmdGetRoot
    implements Obsolescent,
    Command<Pair<Object, Boolean>> {
        private final AsyncPromise<MapBasedTree.Entry<Object>> promise;
        private final String name;
        private final Object root;

        public CmdGetRoot(String name2, Object root) {
            this.promise = AsyncTreeModel.create(AsyncTreeModel.this.rootLoader);
            this.name = name2;
            this.root = root;
        }

        public String toString() {
            return this.root == null ? this.name : this.name + ": " + this.root;
        }

        public boolean isObsolete() {
            return this.promise != AsyncTreeModel.this.rootLoader.get();
        }

        @Override
        public Pair<Object, Boolean> get() {
            Object object;
            if (this.isObsolete()) {
                return null;
            }
            Object object2 = object = this.root != null ? this.root : AsyncTreeModel.this.model.getRoot();
            if (this.isObsolete()) {
                return null;
            }
            return Pair.create((Object)object, (Object)AsyncTreeModel.this.model.isLeaf(object));
        }

        @Override
        public void accept(Pair<Object, Boolean> root) {
            if (this.isObsolete()) {
                return;
            }
            boolean updated = AsyncTreeModel.this.tree.updateRoot(root);
            MapBasedTree.Entry entry = AsyncTreeModel.this.tree.getRootEntry();
            if (updated) {
                AsyncTreeModel.this.treeStructureChanged(entry, null, null);
            }
            if (entry != null) {
                AsyncTreeModel.this.loadChildren(entry, entry.isLoadingRequired());
            }
            this.promise.setResult(entry);
        }
    }
}

