/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BufferedListConsumer<T>
implements Consumer<List<T>> {
    private final int myInterval;
    private long myTs;
    private final int mySize;
    private List<T> myBuffer;
    private final Object myFlushLock;
    private final Consumer<List<T>> myConsumer;
    private int myCnt;
    private Runnable myFlushListener;
    private volatile boolean myPendingFlush;

    public BufferedListConsumer(int size, Consumer<List<T>> consumer, int interval) {
        this.mySize = size;
        this.myFlushLock = new Object();
        this.myBuffer = new ArrayList<T>(size);
        this.myConsumer = consumer;
        this.myInterval = interval;
        this.myTs = System.currentTimeMillis();
        this.myCnt = 0;
        this.myPendingFlush = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeOne(T t) {
        Object object = this.myFlushLock;
        synchronized (object) {
            ++this.myCnt;
            this.myBuffer.add(t);
            this.flushCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(List<T> list2) {
        Object object = this.myFlushLock;
        synchronized (object) {
            this.myCnt += list2.size();
            this.myBuffer.addAll(list2);
            this.flushCheck();
        }
    }

    private void flushCheck() {
        long ts = System.currentTimeMillis();
        if (this.myBuffer.size() >= this.mySize || this.myInterval > 0 && ts - (long)this.myInterval > this.myTs) {
            this.flushImpl(ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushImpl(long ts) {
        Object object = this.myFlushLock;
        synchronized (object) {
            if (this.myPendingFlush || this.myBuffer.isEmpty()) {
                return;
            }
            this.myPendingFlush = true;
            this.invokeConsumer(this.createConsumerRunnable(ts));
        }
    }

    protected void invokeConsumer(@NotNull Runnable consumerRunnable) {
        if (consumerRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerRunnable", "com/intellij/util/BufferedListConsumer", "invokeConsumer"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(consumerRunnable);
    }

    @NotNull
    private Runnable createConsumerRunnable(long ts) {
        Runnable runnable2 = () -> {
            List<T> list2;
            this.myTs = ts;
            Object object = this.myFlushLock;
            synchronized (object) {
                this.myPendingFlush = false;
                if (this.myBuffer.isEmpty()) {
                    return;
                }
                list2 = this.myBuffer;
                this.myBuffer = new ArrayList<T>(this.mySize);
            }
            this.myConsumer.consume(list2);
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/BufferedListConsumer", "createConsumerRunnable"));
        }
        return runnable2;
    }

    public void flush() {
        this.flushImpl(System.currentTimeMillis());
        if (this.myFlushListener != null) {
            this.myFlushListener.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCnt() {
        Object object = this.myFlushLock;
        synchronized (object) {
            return this.myCnt;
        }
    }

    public Consumer<T> asConsumer() {
        return t -> this.consumeOne(t);
    }
}

