/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalFileUrl;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.io.URLUtil;
import gnu.trove.TObjectHashingStrategy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Urls {
    private static final Logger LOG = Logger.getInstance(Urls.class);
    private static final Pattern URI_PATTERN = Pattern.compile("^([^:/?#]+):(//)?([^/?#]*)([^?#;]*)(.*)");

    @NotNull
    public static Url newUri(@NotNull String scheme2, @NotNull String path) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/util/Urls", "newUri"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/Urls", "newUri"));
        }
        UrlImpl urlImpl = new UrlImpl(scheme2, null, path);
        if (urlImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "newUri"));
        }
        return urlImpl;
    }

    @NotNull
    public static Url newLocalFileUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/Urls", "newLocalFileUrl"));
        }
        LocalFileUrl localFileUrl = new LocalFileUrl(FileUtilRt.toSystemIndependentName((String)path));
        if (localFileUrl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "newLocalFileUrl"));
        }
        return localFileUrl;
    }

    @NotNull
    public static Url newLocalFileUrl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/Urls", "newLocalFileUrl"));
        }
        LocalFileUrl localFileUrl = new LocalFileUrl(file2.getPath());
        if (localFileUrl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "newLocalFileUrl"));
        }
        return localFileUrl;
    }

    @NotNull
    public static Url newFromEncoded(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "newFromEncoded"));
        }
        Url result2 = Urls.parseEncoded(url);
        LOG.assertTrue(result2 != null, (Object)url);
        Url url2 = result2;
        if (url2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "newFromEncoded"));
        }
        return url2;
    }

    @Nullable
    public static Url parseEncoded(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "parseEncoded"));
        }
        return Urls.parse(url, false);
    }

    @NotNull
    public static Url newHttpUrl(@NotNull String authority, @Nullable String path) {
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authority", "com/intellij/util/Urls", "newHttpUrl"));
        }
        Url url = Urls.newUrl("http", authority, path);
        if (url == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "newHttpUrl"));
        }
        return url;
    }

    @NotNull
    public static Url newHttpUrl(@NotNull String authority, @Nullable String path, @Nullable String parameters2) {
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authority", "com/intellij/util/Urls", "newHttpUrl"));
        }
        UrlImpl urlImpl = new UrlImpl("http", authority, path, parameters2);
        if (urlImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "newHttpUrl"));
        }
        return urlImpl;
    }

    @NotNull
    public static Url newUrl(@NotNull String scheme2, @NotNull String authority, @Nullable String path) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/util/Urls", "newUrl"));
        }
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authority", "com/intellij/util/Urls", "newUrl"));
        }
        UrlImpl urlImpl = new UrlImpl(scheme2, authority, path);
        if (urlImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "newUrl"));
        }
        return urlImpl;
    }

    @NotNull
    public static Url newFromIdea(@NotNull CharSequence url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "newFromIdea"));
        }
        Url result2 = Urls.parseFromIdea(url);
        LOG.assertTrue(result2 != null, (Object)url);
        Url url2 = result2;
        if (url2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "newFromIdea"));
        }
        return url2;
    }

    @Nullable
    public static Url parseFromIdea(@NotNull CharSequence url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "parseFromIdea"));
        }
        int n = url.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = url.charAt(i2);
            if (c == ':') {
                return Urls.parseUrl(url);
            }
            if (c != '/' && c != '\\') continue;
            return Urls.newLocalFileUrl(url.toString());
        }
        return Urls.newLocalFileUrl(url.toString());
    }

    @Nullable
    public static Url parse(@NotNull String url, boolean asLocalIfNoScheme) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "parse"));
        }
        if (url.isEmpty()) {
            return null;
        }
        if (asLocalIfNoScheme && !URLUtil.containsScheme((String)url)) {
            return Urls.newLocalFileUrl(url);
        }
        return Urls.parseUrl(VfsUtilCore.toIdeaUrl((String)url));
    }

    @Nullable
    public static URI parseAsJavaUriWithoutParameters(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "parseAsJavaUriWithoutParameters"));
        }
        Url asUrl = Urls.parseUrl(url);
        if (asUrl == null) {
            return null;
        }
        try {
            return Urls.toUriWithoutParameters(asUrl);
        }
        catch (Exception e) {
            LOG.info("Cannot parse url " + url, (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Url parseUrl(@NotNull CharSequence url) {
        boolean hasUrlSeparator;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "parseUrl"));
        }
        CharSequence urlToParse = StringUtil.startsWith((CharSequence)url, (CharSequence)"jar:file://") ? url.subSequence("jar:".length(), url.length()) : url;
        Matcher matcher = URI_PATTERN.matcher(urlToParse);
        if (!matcher.matches()) {
            return null;
        }
        String scheme2 = matcher.group(1);
        if (urlToParse != url) {
            scheme2 = "jar:" + scheme2;
        }
        String authority = StringUtil.nullize((String)matcher.group(3));
        String path = StringUtil.nullize((String)matcher.group(4));
        boolean bl = hasUrlSeparator = !StringUtil.isEmpty((String)matcher.group(2));
        if (authority == null) {
            if (hasUrlSeparator) {
                authority = "";
            }
        } else if ("file".equals(scheme2) || !hasUrlSeparator) {
            path = path == null ? authority : authority + path;
            String string = authority = hasUrlSeparator ? "" : null;
        }
        if (path != null && (!StringUtil.isEmpty((String)authority) || "file".equals(scheme2))) {
            path = FileUtil.toCanonicalUriPath((String)path);
        }
        return new UrlImpl(scheme2, authority, path, matcher.group(5));
    }

    @NotNull
    public static Url newFromVirtualFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/Urls", "newFromVirtualFile"));
        }
        if (file2.isInLocalFileSystem()) {
            Url url = Urls.newUri(file2.getFileSystem().getProtocol(), file2.getPath());
            if (url == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "newFromVirtualFile"));
            }
            return url;
        }
        Url url = Urls.parseUrl(file2.getUrl());
        Url url2 = url == null ? new UrlImpl(file2.getPath()) : url;
        if (url2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "newFromVirtualFile"));
        }
        return url2;
    }

    public static boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<Url> urls) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "equalsIgnoreParameters"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/util/Urls", "equalsIgnoreParameters"));
        }
        return Urls.equalsIgnoreParameters(url, urls, true);
    }

    public static boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<Url> urls, boolean caseSensitive) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "equalsIgnoreParameters"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/util/Urls", "equalsIgnoreParameters"));
        }
        for (Url otherUrl : urls) {
            if (!Urls.equals(url, otherUrl, caseSensitive, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreParameters(@NotNull Url url, @NotNull VirtualFile file2) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "equalsIgnoreParameters"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/Urls", "equalsIgnoreParameters"));
        }
        if (file2.isInLocalFileSystem()) {
            return url.isInLocalFileSystem() && (SystemInfoRt.isFileSystemCaseSensitive ? url.getPath().equals(file2.getPath()) : url.getPath().equalsIgnoreCase(file2.getPath()));
        }
        if (url.isInLocalFileSystem()) {
            return false;
        }
        Url fileUrl = Urls.parseUrl(file2.getUrl());
        return fileUrl != null && fileUrl.equalsIgnoreParameters(url);
    }

    public static boolean equals(@Nullable Url url1, @Nullable Url url2, boolean caseSensitive, boolean ignoreParameters) {
        if (url1 == null || url2 == null) {
            return url1 == url2;
        }
        Url o1 = ignoreParameters ? url1.trimParameters() : url1;
        Url o2 = ignoreParameters ? url2.trimParameters() : url2;
        return caseSensitive ? o1.equals(o2) : o1.equalsIgnoreCase(o2);
    }

    @NotNull
    public static URI toUriWithoutParameters(@NotNull Url url) {
        URI uRI;
        block4: {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/Urls", "toUriWithoutParameters"));
            }
            try {
                String externalPath = url.getPath();
                boolean inLocalFileSystem = url.isInLocalFileSystem();
                if (inLocalFileSystem && SystemInfoRt.isWindows && externalPath.charAt(0) != '/') {
                    externalPath = '/' + externalPath;
                }
                if ((uRI = new URI(inLocalFileSystem ? "file" : url.getScheme(), inLocalFileSystem ? "" : url.getAuthority(), externalPath, null, null)) != null) break block4;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Urls", "toUriWithoutParameters"));
        }
        return uRI;
    }

    public static TObjectHashingStrategy<Url> getCaseInsensitiveUrlHashingStrategy() {
        return CaseInsensitiveUrlHashingStrategy.INSTANCE;
    }

    private static final class CaseInsensitiveUrlHashingStrategy
    implements TObjectHashingStrategy<Url> {
        private static final TObjectHashingStrategy<Url> INSTANCE = new CaseInsensitiveUrlHashingStrategy();

        private CaseInsensitiveUrlHashingStrategy() {
        }

        public int computeHashCode(Url url) {
            return url == null ? 0 : url.hashCodeCaseInsensitive();
        }

        public boolean equals(Url url1, Url url2) {
            return Urls.equals(url1, url2, false, false);
        }
    }
}

