/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AtomicDouble;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.IOExceptionDialog;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDownloaderImpl
implements FileDownloader {
    private static final Logger LOG = Logger.getInstance(FileDownloaderImpl.class);
    private static final String LIB_SCHEMA = "lib://";
    private final List<? extends DownloadableFileDescription> myFileDescriptions;
    private final JComponent myParentComponent;
    @Nullable
    private final Project myProject;
    private String myDirectoryForDownloadedFilesPath;
    private final String myDialogTitle;

    public FileDownloaderImpl(@NotNull List<? extends DownloadableFileDescription> fileDescriptions, @Nullable Project project2, @Nullable JComponent parentComponent, @NotNull String presentableDownloadName) {
        if (fileDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDescriptions", "com/intellij/util/download/impl/FileDownloaderImpl", "<init>"));
        }
        if (presentableDownloadName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableDownloadName", "com/intellij/util/download/impl/FileDownloaderImpl", "<init>"));
        }
        this.myProject = project2;
        this.myFileDescriptions = fileDescriptions;
        this.myParentComponent = parentComponent;
        this.myDialogTitle = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)presentableDownloadName)});
    }

    @Nullable
    public List<VirtualFile> downloadFilesWithProgress(@Nullable String targetDirectoryPath, @Nullable Project project2, @Nullable JComponent parentComponent) {
        List<Pair<VirtualFile, DownloadableFileDescription>> pairs = this.downloadWithProgress(targetDirectoryPath, project2, parentComponent);
        if (pairs == null) {
            return null;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (Pair<VirtualFile, DownloadableFileDescription> pair2 : pairs) {
            files.add((VirtualFile)pair2.getFirst());
        }
        return files;
    }

    @Nullable
    public List<Pair<VirtualFile, DownloadableFileDescription>> downloadWithProgress(@Nullable String targetDirectoryPath, @Nullable Project project2, @Nullable JComponent parentComponent) {
        File dir;
        if (targetDirectoryPath != null) {
            dir = new File(targetDirectoryPath);
        } else {
            VirtualFile virtualDir = FileDownloaderImpl.chooseDirectoryForFiles(project2, parentComponent);
            if (virtualDir != null) {
                dir = VfsUtilCore.virtualToIoFile((VirtualFile)virtualDir);
            } else {
                return null;
            }
        }
        return this.downloadWithProcess(dir, project2, parentComponent);
    }

    @Nullable
    private List<Pair<VirtualFile, DownloadableFileDescription>> downloadWithProcess(File targetDir, Project project2, JComponent parentComponent) {
        Ref localFiles = Ref.create(null);
        Ref exceptionRef = Ref.create(null);
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                localFiles.set(this.download(targetDir));
            }
            catch (IOException e) {
                exceptionRef.set((Object)e);
            }
        }, this.myDialogTitle, true, project2, parentComponent);
        if (!completed) {
            return null;
        }
        Exception exception = (Exception)exceptionRef.get();
        if (exception != null) {
            boolean tryAgain = IOExceptionDialog.showErrorDialog((String)this.myDialogTitle, (String)exception.getMessage());
            if (tryAgain) {
                return this.downloadWithProcess(targetDir, project2, parentComponent);
            }
            return null;
        }
        return FileDownloaderImpl.findVirtualFiles((List)localFiles.get());
    }

    @NotNull
    public List<Pair<File, DownloadableFileDescription>> download(@NotNull File targetDir) throws IOException {
        ArrayList<Pair<File, DownloadableFileDescription>> arrayList;
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/util/download/impl/FileDownloaderImpl", "download"));
        }
        List<Pair<File, DownloadableFileDescription>> downloadedFiles = Collections.synchronizedList(new ArrayList());
        List existingFiles = Collections.synchronizedList(new ArrayList());
        ProgressIndicator parentIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (parentIndicator == null) {
            parentIndicator = new EmptyProgressIndicator();
        }
        try {
            ConcurrentTasksProgressManager progressManager = new ConcurrentTasksProgressManager(parentIndicator, this.myFileDescriptions.size());
            parentIndicator.setText(IdeBundle.message((String)"progress.downloading.0.files.text", (Object[])new Object[]{this.myFileDescriptions.size()}));
            int maxParallelDownloads = Runtime.getRuntime().availableProcessors();
            LOG.debug("Downloading " + this.myFileDescriptions.size() + " files using " + maxParallelDownloads + " threads");
            long start = System.currentTimeMillis();
            ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileDownloaderImpl pool", (int)maxParallelDownloads);
            ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
            AtomicLong totalSize = new AtomicLong();
            for (DownloadableFileDescription downloadableFileDescription : this.myFileDescriptions) {
                results.add(executor.submit(() -> {
                    if (targetDir == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/util/download/impl/FileDownloaderImpl", "lambda$download$1"));
                    }
                    SubTaskProgressIndicator indicator = progressManager.createSubTaskIndicator();
                    indicator.checkCanceled();
                    File existing = new File(targetDir, description.getDefaultFileName());
                    String url = description.getDownloadUrl();
                    if (url.startsWith(LIB_SCHEMA)) {
                        String path = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)LIB_SCHEMA));
                        File file2 = PathManager.findFileInLibDirectory((String)path);
                        existingFiles.add(Pair.create((Object)file2, (Object)description));
                    } else if (url.startsWith("file://")) {
                        String path = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)"file://"));
                        File file3 = new File(path);
                        if (file3.exists()) {
                            existingFiles.add(Pair.create((Object)file3, (Object)description));
                        }
                    } else {
                        File downloaded;
                        try {
                            downloaded = FileDownloaderImpl.downloadFile(description, existing, indicator);
                        }
                        catch (IOException e) {
                            throw new IOException(IdeBundle.message((String)"error.file.download.failed", (Object[])new Object[]{description.getDownloadUrl(), e.getMessage()}), e);
                        }
                        if (FileUtil.filesEqual((File)downloaded, (File)existing)) {
                            existingFiles.add(Pair.create((Object)existing, (Object)description));
                        } else {
                            totalSize.addAndGet(downloaded.length());
                            downloadedFiles.add(Pair.create((Object)downloaded, (Object)description));
                        }
                    }
                    indicator.finished();
                    return null;
                }));
            }
            for (Future future2 : results) {
                try {
                    future2.get();
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException();
                }
                catch (ExecutionException e) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), ProcessCanceledException.class);
                    LOG.error((Throwable)e);
                }
            }
            long duration = System.currentTimeMillis() - start;
            LOG.debug("Downloaded " + StringUtil.formatFileSize((long)totalSize.get()) + " in " + StringUtil.formatDuration((long)duration) + "(" + duration + "ms)");
            ArrayList<Pair<File, DownloadableFileDescription>> localFiles = new ArrayList<Pair<File, DownloadableFileDescription>>();
            localFiles.addAll(FileDownloaderImpl.moveToDir(downloadedFiles, targetDir));
            localFiles.addAll(existingFiles);
            arrayList = localFiles;
        }
        catch (ProcessCanceledException | IOException e) {
            FileDownloaderImpl.deleteFiles(downloadedFiles);
            throw e;
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileDownloaderImpl", "download"));
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile chooseDirectoryForFiles(Project project2, JComponent parentComponent) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(IdeBundle.message((String)"dialog.directory.for.downloaded.files.title", (Object[])new Object[0])).withDescription(IdeBundle.message((String)"dialog.directory.for.downloaded.files.description", (Object[])new Object[0]));
        VirtualFile baseDir = project2 != null ? project2.getBaseDir() : null;
        return FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)parentComponent, (Project)project2, (VirtualFile)baseDir);
    }

    private static List<Pair<File, DownloadableFileDescription>> moveToDir(List<Pair<File, DownloadableFileDescription>> downloadedFiles, File targetDir) throws IOException {
        FileUtil.createDirectory((File)targetDir);
        ArrayList<Pair<File, DownloadableFileDescription>> result2 = new ArrayList<Pair<File, DownloadableFileDescription>>();
        for (Pair<File, DownloadableFileDescription> pair2 : downloadedFiles) {
            DownloadableFileDescription description = (DownloadableFileDescription)pair2.getSecond();
            String fileName = description.generateFileName(s -> !new File(targetDir, (String)s).exists());
            File toFile = new File(targetDir, fileName);
            FileUtil.rename((File)((File)pair2.getFirst()), (File)toFile);
            result2.add((Pair<File, DownloadableFileDescription>)Pair.create((Object)toFile, (Object)description));
        }
        return result2;
    }

    @NotNull
    private static List<Pair<VirtualFile, DownloadableFileDescription>> findVirtualFiles(List<Pair<File, DownloadableFileDescription>> ioFiles) {
        ArrayList<Pair<VirtualFile, DownloadableFileDescription>> result2 = new ArrayList<Pair<VirtualFile, DownloadableFileDescription>>();
        for (Pair<File, DownloadableFileDescription> pair2 : ioFiles) {
            final File ioFile = (File)pair2.getFirst();
            VirtualFile libraryRootFile = (VirtualFile)new WriteAction<VirtualFile>(){

                protected void run(@NotNull Result<VirtualFile> result2) {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/download/impl/FileDownloaderImpl$1", "run"));
                    }
                    String url = VfsUtil.getUrlForLibraryRoot((File)ioFile);
                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
                    result2.setResult((Object)VirtualFileManager.getInstance().refreshAndFindFileByUrl(url));
                }
            }.execute().getResultObject();
            if (libraryRootFile == null) continue;
            result2.add((Pair<VirtualFile, DownloadableFileDescription>)Pair.create((Object)libraryRootFile, (Object)pair2.getSecond()));
        }
        ArrayList<Pair<VirtualFile, DownloadableFileDescription>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileDownloaderImpl", "findVirtualFiles"));
        }
        return arrayList;
    }

    private static void deleteFiles(List<Pair<File, DownloadableFileDescription>> pairs) {
        for (Pair<File, DownloadableFileDescription> pair2 : pairs) {
            FileUtil.delete((File)((File)pair2.getFirst()));
        }
    }

    @NotNull
    private static File downloadFile(final @NotNull DownloadableFileDescription description, final @NotNull File existingFile, final @NotNull ProgressIndicator indicator) throws IOException {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/util/download/impl/FileDownloaderImpl", "downloadFile"));
        }
        if (existingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingFile", "com/intellij/util/download/impl/FileDownloaderImpl", "downloadFile"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/download/impl/FileDownloaderImpl", "downloadFile"));
        }
        final String presentableUrl = description.getPresentableDownloadUrl();
        indicator.setText2(IdeBundle.message((String)"progress.connecting.to.download.file.text", (Object[])new Object[]{presentableUrl}));
        indicator.setIndeterminate(true);
        File file2 = (File)HttpRequests.request((String)description.getDownloadUrl()).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

            public File process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/download/impl/FileDownloaderImpl$2", "process"));
                }
                int size = request.getConnection().getContentLength();
                if (existingFile.exists() && (long)size == existingFile.length()) {
                    return existingFile;
                }
                indicator.setText2(IdeBundle.message((String)"progress.download.file.text", (Object[])new Object[]{description.getPresentableFileName(), presentableUrl}));
                return request.saveToFile(FileUtil.createTempFile((String)"download.", (String)".tmp"), indicator);
            }
        });
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileDownloaderImpl", "downloadFile"));
        }
        return file2;
    }

    @NotNull
    public FileDownloader toDirectory(@NotNull String directoryForDownloadedFilesPath) {
        if (directoryForDownloadedFilesPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryForDownloadedFilesPath", "com/intellij/util/download/impl/FileDownloaderImpl", "toDirectory"));
        }
        this.myDirectoryForDownloadedFilesPath = directoryForDownloadedFilesPath;
        FileDownloaderImpl fileDownloaderImpl = this;
        if (fileDownloaderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/FileDownloaderImpl", "toDirectory"));
        }
        return fileDownloaderImpl;
    }

    @Nullable
    public VirtualFile[] download() {
        List<VirtualFile> files = this.downloadFilesWithProgress(this.myDirectoryForDownloadedFilesPath, this.myProject, this.myParentComponent);
        return files != null ? VfsUtilCore.toVirtualFileArray(files) : null;
    }

    @Nullable
    public List<Pair<VirtualFile, DownloadableFileDescription>> downloadAndReturnWithDescriptions() {
        return this.downloadWithProgress(this.myDirectoryForDownloadedFilesPath, this.myProject, this.myParentComponent);
    }

    private static class SubTaskProgressIndicator
    extends SensitiveProgressWrapper {
        private final AtomicDouble myFraction;
        private final ConcurrentTasksProgressManager myProgressManager;

        private SubTaskProgressIndicator(ConcurrentTasksProgressManager progressManager) {
            super(progressManager.myParent);
            this.myProgressManager = progressManager;
            this.myFraction = new AtomicDouble();
        }

        @Override
        public void setFraction(double newValue) {
            double oldValue = this.myFraction.getAndSet(newValue);
            this.myProgressManager.updateFraction(newValue - oldValue);
        }

        @Override
        public void setIndeterminate(boolean indeterminate) {
            if (this.myProgressManager.myTasksCount > 1) {
                return;
            }
            super.setIndeterminate(indeterminate);
        }

        @Override
        public void setText2(String text2) {
            this.myProgressManager.setText2(this, text2);
        }

        @Override
        public double getFraction() {
            return this.myFraction.get();
        }

        public void finished() {
            this.setFraction(1.0);
            this.myProgressManager.setText2(this, null);
        }
    }

    private static class ConcurrentTasksProgressManager {
        private final ProgressIndicator myParent;
        private final int myTasksCount;
        private final AtomicDouble myTotalFraction;
        private final Object myLock = new Object();
        private final LinkedHashMap<SubTaskProgressIndicator, String> myText2Stack = new LinkedHashMap();

        private ConcurrentTasksProgressManager(ProgressIndicator parent, int tasksCount) {
            this.myParent = parent;
            this.myTasksCount = tasksCount;
            this.myTotalFraction = new AtomicDouble();
        }

        public void updateFraction(double delta) {
            this.myTotalFraction.addAndGet(delta / (double)this.myTasksCount);
            this.myParent.setFraction(this.myTotalFraction.get());
        }

        public SubTaskProgressIndicator createSubTaskIndicator() {
            return new SubTaskProgressIndicator(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setText2(@NotNull SubTaskProgressIndicator subTask, @Nullable String text2) {
            if (subTask == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subTask", "com/intellij/util/download/impl/FileDownloaderImpl$ConcurrentTasksProgressManager", "setText2"));
            }
            if (text2 != null) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myText2Stack.put((Object)subTask, (Object)text2);
                }
                this.myParent.setText2(text2);
            } else {
                String prev;
                Object object = this.myLock;
                synchronized (object) {
                    this.myText2Stack.remove((Object)subTask);
                    prev = (String)this.myText2Stack.getLastValue();
                }
                if (prev != null) {
                    this.myParent.setText2(prev);
                }
            }
        }
    }
}

