/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleEntryIndexer<V>
implements DataIndexer<Integer, V, FileContent> {
    private final boolean myAcceptNullValues;

    protected SingleEntryIndexer(boolean acceptNullValues) {
        this.myAcceptNullValues = acceptNullValues;
    }

    @NotNull
    public final Map<Integer, V> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/util/indexing/SingleEntryIndexer", "map"));
        }
        if (inputData == null) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SingleEntryIndexer", "map"));
            }
            return map2;
        }
        V value2 = this.computeValue(inputData);
        if (value2 == null && !this.myAcceptNullValues) {
            Map map3 = Collections.emptyMap();
            if (map3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SingleEntryIndexer", "map"));
            }
            return map3;
        }
        int key2 = Math.abs(FileBasedIndex.getFileId((VirtualFile)inputData.getFile()));
        Map<Integer, V> map4 = Collections.singletonMap(key2, value2);
        if (map4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SingleEntryIndexer", "map"));
        }
        return map4;
    }

    @Nullable
    protected abstract V computeValue(@NotNull FileContent var1);
}

