/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.io.AppendableStorageBackedByResizableMappedFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.TIntHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VfsAwareMapIndexStorage<Key, Value>
extends MapIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.impl.MapIndexStorage");
    private static final boolean ENABLE_CACHED_HASH_IDS = SystemProperties.getBooleanProperty((String)"idea.index.no.cashed.hashids", (boolean)true);
    private final boolean myBuildKeyHashToVirtualFileMapping;
    private AppendableStorageBackedByResizableMappedFile myKeyHashToVirtualFileMapping;
    private volatile int myLastScannedId;
    private static final ConcurrentIntObjectMap<Boolean> ourInvalidatedSessionIds = ContainerUtil.createConcurrentIntObjectMap();
    private static volatile File mySessionDirectory;

    public VfsAwareMapIndexStorage(@NotNull File storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean readOnly) throws IOException {
        if (storageFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageFile", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "<init>"));
        }
        if (keyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "<init>"));
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExternalizer", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "<init>"));
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, false, true, readOnly);
        this.myBuildKeyHashToVirtualFileMapping = false;
    }

    public VfsAwareMapIndexStorage(@NotNull File storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean buildKeyHashToVirtualFileMapping) throws IOException {
        if (storageFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageFile", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "<init>"));
        }
        if (keyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "<init>"));
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExternalizer", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "<init>"));
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, false, false);
        this.myBuildKeyHashToVirtualFileMapping = buildKeyHashToVirtualFileMapping && FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
        this.initMapAndCache();
    }

    protected void initMapAndCache() throws IOException {
        super.initMapAndCache();
        this.myKeyHashToVirtualFileMapping = this.myBuildKeyHashToVirtualFileMapping ? new AppendableStorageBackedByResizableMappedFile(this.getProjectFile(), 4096, null, 0x100000, true) : null;
    }

    protected void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    @NotNull
    private File getProjectFile() {
        File file2 = new File(this.myBaseStorageFile.getPath() + ".project");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "getProjectFile"));
        }
        return file2;
    }

    private <T extends Throwable> void withLock(ThrowableRunnable<T> r) throws T {
        this.myKeyHashToVirtualFileMapping.getPagedFileStorage().lock();
        try {
            r.run();
        }
        finally {
            this.myKeyHashToVirtualFileMapping.getPagedFileStorage().unlock();
        }
    }

    public void flush() {
        this.l.lock();
        try {
            super.flush();
            if (this.myKeyHashToVirtualFileMapping != null && this.myKeyHashToVirtualFileMapping.isDirty()) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.force());
            }
        }
        finally {
            this.l.unlock();
        }
    }

    public void close() throws StorageException {
        super.close();
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.close());
            }
        }
        catch (RuntimeException e) {
            VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
        }
    }

    public void clear() throws StorageException {
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.close());
            }
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e);
        }
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                IOUtil.deleteAllFilesStartingWith((File)this.getProjectFile());
            }
        }
        catch (RuntimeException e) {
            VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
        }
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeys(@NotNull Processor<Key> processor2, GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "processKeys"));
        }
        this.l.lock();
        try {
            this.myCache.clear();
            if (this.myBuildKeyHashToVirtualFileMapping && idFilter != null) {
                TIntHashSet finalHashMaskSet;
                TIntHashSet hashMaskSet = null;
                long l = System.currentTimeMillis();
                File fileWithCaches = this.getSavedProjectFileValueIds(this.myLastScannedId, scope);
                boolean useCachedHashIds = ENABLE_CACHED_HASH_IDS && (scope instanceof ProjectScopeImpl || scope instanceof ProjectAndLibrariesScope) && fileWithCaches != null;
                int id = this.myKeyHashToVirtualFileMapping.getCurrentLength();
                if (useCachedHashIds && id == this.myLastScannedId && ourInvalidatedSessionIds.remove(id) == null) {
                    try {
                        hashMaskSet = VfsAwareMapIndexStorage.loadHashedIds(fileWithCaches);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (hashMaskSet == null) {
                    if (useCachedHashIds && this.myLastScannedId != 0) {
                        FileUtil.asyncDelete((File)fileWithCaches);
                    }
                    finalHashMaskSet = hashMaskSet = new TIntHashSet(1000);
                    this.withLock(() -> {
                        this.myKeyHashToVirtualFileMapping.force();
                        ProgressManager.checkCanceled();
                        this.myKeyHashToVirtualFileMapping.processAll(key2 -> {
                            if (!idFilter.containsFileId(key2[1])) {
                                return true;
                            }
                            finalHashMaskSet.add(key2[0]);
                            ProgressManager.checkCanceled();
                            return true;
                        }, (KeyDescriptor)IntPairInArrayKeyDescriptor.INSTANCE);
                    });
                    if (useCachedHashIds) {
                        this.saveHashedIds(hashMaskSet, id, scope);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanned keyHashToVirtualFileMapping of " + this.myBaseStorageFile + " for " + (System.currentTimeMillis() - l));
                }
                finalHashMaskSet = hashMaskSet;
                boolean bl = this.myMap.processKeys(key2 -> {
                    if (processor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "lambda$processKeys$5"));
                    }
                    if (!finalHashMaskSet.contains(this.myKeyDescriptor.getHashCode(key2))) {
                        return true;
                    }
                    return processor2.process(key2);
                });
                return bl;
            }
            boolean hashMaskSet = this.myMap.processKeys(processor2);
            return hashMaskSet;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        catch (RuntimeException e) {
            boolean bl = (Boolean)VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
            return bl;
        }
        finally {
            this.l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static TIntHashSet loadHashedIds(@NotNull File fileWithCaches) throws IOException {
        int capacity;
        if (fileWithCaches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileWithCaches", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "loadHashedIds"));
        }
        FilterInputStream inputStream = null;
        inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(fileWithCaches)));
        TIntHashSet hashMaskSet = new TIntHashSet(capacity);
        for (capacity = DataInputOutputUtil.readINT((DataInput)((Object)inputStream)); capacity > 0; --capacity) {
            hashMaskSet.add(DataInputOutputUtil.readINT((DataInput)((Object)inputStream)));
        }
        inputStream.close();
        TIntHashSet tIntHashSet = hashMaskSet;
        TIntHashSet tIntHashSet2 = tIntHashSet;
        if (tIntHashSet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "loadHashedIds"));
        }
        return tIntHashSet2;
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHashedIds(@NotNull TIntHashSet hashMaskSet, int largestId, @NotNull GlobalSearchScope scope) {
        if (hashMaskSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMaskSet", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "saveHashedIds"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "saveHashedIds"));
        }
        File newFileWithCaches = this.getSavedProjectFileValueIds(largestId, scope);
        assert (newFileWithCaches != null);
        DataOutputStream stream = null;
        boolean savedSuccessfully = false;
        try {
            stream = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(newFileWithCaches)));
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)hashMaskSet.size());
            DataOutputStream finalStream = stream;
            savedSuccessfully = hashMaskSet.forEach(value2 -> {
                try {
                    DataInputOutputUtil.writeINT((DataOutput)finalStream, (int)value2);
                    return true;
                }
                catch (IOException ex) {
                    return false;
                }
            });
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                    if (savedSuccessfully) {
                        this.myLastScannedId = largestId;
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getSessionDir() {
        File sessionDirectory = mySessionDirectory;
        if (sessionDirectory != null) return sessionDirectory;
        Class<VfsAwareMapIndexStorage> clazz = VfsAwareMapIndexStorage.class;
        synchronized (VfsAwareMapIndexStorage.class) {
            sessionDirectory = mySessionDirectory;
            if (sessionDirectory != null) return sessionDirectory;
            try {
                mySessionDirectory = sessionDirectory = FileUtil.createTempDirectory((File)new File(PathManager.getTempPath()), (String)Long.toString(System.currentTimeMillis()), (String)"", (boolean)true);
            }
            catch (IOException ex) {
                throw new RuntimeException("Can not create temp directory", ex);
            }
            return sessionDirectory;
        }
    }

    @Nullable
    private File getSavedProjectFileValueIds(int id, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/VfsAwareMapIndexStorage", "getSavedProjectFileValueIds"));
        }
        Project project2 = scope.getProject();
        if (project2 == null) {
            return null;
        }
        return new File(VfsAwareMapIndexStorage.getSessionDir(), this.getProjectFile().getName() + "." + project2.hashCode() + "." + id + "." + scope.isSearchInLibraries());
    }

    public void addValue(Key key2, int inputId, Value value2) throws StorageException {
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.append((Object)new int[]{this.myKeyDescriptor.getHashCode(key2), inputId}, (KeyDescriptor)IntPairInArrayKeyDescriptor.INSTANCE));
                int lastScannedId = this.myLastScannedId;
                if (lastScannedId != 0) {
                    ourInvalidatedSessionIds.cacheOrGet(lastScannedId, (Object)Boolean.TRUE);
                    this.myLastScannedId = 0;
                }
            }
            super.addValue(key2, inputId, value2);
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static class IntPairInArrayKeyDescriptor
    implements KeyDescriptor<int[]>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private static final IntPairInArrayKeyDescriptor INSTANCE = new IntPairInArrayKeyDescriptor();

        private IntPairInArrayKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, int[] value2) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/indexing/VfsAwareMapIndexStorage$IntPairInArrayKeyDescriptor", "save"));
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2[0]);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2[1]);
        }

        public int[] read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/indexing/VfsAwareMapIndexStorage$IntPairInArrayKeyDescriptor", "read"));
            }
            return new int[]{DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in)};
        }

        public int getHashCode(int[] value2) {
            return value2[0] * 31 + value2[1];
        }

        public boolean isEqual(int[] val1, int[] val2) {
            return val1[0] == val2[0] && val1[1] == val2[1];
        }
    }
}

