/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithCompletion
extends LanguageTextField {
    private final boolean myForceAutoPopup;
    private final boolean myShowHint;

    public TextFieldWithCompletion(@NotNull Project project2, @NotNull TextCompletionProvider provider, @NotNull String value2, boolean oneLineMode, boolean forceAutoPopup, boolean showHint2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/textCompletion/TextFieldWithCompletion", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/textCompletion/TextFieldWithCompletion", "<init>"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/textCompletion/TextFieldWithCompletion", "<init>"));
        }
        this(project2, provider, value2, oneLineMode, true, forceAutoPopup, showHint2);
    }

    public TextFieldWithCompletion(@Nullable Project project2, @NotNull TextCompletionProvider provider, @NotNull String value2, boolean oneLineMode, boolean autoPopup, boolean forceAutoPopup, boolean showHint2) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/textCompletion/TextFieldWithCompletion", "<init>"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/textCompletion/TextFieldWithCompletion", "<init>"));
        }
        super(PlainTextLanguage.INSTANCE, project2, value2, new TextCompletionUtil.DocumentWithCompletionCreator(provider, autoPopup), oneLineMode);
        this.myForceAutoPopup = forceAutoPopup;
        this.myShowHint = showHint2;
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        EditorCustomization disableSpellChecking = SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization();
        if (disableSpellChecking != null) {
            disableSpellChecking.customize(editor);
        }
        editor.putUserData(AutoPopupController.ALWAYS_AUTO_POPUP, this.myForceAutoPopup);
        if (this.myShowHint) {
            TextCompletionUtil.installCompletionHint(editor);
        }
        return editor;
    }
}

