/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdePopupManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class OwnerOptional {
    private Window myPermanentOwner;

    private static Window findOwnerByComponent(Component component) {
        if (component == null) {
            component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (component == null) {
            component = Window.getWindows()[0];
        }
        return component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
    }

    private OwnerOptional(Window permanentOwner) {
        this.myPermanentOwner = permanentOwner;
    }

    public static OwnerOptional fromComponent(Component parentComponent) {
        Window owner2 = OwnerOptional.findOwnerByComponent(parentComponent);
        IdePopupManager manager = IdeEventQueue.getInstance().getPopupManager();
        if (manager.isPopupWindow(owner2)) {
            manager.closeAllPopups();
            for (owner2 = owner2.getOwner(); owner2 != null && !(owner2 instanceof Dialog) && !(owner2 instanceof Frame); owner2 = owner2.getOwner()) {
            }
        }
        if (owner2 instanceof Dialog) {
            Dialog ownerDialog = (Dialog)owner2;
            if (ownerDialog.isModal()) {
                owner2 = ownerDialog;
            } else {
                while (owner2 instanceof Dialog && !((Dialog)owner2).isModal()) {
                    owner2 = owner2.getOwner();
                }
            }
        }
        while (owner2 != null && !owner2.isShowing()) {
            owner2 = owner2.getOwner();
        }
        return new OwnerOptional(owner2);
    }

    public OwnerOptional ifDialog(Consumer<Dialog> consumer) {
        if (this.myPermanentOwner instanceof Dialog) {
            consumer.consume((Object)((Dialog)this.myPermanentOwner));
        }
        return this;
    }

    public OwnerOptional ifNull(Consumer<Frame> consumer) {
        if (this.myPermanentOwner == null) {
            consumer.consume(null);
        }
        return this;
    }

    public OwnerOptional ifWindow(Consumer<Window> consumer) {
        if (this.myPermanentOwner != null) {
            consumer.consume((Object)this.myPermanentOwner);
        }
        return this;
    }

    public OwnerOptional ifFrame(Consumer<Frame> consumer) {
        if (this.myPermanentOwner instanceof Frame) {
            if (this.myPermanentOwner instanceof IdeFrame.Child) {
                IdeFrame.Child ideFrameChild = (IdeFrame.Child)this.myPermanentOwner;
                this.myPermanentOwner = WindowManager.getInstance().getFrame(ideFrameChild.getProject());
            }
            consumer.consume((Object)((Frame)this.myPermanentOwner));
        }
        return this;
    }

    public Window get() {
        return this.myPermanentOwner;
    }
}

