/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.util.Iconable;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IconTableCellRenderer<T>
extends DefaultTableCellRenderer {
    public static final IconTableCellRenderer<Iconable> ICONABLE = new IconTableCellRenderer<Iconable>(){

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Iconable value2, JTable table, int row) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/ui/table/IconTableCellRenderer$1", "getIcon"));
            }
            return value2.getIcon(1);
        }
    };

    public static TableCellRenderer create(final @NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/util/ui/table/IconTableCellRenderer", "create"));
        }
        return new IconTableCellRenderer(){

            @Nullable
            protected Icon getIcon(@NotNull Object value2, JTable table, int row) {
                if (value2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/ui/table/IconTableCellRenderer$2", "getIcon"));
                }
                return icon;
            }
        };
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean selected, boolean focus, int row, int column) {
        super.getTableCellRendererComponent(table, value2, selected, focus, row, column);
        this.setIcon(value2 == null ? null : this.getIcon(value2, table, row));
        if (this.isCenterAlignment()) {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }
        return this;
    }

    protected boolean isCenterAlignment() {
        return false;
    }

    @Nullable
    protected abstract Icon getIcon(@NotNull T var1, JTable var2, int var3);
}

