/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ClientPropertyHolder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.ProjectContentFileFilter;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractFileTreeTable<T>
extends TreeTable {
    private final MyModel<T> myModel;
    private final Project myProject;

    public AbstractFileTreeTable(@NotNull Project project2, @NotNull Class<T> valueClass, @NotNull String valueTitle, @NotNull VirtualFileFilter filter, boolean showProjectNode) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/tree/AbstractFileTreeTable", "<init>"));
        }
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/ui/tree/AbstractFileTreeTable", "<init>"));
        }
        if (valueTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueTitle", "com/intellij/util/ui/tree/AbstractFileTreeTable", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/ui/tree/AbstractFileTreeTable", "<init>"));
        }
        this(project2, valueClass, valueTitle, filter, showProjectNode, true);
    }

    public AbstractFileTreeTable(@NotNull Project project2, @NotNull Class<T> valueClass, @NotNull String valueTitle, @NotNull VirtualFileFilter filter, boolean showProjectNode, boolean showContentFilesOnly) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/tree/AbstractFileTreeTable", "<init>"));
        }
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/ui/tree/AbstractFileTreeTable", "<init>"));
        }
        if (valueTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueTitle", "com/intellij/util/ui/tree/AbstractFileTreeTable", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/ui/tree/AbstractFileTreeTable", "<init>"));
        }
        super(new MyModel(project2, valueClass, valueTitle, showContentFilesOnly ? new ProjectContentFileFilter(project2, filter) : filter));
        this.myProject = project2;
        this.myModel = (MyModel)this.getTableModel();
        this.myModel.setTreeTable(this);
        new TreeTableSpeedSearch(this, (Convertor<TreePath, String>)((Convertor)o -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject == null) {
                return AbstractFileTreeTable.getProjectNodeText();
            }
            if (userObject instanceof VirtualFile) {
                return ((VirtualFile)userObject).getName();
            }
            return node.toString();
        }));
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.getTree());
        CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this));
        CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this));
        this.getTree().setShowsRootHandles(true);
        this.getTree().setLineStyleAngled();
        this.getTree().setRootVisible(showProjectNode);
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        this.getTree().setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){
            private SimpleColoredComponent myComponent = new SimpleColoredComponent();

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.myComponent.clear();
                if (value2 instanceof ProjectRootNode) {
                    this.myComponent.append(AbstractFileTreeTable.getProjectNodeText());
                    this.myComponent.setIcon(AllIcons.Nodes.Project);
                } else {
                    FileNode fileNode = (FileNode)value2;
                    VirtualFile file2 = (VirtualFile)fileNode.getObject();
                    this.myComponent.append(fileNode.getParent() instanceof FileNode ? file2.getName() : file2.getPresentableUrl());
                    Icon icon = file2.isDirectory() ? (fileIndex.isExcluded(file2) ? AllIcons.Modules.ExcludeRoot : PlatformIcons.DIRECTORY_CLOSED_ICON) : IconUtil.getIcon((VirtualFile)file2, (int)0, null);
                    this.myComponent.setIcon(icon);
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((Object)AbstractFileTreeTable.this), (SimpleColoredComponent)this.myComponent, (boolean)false, (boolean)this.selected);
                return this.myComponent;
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        this.setPreferredScrollableViewportSize(new Dimension(300, this.getRowHeight() * 10));
        this.getColumnModel().getColumn(0).setPreferredWidth(280);
        this.getColumnModel().getColumn(1).setPreferredWidth(60);
    }

    protected boolean isNullObject(T value2) {
        return false;
    }

    private static String getProjectNodeText() {
        return "Project";
    }

    public Project getProject() {
        return this.myProject;
    }

    public TableColumn getValueColumn() {
        return this.getColumnModel().getColumn(1);
    }

    protected boolean isValueEditableForFile(VirtualFile virtualFile) {
        return true;
    }

    public static void press(Container comboComponent) {
        if (comboComponent instanceof JButton) {
            ((JButton)comboComponent).doClick();
        } else {
            for (int i2 = 0; i2 < comboComponent.getComponentCount(); ++i2) {
                Component child = comboComponent.getComponent(i2);
                if (!(child instanceof Container)) continue;
                AbstractFileTreeTable.press((Container)child);
            }
        }
    }

    public boolean clearSubdirectoriesOnDemandOrCancel(VirtualFile parent, String message2, String title) {
        Map mappings = ((MyModel)this.myModel).myCurrentMapping;
        THashMap subdirectoryMappings = new THashMap();
        for (VirtualFile file2 : mappings.keySet()) {
            if (file2 == null || parent != null && !VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file2, (boolean)true)) continue;
            subdirectoryMappings.put(file2, mappings.get(file2));
        }
        if (subdirectoryMappings.isEmpty()) {
            return true;
        }
        int ret = Messages.showYesNoCancelDialog((Project)this.myProject, (String)message2, (String)title, (String)"Override", (String)"Do Not Override", (String)"Cancel", (Icon)Messages.getWarningIcon());
        if (ret == 0) {
            for (VirtualFile file3 : subdirectoryMappings.keySet()) {
                this.myModel.setValueAt(null, new DefaultMutableTreeNode(file3), 1);
            }
        }
        return ret != 2;
    }

    @NotNull
    public Map<VirtualFile, T> getValues() {
        Map map2 = ((MyModel)this.myModel).getValues();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/tree/AbstractFileTreeTable", "getValues"));
        }
        return map2;
    }

    public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
        TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
        UIUtil.setLineStyleAngled((ClientPropertyHolder)tableRenderer);
        tableRenderer.setRootVisible(false);
        tableRenderer.setShowsRootHandles(true);
        return tableRenderer;
    }

    public void reset(@NotNull Map<VirtualFile, T> mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/util/ui/tree/AbstractFileTreeTable", "reset"));
        }
        this.myModel.reset(mappings);
        this.myModel.nodeChanged((TreeNode)this.myModel.getRoot());
        this.getTree().setModel(null);
        this.getTree().setModel(this.myModel);
        TreeUtil.expandRootChildIfOnlyOne((JTree)this.getTree());
    }

    public void select(@Nullable VirtualFile toSelect2) {
        if (toSelect2 != null) {
            this.select(toSelect2, (TreeNode)this.myModel.getRoot());
        }
    }

    private void select(@NotNull VirtualFile toSelect2, TreeNode root) {
        if (toSelect2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSelect", "com/intellij/util/ui/tree/AbstractFileTreeTable", "select"));
        }
        for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
            TreeNode child = root.getChildAt(i2);
            VirtualFile file2 = (VirtualFile)((FileNode)child).getObject();
            if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)toSelect2, (boolean)false)) continue;
            if (Comparing.equal((Object)file2, (Object)toSelect2)) {
                TreeUtil.selectNode((JTree)this.getTree(), (TreeNode)child);
                this.getSelectionModel().clearSelection();
                this.addSelectedPath(TreeUtil.getPathFromRoot((TreeNode)child));
                TableUtil.scrollSelectionToVisible((JTable)((Object)this));
            } else {
                this.select(toSelect2, child);
            }
            return;
        }
    }

    public static class FileNode
    extends ConvenientNode<VirtualFile> {
        private final Project myProject;
        private final VirtualFileFilter myFilter;

        public FileNode(@NotNull VirtualFile file2, @NotNull Project project2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ui/tree/AbstractFileTreeTable$FileNode", "<init>"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/tree/AbstractFileTreeTable$FileNode", "<init>"));
            }
            this(file2, project2, VirtualFileFilter.ALL);
        }

        public FileNode(@NotNull VirtualFile file2, @NotNull Project project2, @NotNull VirtualFileFilter filter) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ui/tree/AbstractFileTreeTable$FileNode", "<init>"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/tree/AbstractFileTreeTable$FileNode", "<init>"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/ui/tree/AbstractFileTreeTable$FileNode", "<init>"));
            }
            super((Object)file2);
            this.myProject = project2;
            this.myFilter = filter;
        }

        @Override
        protected void appendChildrenTo(@NotNull Collection<ConvenientNode> children2) {
            if (children2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/util/ui/tree/AbstractFileTreeTable$FileNode", "appendChildrenTo"));
            }
            for (VirtualFile child : ((VirtualFile)this.getObject()).getChildren()) {
                if (!this.myFilter.accept(child)) continue;
                children2.add(new FileNode(child, this.myProject, this.myFilter));
            }
        }
    }

    public static abstract class ConvenientNode<T>
    extends DefaultMutableTreeNode {
        private final T myObject;

        private ConvenientNode(T object) {
            this.myObject = object;
        }

        public T getObject() {
            return this.myObject;
        }

        protected abstract void appendChildrenTo(@NotNull Collection<ConvenientNode> var1);

        @Override
        public int getChildCount() {
            this.init();
            return super.getChildCount();
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            this.init();
            return super.getChildAt(childIndex);
        }

        public Enumeration children() {
            this.init();
            return super.children();
        }

        private void init() {
            if (this.getUserObject() == null) {
                this.setUserObject(this.myObject);
                ArrayList<ConvenientNode> children2 = new ArrayList<ConvenientNode>();
                this.appendChildrenTo(children2);
                Collections.sort(children2, (node1, node2) -> {
                    Object o2;
                    Object o1 = node1.getObject();
                    if (o1 == (o2 = node2.getObject())) {
                        return 0;
                    }
                    if (o1 instanceof Project) {
                        return -1;
                    }
                    if (o2 instanceof Project) {
                        return 1;
                    }
                    VirtualFile file1 = (VirtualFile)o1;
                    VirtualFile file2 = (VirtualFile)o2;
                    if (file1.isDirectory() != file2.isDirectory()) {
                        return file1.isDirectory() ? -1 : 1;
                    }
                    return file1.getName().compareTo(file2.getName());
                });
                int i2 = 0;
                for (ConvenientNode child : children2) {
                    this.insert(child, i2++);
                }
            }
        }

        public void clearCachedChildren() {
            if (this.children != null) {
                for (Object child : this.children) {
                    ((ConvenientNode)child).clearCachedChildren();
                }
            }
            this.removeAllChildren();
            this.setUserObject(null);
        }
    }

    public static class ProjectRootNode
    extends ConvenientNode<Project> {
        private final VirtualFileFilter myFilter;

        public ProjectRootNode(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/tree/AbstractFileTreeTable$ProjectRootNode", "<init>"));
            }
            this(project2, VirtualFileFilter.ALL);
        }

        public ProjectRootNode(@NotNull Project project2, @NotNull VirtualFileFilter filter) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/tree/AbstractFileTreeTable$ProjectRootNode", "<init>"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/ui/tree/AbstractFileTreeTable$ProjectRootNode", "<init>"));
            }
            super((Object)project2);
            this.myFilter = filter;
        }

        @Override
        protected void appendChildrenTo(@NotNull Collection<ConvenientNode> children2) {
            VirtualFile[] roots;
            if (children2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/util/ui/tree/AbstractFileTreeTable$ProjectRootNode", "appendChildrenTo"));
            }
            Project project2 = (Project)this.getObject();
            block0: for (VirtualFile root : roots = ProjectRootManager.getInstance((Project)project2).getContentRoots()) {
                for (VirtualFile candidate : roots) {
                    if (VfsUtilCore.isAncestor((VirtualFile)candidate, (VirtualFile)root, (boolean)true)) continue block0;
                }
                if (!this.myFilter.accept(root)) continue;
                children2.add(new FileNode(root, project2, this.myFilter));
            }
        }
    }

    private static class MyModel<T>
    extends DefaultTreeModel
    implements TreeTableModel {
        private final Map<VirtualFile, T> myCurrentMapping;
        private final Class<T> myValueClass;
        private final String myValueTitle;
        private AbstractFileTreeTable<T> myTreeTable;

        private MyModel(@NotNull Project project2, @NotNull Class<T> valueClass, @NotNull String valueTitle, @NotNull VirtualFileFilter filter) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/tree/AbstractFileTreeTable$MyModel", "<init>"));
            }
            if (valueClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/ui/tree/AbstractFileTreeTable$MyModel", "<init>"));
            }
            if (valueTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueTitle", "com/intellij/util/ui/tree/AbstractFileTreeTable$MyModel", "<init>"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/ui/tree/AbstractFileTreeTable$MyModel", "<init>"));
            }
            super(new ProjectRootNode(project2, filter));
            this.myCurrentMapping = new HashMap();
            this.myValueClass = valueClass;
            this.myValueTitle = valueTitle;
        }

        private Map<VirtualFile, T> getValues() {
            return new HashMap(this.myCurrentMapping);
        }

        public void setTree(JTree tree) {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "File/Directory";
                }
                case 1: {
                    return this.myValueTitle;
                }
            }
            throw new RuntimeException("invalid column " + column);
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 1: {
                    return this.myValueClass;
                }
            }
            throw new RuntimeException("invalid column " + column);
        }

        public Object getValueAt(Object node, int column) {
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            if (userObject instanceof Project) {
                switch (column) {
                    case 0: {
                        return userObject;
                    }
                    case 1: {
                        return this.myCurrentMapping.get(null);
                    }
                }
            }
            VirtualFile file2 = (VirtualFile)userObject;
            switch (column) {
                case 0: {
                    return file2;
                }
                case 1: {
                    return this.myCurrentMapping.get(file2);
                }
            }
            throw new RuntimeException("invalid column " + column);
        }

        public boolean isCellEditable(Object node, int column) {
            switch (column) {
                case 0: {
                    return false;
                }
                case 1: {
                    Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
                    return !(userObject instanceof VirtualFile) && userObject != null || this.myTreeTable.isValueEditableForFile((VirtualFile)userObject);
                }
            }
            throw new RuntimeException("invalid column " + column);
        }

        public void setValueAt(Object aValue, Object node, int column) {
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            if (userObject instanceof Project) {
                return;
            }
            VirtualFile file2 = (VirtualFile)userObject;
            Object t = aValue;
            if (t == null || this.myTreeTable.isNullObject(t)) {
                this.myCurrentMapping.remove(file2);
            } else {
                this.myCurrentMapping.put(file2, t);
            }
            this.fireTreeNodesChanged(this, new Object[]{this.getRoot()}, null, null);
        }

        public void reset(@NotNull Map<VirtualFile, T> mappings) {
            if (mappings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/util/ui/tree/AbstractFileTreeTable$MyModel", "reset"));
            }
            this.myCurrentMapping.clear();
            this.myCurrentMapping.putAll(mappings);
            ((ProjectRootNode)this.getRoot()).clearCachedChildren();
        }

        void setTreeTable(AbstractFileTreeTable<T> treeTable) {
            this.myTreeTable = treeTable;
        }
    }
}

