/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.CustomChildren;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.PropertyAccessor;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import com.intellij.util.xml.SubTagsList;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.InvocationCache;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticGenericInfoBuilder {
    private static final Set ADDER_PARAMETER_TYPES = new THashSet(Arrays.asList(Class.class, Integer.TYPE));
    private static final Logger LOG = Logger.getInstance(StaticGenericInfoBuilder.class);
    private final Class myClass;
    private final MultiValuesMap<XmlName, JavaMethod> myCollectionGetters = new MultiValuesMap();
    final MultiValuesMap<XmlName, JavaMethod> collectionAdders = new MultiValuesMap();
    final MultiValuesMap<XmlName, JavaMethod> collectionClassAdders = new MultiValuesMap();
    final MultiValuesMap<XmlName, JavaMethod> collectionIndexAdders = new MultiValuesMap();
    final MultiValuesMap<XmlName, JavaMethod> collectionIndexClassAdders = new MultiValuesMap();
    final MultiValuesMap<XmlName, JavaMethod> collectionClassIndexAdders = new MultiValuesMap();
    private final Map<XmlName, Type> myCollectionChildrenTypes = new THashMap();
    private final Map<JavaMethodSignature, String[]> myCompositeCollectionGetters = new THashMap();
    private final Map<JavaMethodSignature, Pair<String, String[]>> myCompositeCollectionAdders = new THashMap();
    private final FactoryMap<XmlName, TIntObjectHashMap<Collection<JavaMethod>>> myFixedChildrenGetters = new FactoryMap<XmlName, TIntObjectHashMap<Collection<JavaMethod>>>(){

        protected TIntObjectHashMap<Collection<JavaMethod>> create(XmlName key2) {
            return new TIntObjectHashMap();
        }
    };
    private final Map<JavaMethodSignature, AttributeChildDescriptionImpl> myAttributes = new THashMap();
    private boolean myValueElement;
    private JavaMethod myNameValueGetter;
    private JavaMethod myCustomChildrenGetter;

    public StaticGenericInfoBuilder(Class aClass) {
        Class<? extends DomElement> implClass;
        this.myClass = aClass;
        LinkedHashSet<JavaMethod> methods = new LinkedHashSet<JavaMethod>();
        InvocationCache invocationCache = DomApplicationComponent.getInstance().getInvocationCache(this.myClass);
        for (Method method : ReflectionUtil.getClassPublicMethods((Class)this.myClass)) {
            methods.add(invocationCache.getInternedMethod(method));
        }
        for (JavaMethod javaMethod : methods) {
            if (!DomImplUtil.isGetter(javaMethod) || javaMethod.getAnnotation(NameValue.class) == null) continue;
            this.myNameValueGetter = javaMethod;
            break;
        }
        if ((implClass = DomApplicationComponent.getInstance().getImplementation(this.myClass)) != null) {
            for (Method method3 : ReflectionUtil.getClassPublicMethods(implClass)) {
                int modifiers = method3.getModifiers();
                if (Modifier.isAbstract(modifiers) || Modifier.isVolatile(modifiers) || new JavaMethodSignature(method3).findMethod(this.myClass) == null) continue;
                methods.remove(invocationCache.getInternedMethod(method3));
            }
        }
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            if (!StaticGenericInfoBuilder.isCoreMethod(javaMethod) && !DomImplUtil.isTagValueSetter(javaMethod) && javaMethod.getAnnotation(PropertyAccessor.class) == null) continue;
            iterator.remove();
        }
        iterator = methods.iterator();
        while (iterator.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            if (!DomImplUtil.isGetter(javaMethod) || !this.processGetterMethod(javaMethod)) continue;
            iterator.remove();
        }
        iterator = methods.iterator();
        while (iterator.hasNext()) {
            MultiValuesMap<XmlName, JavaMethod> adders;
            XmlName xmlName;
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            SubTagsList subTagsList = (SubTagsList)javaMethod.getAnnotation(SubTagsList.class);
            if (subTagsList != null && javaMethod.getName().startsWith("add")) {
                String localName = subTagsList.tagName();
                assert (StringUtil.isNotEmpty((String)localName));
                String[] set2 = subTagsList.value();
                assert (Arrays.asList(set2).contains(localName));
                this.myCompositeCollectionAdders.put(javaMethod.getSignature(), (Pair<String, String[]>)Pair.create((Object)localName, (Object)set2));
                iterator.remove();
                continue;
            }
            if (!this.isAddMethod(javaMethod) || !this.myCollectionGetters.containsKey((Object)(xmlName = this.extractTagName(javaMethod, "add"))) || (adders = this.getAddersMap(javaMethod)) == null) continue;
            adders.put((Object)xmlName, (Object)javaMethod);
            iterator.remove();
        }
    }

    @Nullable
    private MultiValuesMap<XmlName, JavaMethod> getAddersMap(JavaMethod method) {
        Class[] parameterTypes = method.getParameterTypes();
        switch (parameterTypes.length) {
            case 0: {
                return this.collectionAdders;
            }
            case 1: {
                if (Class.class.equals((Object)parameterTypes[0])) {
                    return this.collectionClassAdders;
                }
                if (!StaticGenericInfoBuilder.isInt(parameterTypes[0])) break;
                return this.collectionIndexAdders;
            }
            case 2: {
                if (StaticGenericInfoBuilder.isIndexClassAdder(parameterTypes[0], parameterTypes[1])) {
                    return this.collectionIndexClassAdders;
                }
                if (!StaticGenericInfoBuilder.isIndexClassAdder(parameterTypes[1], parameterTypes[0])) break;
                return this.collectionClassIndexAdders;
            }
        }
        return null;
    }

    private static boolean isIndexClassAdder(Class<?> first, Class<?> second) {
        return StaticGenericInfoBuilder.isInt(first) && second.equals(Class.class);
    }

    private static boolean isInt(Class<?> aClass) {
        return aClass.equals(Integer.TYPE) || aClass.equals(Integer.class);
    }

    private boolean isAddMethod(JavaMethod method) {
        XmlName tagName = this.extractTagName(method, "add");
        if (tagName == null) {
            return false;
        }
        Type type2 = this.myCollectionChildrenTypes.get(tagName);
        if (type2 == null || !ReflectionUtil.getRawType((Type)type2).isAssignableFrom(method.getReturnType())) {
            return false;
        }
        return ADDER_PARAMETER_TYPES.containsAll(Arrays.asList(method.getParameterTypes()));
    }

    @Nullable
    private XmlName extractTagName(JavaMethod method, @NonNls String prefix) {
        String name2 = method.getName();
        if (!name2.startsWith(prefix)) {
            return null;
        }
        SubTagList subTagAnnotation = (SubTagList)method.getAnnotation(SubTagList.class);
        if (subTagAnnotation != null && !StringUtil.isEmpty((String)subTagAnnotation.value())) {
            return DomImplUtil.createXmlName(subTagAnnotation.value(), method);
        }
        String tagName = this.getNameStrategy(false).convertName(name2.substring(prefix.length()));
        return StringUtil.isEmpty((String)tagName) ? null : DomImplUtil.createXmlName(tagName, method);
    }

    private static boolean isDomElement(Type type2) {
        return type2 != null && DomElement.class.isAssignableFrom(ReflectionUtil.getRawType((Type)type2));
    }

    private boolean processGetterMethod(JavaMethod method) {
        String qname;
        boolean isAttributeMethod;
        if (DomImplUtil.isTagValueGetter(method)) {
            this.myValueElement = true;
            return true;
        }
        Class returnType = method.getReturnType();
        boolean isAttributeValueMethod = GenericAttributeValue.class.isAssignableFrom(returnType);
        JavaMethodSignature signature = method.getSignature();
        Attribute annotation = (Attribute)method.getAnnotation(Attribute.class);
        boolean bl = isAttributeMethod = annotation != null || isAttributeValueMethod;
        if (annotation != null) assert (isAttributeValueMethod || GenericAttributeValue.class.isAssignableFrom(returnType)) : method + " should return GenericAttributeValue";
        if (isAttributeMethod) {
            String attributeName;
            String s = annotation == null ? null : annotation.value();
            String string = attributeName = StringUtil.isEmpty((String)s) ? this.getNameFromMethod(method, true) : s;
            assert (attributeName != null && StringUtil.isNotEmpty((String)attributeName)) : "Can't guess attribute name from method name: " + method.getName();
            XmlName attrName = DomImplUtil.createXmlName(attributeName, method);
            this.myAttributes.put(signature, new AttributeChildDescriptionImpl(attrName, method));
            return true;
        }
        if (StaticGenericInfoBuilder.isDomElement(returnType) && (qname = this.getSubTagName(method)) != null) {
            TIntObjectHashMap map2;
            Collection methods;
            XmlName xmlName = DomImplUtil.createXmlName(qname, method);
            Type collectionType = this.myCollectionChildrenTypes.get(xmlName);
            if (collectionType != null) {
                LOG.error("Collection (" + collectionType + ") and fixed children cannot intersect: " + qname + " for " + this.myClass);
            }
            int index = 0;
            SubTag subTagAnnotation = (SubTag)method.getAnnotation(SubTag.class);
            if (subTagAnnotation != null && subTagAnnotation.index() != 0) {
                index = subTagAnnotation.index();
            }
            if ((methods = (Collection)(map2 = (TIntObjectHashMap)this.myFixedChildrenGetters.get((Object)xmlName)).get(index)) == null) {
                methods = new SmartList();
                map2.put(index, (Object)methods);
            }
            methods.add(method);
            return true;
        }
        Type type2 = DomReflectionUtil.extractCollectionElementType((Type)method.getGenericReturnType());
        if (StaticGenericInfoBuilder.isDomElement(type2)) {
            CustomChildren customChildren = (CustomChildren)method.getAnnotation(CustomChildren.class);
            if (customChildren != null) {
                this.myCustomChildrenGetter = method;
                return true;
            }
            SubTagsList subTagsList = (SubTagsList)method.getAnnotation(SubTagsList.class);
            if (subTagsList != null) {
                this.myCompositeCollectionGetters.put(signature, subTagsList.value());
                return true;
            }
            String qname2 = this.getSubTagNameForCollection(method);
            if (qname2 != null) {
                XmlName xmlName = DomImplUtil.createXmlName(qname2, type2, method);
                assert (!this.myFixedChildrenGetters.containsKey((Object)xmlName)) : "Collection and fixed children cannot intersect: " + qname2;
                this.myCollectionChildrenTypes.put(xmlName, type2);
                this.myCollectionGetters.put((Object)xmlName, (Object)method);
                return true;
            }
        }
        return false;
    }

    private static boolean isCoreMethod(JavaMethod method) {
        if (method.getSignature().findMethod(DomElement.class) != null) {
            return true;
        }
        Class aClass = method.getDeclaringClass();
        return aClass.equals(GenericAttributeValue.class) || aClass.equals(GenericDomValue.class) && "getConverter".equals(method.getName());
    }

    @Nullable
    private String getSubTagName(JavaMethod method) {
        SubTag subTagAnnotation = (SubTag)method.getAnnotation(SubTag.class);
        if (subTagAnnotation == null || StringUtil.isEmpty((String)subTagAnnotation.value())) {
            return this.getNameFromMethod(method, false);
        }
        return subTagAnnotation.value();
    }

    @Nullable
    private String getSubTagNameForCollection(JavaMethod method) {
        SubTagList subTagList = (SubTagList)method.getAnnotation(SubTagList.class);
        if (subTagList == null || StringUtil.isEmpty((String)subTagList.value())) {
            String propertyName = StaticGenericInfoBuilder.getPropertyName(method);
            if (propertyName != null) {
                String singular = StringUtil.unpluralize((String)propertyName);
                assert (singular != null) : "Can't unpluralize: " + propertyName;
                return this.getNameStrategy(false).convertName(singular);
            }
            return null;
        }
        return subTagList.value();
    }

    @Nullable
    private String getNameFromMethod(JavaMethod method, boolean isAttribute) {
        String propertyName = StaticGenericInfoBuilder.getPropertyName(method);
        return propertyName == null ? null : this.getNameStrategy(isAttribute).convertName(propertyName);
    }

    @Nullable
    private static String getPropertyName(JavaMethod method) {
        return StringUtil.getPropertyName((String)method.getMethodName());
    }

    @NotNull
    private DomNameStrategy getNameStrategy(boolean isAttribute) {
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(ReflectionUtil.getRawType((Type)this.myClass), isAttribute);
        DomNameStrategy domNameStrategy = strategy != null ? strategy : DomNameStrategy.HYPHEN_STRATEGY;
        if (domNameStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/StaticGenericInfoBuilder", "getNameStrategy"));
        }
        return domNameStrategy;
    }

    final JavaMethod getCustomChildrenGetter() {
        return this.myCustomChildrenGetter;
    }

    final Map<JavaMethodSignature, AttributeChildDescriptionImpl> getAttributes() {
        return this.myAttributes;
    }

    final Map<JavaMethodSignature, Pair<FixedChildDescriptionImpl, Integer>> getFixedGetters() {
        THashMap map2 = new THashMap();
        Set names = this.myFixedChildrenGetters.keySet();
        for (XmlName name2 : names) {
            int i22;
            int[] ints;
            TIntObjectHashMap map1 = (TIntObjectHashMap)this.myFixedChildrenGetters.get((Object)name2);
            int max = 0;
            for (int i22 : ints = map1.keys()) {
                max = Math.max(max, i22);
            }
            int count = max + 1;
            Collection[] getters = new Collection[count];
            int[] nArray = ints;
            i22 = nArray.length;
            for (int j = 0; j < i22; ++j) {
                int i3 = nArray[j];
                getters[i3] = (Collection)map1.get(i3);
            }
            FixedChildDescriptionImpl description = new FixedChildDescriptionImpl(name2, ((JavaMethod)((Collection)map1.get(0)).iterator().next()).getGenericReturnType(), count, getters);
            for (i22 = 0; i22 < getters.length; ++i22) {
                Collection collection = getters[i22];
                for (JavaMethod method : collection) {
                    map2.put(method.getSignature(), Pair.create((Object)description, (Object)i22));
                }
            }
        }
        return map2;
    }

    final Map<JavaMethodSignature, CollectionChildDescriptionImpl> getCollectionGetters() {
        THashMap getters = new THashMap();
        for (XmlName xmlName : this.myCollectionGetters.keySet()) {
            Collection collGetters = this.myCollectionGetters.get((Object)xmlName);
            JavaMethod method = (JavaMethod)collGetters.iterator().next();
            CollectionChildDescriptionImpl description = new CollectionChildDescriptionImpl(xmlName, DomReflectionUtil.extractCollectionElementType((Type)method.getGenericReturnType()), collGetters);
            for (JavaMethod getter : collGetters) {
                getters.put(getter.getSignature(), description);
            }
        }
        return getters;
    }

    final Map<JavaMethodSignature, Pair<String, String[]>> getCompositeCollectionAdders() {
        return this.myCompositeCollectionAdders;
    }

    final Map<JavaMethodSignature, String[]> getCompositeCollectionGetters() {
        return this.myCompositeCollectionGetters;
    }

    public JavaMethod getNameValueGetter() {
        return this.myNameValueGetter;
    }

    public boolean isValueElement() {
        return this.myValueElement;
    }
}

