/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ClassMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementsErrorPanel;
import com.intellij.util.xml.ui.BaseControl;
import com.intellij.util.xml.ui.CaptionComponent;
import com.intellij.util.xml.ui.ComboTableCellEditor;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CommittableUtil;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import com.intellij.util.xml.ui.TextControl;
import java.awt.Component;
import java.lang.reflect.Type;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomUIFactoryImpl
extends DomUIFactory {
    private final ClassMap<Function<DomWrapper<String>, BaseControl>> myCustomControlCreators = new ClassMap();
    private final ClassMap<Function<DomElement, TableCellEditor>> myCustomCellEditorCreators = new ClassMap();

    public DomUIFactoryImpl() {
        Consumer[] extensions;
        Function booleanCreator = domElement -> new BooleanTableCellEditor();
        this.registerCustomCellEditor(Boolean.class, (Function<DomElement, TableCellEditor>)booleanCreator);
        this.registerCustomCellEditor(Boolean.TYPE, (Function<DomElement, TableCellEditor>)booleanCreator);
        this.registerCustomCellEditor(String.class, (Function<DomElement, TableCellEditor>)((Function)domElement -> new DefaultCellEditor(DomUIFactoryImpl.removeBorder(new JTextField()))));
        for (Consumer extension : extensions = (Consumer[])Extensions.getExtensions((ExtensionPointName)EXTENSION_POINT_NAME)) {
            extension.consume((Object)this);
        }
    }

    protected TableCellEditor createCellEditor(DomElement element, Class type2) {
        if (Enum.class.isAssignableFrom(type2)) {
            return new ComboTableCellEditor(type2, false);
        }
        Function function = (Function)this.myCustomCellEditorCreators.get(type2);
        assert (function != null) : "Type not supported: " + type2;
        return (TableCellEditor)function.fun((Object)element);
    }

    public final UserActivityWatcher createEditorAwareUserActivityWatcher() {
        return new UserActivityWatcher(){
            private final DocumentListener myListener = new DocumentListener(){

                public void documentChanged(DocumentEvent e) {
                    this.fireUIChanged();
                }
            };

            protected void processComponent(Component component) {
                super.processComponent(component);
                if (component instanceof EditorComponentImpl) {
                    ((EditorComponentImpl)component).getEditor().getDocument().addDocumentListener(this.myListener);
                }
            }

            protected void unprocessComponent(Component component) {
                super.unprocessComponent(component);
                if (component instanceof EditorComponentImpl) {
                    ((EditorComponentImpl)component).getEditor().getDocument().removeDocumentListener(this.myListener);
                }
            }
        };
    }

    public void setupErrorOutdatingUserActivityWatcher(final CommittablePanel panel2, final DomElement ... elements) {
        UserActivityWatcher userActivityWatcher = this.createEditorAwareUserActivityWatcher();
        userActivityWatcher.addUserActivityListener(new UserActivityListener(){
            private boolean isProcessingChange;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged() {
                if (this.isProcessingChange) {
                    return;
                }
                this.isProcessingChange = true;
                try {
                    for (DomElement element : elements) {
                        DomElementAnnotationsManagerImpl.outdateProblemHolder(element);
                    }
                    CommittableUtil.updateHighlighting((Committable)panel2);
                }
                finally {
                    this.isProcessingChange = false;
                }
            }
        }, (Disposable)panel2);
        userActivityWatcher.register((Component)panel2.getComponent());
    }

    @Nullable
    public BaseControl createCustomControl(Type type2, DomWrapper<String> wrapper, boolean commitOnEveryChange) {
        Function factory = (Function)this.myCustomControlCreators.get(ReflectionUtil.getRawType((Type)type2));
        return factory == null ? null : (BaseControl)factory.fun(wrapper);
    }

    public CaptionComponent addErrorPanel(CaptionComponent captionComponent, DomElement ... elements) {
        captionComponent.initErrorPanel((CommittablePanel)new DomElementsErrorPanel(elements));
        return captionComponent;
    }

    public BackgroundEditorHighlighter createDomHighlighter(final Project project2, final PerspectiveFileEditor editor, final DomElement element) {
        return new BackgroundEditorHighlighter(){

            @NotNull
            public HighlightingPass[] createPassesForEditor() {
                if (!element.isValid()) {
                    if (HighlightingPass.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/DomUIFactoryImpl$3", "createPassesForEditor"));
                    }
                    return HighlightingPass.EMPTY_ARRAY;
                }
                XmlFile psiFile = DomUtil.getFile((DomElement)element);
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
                Document document = psiDocumentManager.getDocument((PsiFile)psiFile);
                if (document == null) {
                    if (HighlightingPass.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/DomUIFactoryImpl$3", "createPassesForEditor"));
                    }
                    return HighlightingPass.EMPTY_ARRAY;
                }
                editor.commit();
                GeneralHighlightingPass ghp = new GeneralHighlightingPass(project2, (PsiFile)psiFile, document, 0, document.getTextLength(), true, new ProperTextRange(0, document.getTextLength()), null, new DefaultHighlightInfoProcessor());
                LocalInspectionsPass lip = new LocalInspectionsPass((PsiFile)psiFile, document, 0, document.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, new DefaultHighlightInfoProcessor());
                HighlightingPass[] highlightingPassArray = new HighlightingPass[]{ghp, lip};
                if (highlightingPassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/DomUIFactoryImpl$3", "createPassesForEditor"));
                }
                return highlightingPassArray;
            }

            @NotNull
            public HighlightingPass[] createPassesForVisibleArea() {
                HighlightingPass[] highlightingPassArray = this.createPassesForEditor();
                if (highlightingPassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/DomUIFactoryImpl$3", "createPassesForVisibleArea"));
                }
                return highlightingPassArray;
            }
        };
    }

    public BaseControl createTextControl(DomWrapper<String> wrapper, boolean commitOnEveryChange) {
        return new TextControl(wrapper, commitOnEveryChange);
    }

    public void registerCustomControl(@NotNull Class aClass, Function<DomWrapper<String>, BaseControl> creator) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xml/ui/DomUIFactoryImpl", "registerCustomControl"));
        }
        this.myCustomControlCreators.put(aClass, creator);
    }

    public void registerCustomCellEditor(@NotNull Class aClass, Function<DomElement, TableCellEditor> creator) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xml/ui/DomUIFactoryImpl", "registerCustomCellEditor"));
        }
        this.myCustomCellEditorCreators.put(aClass, creator);
    }

    private static <T extends JComponent> T removeBorder(T component) {
        component.setBorder((Border)JBUI.Borders.empty());
        return component;
    }
}

