/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiType;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.AbstractConvertContext;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.JvmPsiTypeConverterImpl;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.EditorTextFieldControl;
import com.intellij.util.xml.ui.PsiClassControl;
import com.intellij.util.xml.ui.PsiTypePanel;
import org.jetbrains.annotations.NotNull;

public class PsiTypeControl
extends EditorTextFieldControl<PsiTypePanel> {
    public PsiTypeControl(DomWrapper<String> domWrapper, boolean commitOnEveryChange) {
        super(domWrapper, commitOnEveryChange);
    }

    @Override
    @NotNull
    protected String getValue() {
        String rawValue;
        block4: {
            String string;
            rawValue = super.getValue();
            try {
                PsiType psiType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeFromText(rawValue, null);
                String s = JvmPsiTypeConverterImpl.convertToString(psiType);
                if (s == null) break block4;
                string = s;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/PsiTypeControl", "getValue"));
            }
            return string;
        }
        String string = rawValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/PsiTypeControl", "getValue"));
        }
        return string;
    }

    @Override
    protected void setValue(String value2) {
        PsiType type2 = JvmPsiTypeConverterImpl.convertFromString(value2, (ConvertContext)new AbstractConvertContext(){

            @NotNull
            public DomElement getInvocationElement() {
                DomElement domElement = PsiTypeControl.this.getDomElement();
                if (domElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/PsiTypeControl$1", "getInvocationElement"));
                }
                return domElement;
            }
        });
        if (type2 != null) {
            value2 = type2.getCanonicalText();
        }
        super.setValue(value2);
    }

    @Override
    protected EditorTextField getEditorTextField(@NotNull PsiTypePanel component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/xml/ui/PsiTypeControl", "getEditorTextField"));
        }
        return ((ReferenceEditorWithBrowseButton)((Object)component.getComponent(0))).getEditorTextField();
    }

    @Override
    protected PsiTypePanel createMainComponent(PsiTypePanel boundedComponent, Project project2) {
        if (boundedComponent == null) {
            boundedComponent = new PsiTypePanel();
        }
        return PsiClassControl.initReferenceEditorWithBrowseButton(boundedComponent, new ReferenceEditorWithBrowseButton(null, project2, (Function<String, Document>)((Function)s -> JavaReferenceEditorUtil.createTypeDocument(s, project2)), ""), this);
    }
}

