/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.longLine.LongLineInspection;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.vcs.commit.ReformatCommitMessageAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCommitMessageInspection
extends LocalInspectionTool {
    public static final String GROUP_NAME = "Commit message";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if (GROUP_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/commit/BaseCommitMessageInspection", "getGroupDisplayName"));
        }
        return GROUP_NAME;
    }

    @Nullable
    public String getStaticDescription() {
        return "";
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/commit/BaseCommitMessageInspection", "isSuppressedFor"));
        }
        return !CommitMessage.isCommitMessage(element);
    }

    @Nullable
    public ConfigurableUi<Project> createOptionsConfigurable() {
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/vcs/commit/BaseCommitMessageInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/commit/BaseCommitMessageInspection", "checkFile"));
        }
        Document document = BaseCommitMessageInspection.getDocument((PsiElement)file2);
        return document != null ? this.checkFile(file2, document, manager, isOnTheFly) : null;
    }

    @Nullable
    protected ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/vcs/commit/BaseCommitMessageInspection", "checkFile"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BaseCommitMessageInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/commit/BaseCommitMessageInspection", "checkFile"));
        }
        return null;
    }

    @Nullable
    protected static ProblemDescriptor checkRightMargin(@NotNull PsiFile file2, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly, int line, int rightMargin, @NotNull String problemText, LocalQuickFix ... fixes) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/vcs/commit/BaseCommitMessageInspection", "checkRightMargin"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BaseCommitMessageInspection", "checkRightMargin"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/commit/BaseCommitMessageInspection", "checkRightMargin"));
        }
        if (problemText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemText", "com/intellij/vcs/commit/BaseCommitMessageInspection", "checkRightMargin"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/vcs/commit/BaseCommitMessageInspection", "checkRightMargin"));
        }
        TextRange exceedingRange = LongLineInspection.getExceedingRange(document, line, rightMargin);
        return !exceedingRange.isEmpty() ? manager.createProblemDescriptor((PsiElement)file2, exceedingRange, problemText, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, fixes) : null;
    }

    public boolean canReformat(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BaseCommitMessageInspection", "canReformat"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BaseCommitMessageInspection", "canReformat"));
        }
        return false;
    }

    public void reformat(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BaseCommitMessageInspection", "reformat"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BaseCommitMessageInspection", "reformat"));
        }
    }

    protected boolean hasProblems(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BaseCommitMessageInspection", "hasProblems"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BaseCommitMessageInspection", "hasProblems"));
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        return file2 != null && !ArrayUtil.isEmpty((Object[])this.checkFile(file2, document, InspectionManager.getInstance((Project)project2), false));
    }

    @Nullable
    private static Document getDocument(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/commit/BaseCommitMessageInspection", "getDocument"));
        }
        return PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
    }

    protected static class ReformatCommitMessageQuickFix
    extends BaseCommitMessageQuickFix
    implements LowPriorityAction,
    IntentionAction,
    ShortcutProvider {
        protected ReformatCommitMessageQuickFix() {
            super("Reformat commit message");
        }

        @Override
        public void doApplyFix(@NotNull Project project2, @NotNull Document document, @Nullable ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BaseCommitMessageInspection$ReformatCommitMessageQuickFix", "doApplyFix"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/vcs/commit/BaseCommitMessageInspection$ReformatCommitMessageQuickFix", "doApplyFix"));
            }
            ReformatCommitMessageAction.reformat(project2, document);
        }

        @Nullable
        public ShortcutSet getShortcut() {
            return KeymapUtil.getActiveKeymapShortcuts((String)"Vcs.ReformatCommitMessage");
        }

        @Nls
        @NotNull
        public String getText() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/commit/BaseCommitMessageInspection$ReformatCommitMessageQuickFix", "getText"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BaseCommitMessageInspection$ReformatCommitMessageQuickFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2) throws IncorrectOperationException {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BaseCommitMessageInspection$ReformatCommitMessageQuickFix", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/vcs/commit/BaseCommitMessageInspection$ReformatCommitMessageQuickFix", "invoke"));
            }
            Document document = BaseCommitMessageInspection.getDocument((PsiElement)file2);
            if (document != null) {
                this.doApplyFix(project2, document, null);
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    protected static abstract class BaseCommitMessageQuickFix
    extends LocalQuickFixBase {
        protected BaseCommitMessageQuickFix(@NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/commit/BaseCommitMessageInspection$BaseCommitMessageQuickFix", "<init>"));
            }
            super(name2);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/commit/BaseCommitMessageInspection$BaseCommitMessageQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/vcs/commit/BaseCommitMessageInspection$BaseCommitMessageQuickFix", "applyFix"));
            }
            Document document = BaseCommitMessageInspection.getDocument(descriptor.getPsiElement());
            if (document != null) {
                this.doApplyFix(project2, document, descriptor);
            }
        }

        public abstract void doApplyFix(@NotNull Project var1, @NotNull Document var2, @Nullable ProblemDescriptor var3);
    }

    public static class EmptyIntentionActionFilter
    implements IntentionActionFilter {
        @Override
        public boolean accept(@NotNull IntentionAction intentionAction, @Nullable PsiFile file2) {
            if (intentionAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/vcs/commit/BaseCommitMessageInspection$EmptyIntentionActionFilter", "accept"));
            }
            return file2 == null || !CommitMessage.isCommitMessage((PsiElement)file2) || !(intentionAction instanceof EmptyIntentionAction);
        }
    }
}

