/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class VcsLogBranchFilterImpl
implements VcsLogBranchFilter {
    private static final Logger LOG = Logger.getInstance(VcsLogBranchFilterImpl.class);
    @NotNull
    private final List<String> myBranches;
    @NotNull
    private final List<Pattern> myPatterns;
    @NotNull
    private final List<String> myExcludedBranches;
    @NotNull
    private final List<Pattern> myExcludedPatterns;

    private VcsLogBranchFilterImpl(@NotNull List<String> branches, @NotNull List<Pattern> patterns, @NotNull List<String> excludedBranches, @NotNull List<Pattern> excludedPatterns) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "<init>"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "<init>"));
        }
        if (excludedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedBranches", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "<init>"));
        }
        if (excludedPatterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedPatterns", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "<init>"));
        }
        this.myBranches = branches;
        this.myPatterns = patterns;
        this.myExcludedBranches = excludedBranches;
        this.myExcludedPatterns = excludedPatterns;
    }

    @Deprecated
    public VcsLogBranchFilterImpl(@NotNull Collection<String> branches, @NotNull Collection<String> excludedBranches) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "<init>"));
        }
        if (excludedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedBranches", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "<init>"));
        }
        this.myBranches = new ArrayList<String>(branches);
        this.myPatterns = new ArrayList<Pattern>();
        this.myExcludedBranches = new ArrayList<String>(excludedBranches);
        this.myExcludedPatterns = new ArrayList<Pattern>();
    }

    @NotNull
    public static VcsLogBranchFilterImpl fromBranch(@NotNull String branchName) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "fromBranch"));
        }
        VcsLogBranchFilterImpl vcsLogBranchFilterImpl = new VcsLogBranchFilterImpl(Collections.singletonList(branchName), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        if (vcsLogBranchFilterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "fromBranch"));
        }
        return vcsLogBranchFilterImpl;
    }

    @NotNull
    public static VcsLogBranchFilterImpl fromTextPresentation(@NotNull Collection<String> strings, @NotNull Set<String> existingBranches) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "fromTextPresentation"));
        }
        if (existingBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingBranches", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "fromTextPresentation"));
        }
        ArrayList<String> branchNames = new ArrayList<String>();
        ArrayList<String> excludedBranches = new ArrayList<String>();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        ArrayList<Pattern> excludedPatterns = new ArrayList<Pattern>();
        for (String string : strings) {
            boolean isRegexp;
            boolean isExcluded = string.startsWith("-");
            string = isExcluded ? string.substring(1) : string;
            boolean bl = isRegexp = !existingBranches.contains(string);
            if (isRegexp) {
                try {
                    Pattern pattern = Pattern.compile(string);
                    if (isExcluded) {
                        excludedPatterns.add(pattern);
                        continue;
                    }
                    patterns.add(pattern);
                }
                catch (PatternSyntaxException e) {
                    LOG.warn("Pattern " + string + " is not a proper regular expression and no branch can be found with that name.", (Throwable)e);
                    if (isExcluded) {
                        excludedBranches.add(string);
                        continue;
                    }
                    branchNames.add(string);
                }
                continue;
            }
            if (isExcluded) {
                excludedBranches.add(string);
                continue;
            }
            branchNames.add(string);
        }
        VcsLogBranchFilterImpl vcsLogBranchFilterImpl = new VcsLogBranchFilterImpl(branchNames, patterns, excludedBranches, excludedPatterns);
        if (vcsLogBranchFilterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "fromTextPresentation"));
        }
        return vcsLogBranchFilterImpl;
    }

    @NotNull
    public Collection<String> getTextPresentation() {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.addAll(this.myBranches);
        result2.addAll(ContainerUtil.map(this.myPatterns, pattern -> pattern.pattern()));
        result2.addAll(ContainerUtil.map(this.myExcludedBranches, branchName -> "-" + branchName));
        result2.addAll(ContainerUtil.map(this.myExcludedPatterns, pattern -> "-" + pattern.pattern()));
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "getTextPresentation"));
        }
        return arrayList;
    }

    public String toString() {
        String result2 = "";
        if (!this.myPatterns.isEmpty()) {
            result2 = result2 + "on patterns: " + StringUtil.join(this.myPatterns, (String)", ");
        }
        if (!this.myBranches.isEmpty()) {
            if (!result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "on branches: " + StringUtil.join(this.myBranches, (String)", ");
        }
        if (!this.myExcludedPatterns.isEmpty()) {
            if (result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "not on patterns: " + StringUtil.join(this.myExcludedPatterns, (String)", ");
        }
        if (!this.myExcludedBranches.isEmpty()) {
            if (result2.isEmpty()) {
                result2 = result2 + "; ";
            }
            result2 = result2 + "not on branches: " + StringUtil.join(this.myExcludedBranches, (String)", ");
        }
        return result2;
    }

    public boolean matches(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "matches"));
        }
        return this.isIncluded(name2) && !this.isExcluded(name2);
    }

    private boolean isIncluded(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "isIncluded"));
        }
        if (this.myPatterns.isEmpty() && this.myBranches.isEmpty()) {
            return true;
        }
        if (this.myBranches.contains(name2)) {
            return true;
        }
        for (Pattern regexp : this.myPatterns) {
            if (!regexp.matcher(name2).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "isExcluded"));
        }
        if (this.myExcludedBranches.contains(name2)) {
            return true;
        }
        for (Pattern regexp : this.myExcludedPatterns) {
            if (!regexp.matcher(name2).matches()) continue;
            return true;
        }
        return false;
    }
}

