/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsRefImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogStorageImpl
implements Disposable,
VcsLogStorage {
    @NotNull
    private static final Logger LOG = Logger.getInstance(VcsLogStorage.class);
    @NotNull
    private static final String HASHES_STORAGE = "hashes";
    @NotNull
    private static final String REFS_STORAGE = "refs";
    @NotNull
    public static final VcsLogStorage EMPTY = new EmptyLogStorage();
    public static final int VERSION = 5;
    public static final int NO_INDEX = -1;
    private static final int REFS_VERSION = 1;
    @NotNull
    private final PersistentEnumeratorBase<CommitId> myCommitIdEnumerator;
    @NotNull
    private final PersistentEnumeratorBase<VcsRef> myRefsEnumerator;
    @NotNull
    private final FatalErrorHandler myExceptionReporter;
    private volatile boolean myDisposed;

    public VcsLogStorageImpl(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull FatalErrorHandler exceptionReporter, @NotNull Disposable parent) throws IOException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogStorageImpl", "<init>"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/VcsLogStorageImpl", "<init>"));
        }
        if (exceptionReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionReporter", "com/intellij/vcs/log/data/VcsLogStorageImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/vcs/log/data/VcsLogStorageImpl", "<init>"));
        }
        this.myDisposed = false;
        this.myExceptionReporter = exceptionReporter;
        List roots = ((StreamEx)StreamEx.ofKeys(logProviders).sortedBy(VirtualFile::getPath)).toList();
        String logId = PersistentUtil.calcLogId(project2, logProviders);
        MyCommitIdKeyDescriptor commitIdKeyDescriptor = new MyCommitIdKeyDescriptor(roots);
        this.myCommitIdEnumerator = PersistentUtil.createPersistentEnumerator(commitIdKeyDescriptor, HASHES_STORAGE, logId, 5);
        this.myRefsEnumerator = PersistentUtil.createPersistentEnumerator(new VcsRefKeyDescriptor(logProviders, commitIdKeyDescriptor), REFS_STORAGE, logId, 6);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    public static Function<Integer, Hash> createHashGetter(@NotNull VcsLogStorage storage2) {
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/VcsLogStorageImpl", "createHashGetter"));
        }
        Function function = commitIndex -> {
            if (storage2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/VcsLogStorageImpl", "lambda$createHashGetter$0"));
            }
            CommitId commitId = storage2.getCommitId((int)commitIndex);
            if (commitId == null) {
                return null;
            }
            return commitId.getHash();
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogStorageImpl", "createHashGetter"));
        }
        return function;
    }

    @Nullable
    private CommitId doGetCommitId(int index) throws IOException {
        return (CommitId)this.myCommitIdEnumerator.valueOf(index);
    }

    private int getOrPut(@NotNull Hash hash, @NotNull VirtualFile root) throws IOException {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogStorageImpl", "getOrPut"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogStorageImpl", "getOrPut"));
        }
        return this.myCommitIdEnumerator.enumerate((Object)new CommitId(hash, root));
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogStorageImpl", "getCommitIndex"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogStorageImpl", "getCommitIndex"));
        }
        this.checkDisposed();
        try {
            return this.getOrPut(hash, root);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return -1;
        }
    }

    @Override
    @Nullable
    public CommitId getCommitId(int commitIndex) {
        this.checkDisposed();
        try {
            CommitId commitId = this.doGetCommitId(commitIndex);
            if (commitId == null) {
                this.myExceptionReporter.consume(this, new RuntimeException("Unknown commit index: " + commitIndex));
            }
            return commitId;
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return null;
        }
    }

    @Override
    @Nullable
    public CommitId findCommitId(final @NotNull Condition<CommitId> condition2) {
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/VcsLogStorageImpl", "findCommitId"));
        }
        this.checkDisposed();
        try {
            final Ref hashRef = Ref.create();
            this.myCommitIdEnumerator.iterateData((Processor)new CommonProcessors.FindProcessor<CommitId>(){

                protected boolean accept(CommitId commitId) {
                    boolean matches = condition2.value((Object)commitId);
                    if (matches) {
                        hashRef.set((Object)commitId);
                    }
                    return matches;
                }
            });
            return (CommitId)hashRef.get();
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return null;
        }
    }

    @Override
    public int getRefIndex(@NotNull VcsRef ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/data/VcsLogStorageImpl", "getRefIndex"));
        }
        this.checkDisposed();
        try {
            return this.myRefsEnumerator.enumerate((Object)ref);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return -1;
        }
    }

    @Override
    @Nullable
    public VcsRef getVcsRef(int refIndex) {
        this.checkDisposed();
        try {
            return (VcsRef)this.myRefsEnumerator.valueOf(refIndex);
        }
        catch (IOException e) {
            this.myExceptionReporter.consume(this, e);
            return null;
        }
    }

    @Override
    public void flush() {
        this.checkDisposed();
        this.myCommitIdEnumerator.force();
        this.myRefsEnumerator.force();
    }

    public void dispose() {
        try {
            this.myDisposed = true;
            this.myCommitIdEnumerator.close();
            this.myRefsEnumerator.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            throw new ProcessCanceledException();
        }
    }

    private static class VcsRefKeyDescriptor
    implements KeyDescriptor<VcsRef> {
        @NotNull
        private final Map<VirtualFile, VcsLogProvider> myLogProviders;
        @NotNull
        private final KeyDescriptor<CommitId> myCommitIdKeyDescriptor;

        public VcsRefKeyDescriptor(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull KeyDescriptor<CommitId> commitIdKeyDescriptor) {
            if (logProviders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor", "<init>"));
            }
            if (commitIdKeyDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIdKeyDescriptor", "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor", "<init>"));
            }
            this.myLogProviders = logProviders;
            this.myCommitIdKeyDescriptor = commitIdKeyDescriptor;
        }

        public int getHashCode(@NotNull VcsRef value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor", "getHashCode"));
            }
            return value2.hashCode();
        }

        public boolean isEqual(@NotNull VcsRef val1, @NotNull VcsRef val2) {
            if (val1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val1", "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor", "isEqual"));
            }
            if (val2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val2", "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor", "isEqual"));
            }
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, @NotNull VcsRef value2) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor", "save"));
            }
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor", "save"));
            }
            this.myCommitIdKeyDescriptor.save(out, (Object)new CommitId(value2.getCommitHash(), value2.getRoot()));
            IOUtil.writeUTF((DataOutput)out, (String)value2.getName());
            this.myLogProviders.get(value2.getRoot()).getReferenceManager().serialize(out, value2.getType());
        }

        public VcsRef read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor", "read"));
            }
            CommitId commitId = (CommitId)this.myCommitIdKeyDescriptor.read(in);
            if (commitId == null) {
                throw new IOException("Can not read commit id for reference");
            }
            String name2 = IOUtil.readUTF((DataInput)in);
            VcsRefType type2 = this.myLogProviders.get(commitId.getRoot()).getReferenceManager().deserialize(in);
            return new VcsRefImpl(commitId.getHash(), name2, type2, commitId.getRoot());
        }
    }

    private static class EmptyLogStorage
    implements VcsLogStorage {
        private EmptyLogStorage() {
        }

        @Override
        public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
            if (hash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogStorageImpl$EmptyLogStorage", "getCommitIndex"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogStorageImpl$EmptyLogStorage", "getCommitIndex"));
            }
            return 0;
        }

        @Override
        @NotNull
        public CommitId getCommitId(int commitIndex) {
            throw new UnsupportedOperationException("Illegal access to empty hash map by index " + commitIndex);
        }

        @Override
        @Nullable
        public CommitId findCommitId(@NotNull Condition<CommitId> string) {
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/vcs/log/data/VcsLogStorageImpl$EmptyLogStorage", "findCommitId"));
            }
            return null;
        }

        @Override
        public int getRefIndex(@NotNull VcsRef ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/data/VcsLogStorageImpl$EmptyLogStorage", "getRefIndex"));
            }
            return 0;
        }

        @Override
        @Nullable
        public VcsRef getVcsRef(int refIndex) {
            throw new UnsupportedOperationException("Illegal access to empty ref map by index " + refIndex);
        }

        @Override
        public void flush() {
        }
    }

    private static class MyCommitIdKeyDescriptor
    implements KeyDescriptor<CommitId> {
        @NotNull
        private final List<VirtualFile> myRoots;
        @NotNull
        private final TObjectIntHashMap<VirtualFile> myRootsReversed;

        public MyCommitIdKeyDescriptor(@NotNull List<VirtualFile> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogStorageImpl$MyCommitIdKeyDescriptor", "<init>"));
            }
            this.myRoots = roots;
            this.myRootsReversed = new TObjectIntHashMap();
            for (int i2 = 0; i2 < roots.size(); ++i2) {
                this.myRootsReversed.put((Object)roots.get(i2), i2);
            }
        }

        public void save(@NotNull DataOutput out, CommitId value2) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/VcsLogStorageImpl$MyCommitIdKeyDescriptor", "save"));
            }
            ((HashImpl)value2.getHash()).write(out);
            out.writeInt(this.myRootsReversed.get((Object)value2.getRoot()));
        }

        public CommitId read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/VcsLogStorageImpl$MyCommitIdKeyDescriptor", "read"));
            }
            Hash hash = HashImpl.read(in);
            VirtualFile root = this.myRoots.get(in.readInt());
            if (root == null) {
                return null;
            }
            return new CommitId(hash, root);
        }

        public int getHashCode(CommitId value2) {
            return value2.hashCode();
        }

        public boolean isEqual(CommitId val1, CommitId val2) {
            return val1.equals((Object)val2);
        }
    }
}

