/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexDataGetter {
    private static final Logger LOG = Logger.getInstance(IndexDataGetter.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final VcsLogPersistentIndex.IndexStorage myIndexStorage;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;

    public IndexDataGetter(@NotNull Project project2, @NotNull Set<VirtualFile> roots, @NotNull VcsLogPersistentIndex.IndexStorage storage2, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/index/IndexDataGetter", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/index/IndexDataGetter", "<init>"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/index/IndexDataGetter", "<init>"));
        }
        if (fatalErrorsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorsConsumer", "com/intellij/vcs/log/data/index/IndexDataGetter", "<init>"));
        }
        this.myProject = project2;
        this.myRoots = roots;
        this.myIndexStorage = storage2;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
    }

    @Nullable
    public String getFullMessage(int index) {
        try {
            return (String)this.myIndexStorage.messages.get((Object)index);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return null;
        }
    }

    @NotNull
    public Set<FilePath> getFileNames(@NotNull FilePath path, int commit) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/data/index/IndexDataGetter", "getFileNames"));
        }
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        if (this.myRoots.contains(root)) {
            Set<FilePath> set2;
            try {
                set2 = this.myIndexStorage.paths.getFileNames(path, commit);
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, (Exception)e);
            }
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/IndexDataGetter", "getFileNames"));
            }
            return set2;
        }
        Set<FilePath> set3 = Collections.emptySet();
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/IndexDataGetter", "getFileNames"));
        }
        return set3;
    }

    @NotNull
    public FileNamesData buildFileNamesData(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/data/index/IndexDataGetter", "buildFileNamesData"));
        }
        FileNamesData result2 = new FileNamesData();
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        if (this.myRoots.contains(root)) {
            try {
                this.myIndexStorage.paths.iterateCommits(path, (changes, commit) -> {
                    try {
                        List parents = (List)this.myIndexStorage.parents.get((Object)commit);
                        result2.add(commit, (FilePath)changes.first, (List)changes.second, parents);
                    }
                    catch (IOException e) {
                        this.myFatalErrorsConsumer.consume(this, e);
                    }
                });
            }
            catch (StorageException | IOException e) {
                this.myFatalErrorsConsumer.consume(this, (Exception)e);
            }
        }
        FileNamesData fileNamesData = result2;
        if (fileNamesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/IndexDataGetter", "buildFileNamesData"));
        }
        return fileNamesData;
    }

    public class FileNamesData {
        @NotNull
        private final TIntObjectHashMap<Map<FilePath, Map<Integer, VcsLogPathsIndex.ChangeData>>> myCommitToPathAndChanges = new TIntObjectHashMap();
        private boolean myHasRenames = false;

        public boolean hasRenames() {
            return this.myHasRenames;
        }

        public void add(int commit, @NotNull FilePath path, @NotNull List<VcsLogPathsIndex.ChangeData> changes, @NotNull List<Integer> parents) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData", "add"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData", "add"));
            }
            if (parents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData", "add"));
            }
            Map pathToChanges = (Map)this.myCommitToPathAndChanges.get(commit);
            if (pathToChanges == null) {
                pathToChanges = ContainerUtil.newHashMap();
                this.myCommitToPathAndChanges.put(commit, (Object)pathToChanges);
            }
            if (!this.myHasRenames) {
                for (VcsLogPathsIndex.ChangeData data : changes) {
                    if (data == null || !data.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_FROM) && !data.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_TO)) continue;
                    this.myHasRenames = true;
                    break;
                }
            }
            HashMap parentToChangesMap = ContainerUtil.newHashMap();
            if (!parents.isEmpty()) {
                LOG.assertTrue(parents.size() == changes.size());
                for (int i2 = 0; i2 < changes.size(); ++i2) {
                    parentToChangesMap.put(parents.get(i2), changes.get(i2));
                }
            } else {
                LOG.assertTrue(changes.size() == 1);
                parentToChangesMap.put(-1, changes.get(0));
            }
            pathToChanges.put(path, parentToChangesMap);
        }

        @Nullable
        public FilePath getPathInParentRevision(int commit, int parent, @NotNull FilePath childPath) {
            if (childPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childPath", "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData", "getPathInParentRevision"));
            }
            Map filesToChangesMap = (Map)this.myCommitToPathAndChanges.get(commit);
            LOG.assertTrue(filesToChangesMap != null, (Object)("Missing commit " + commit));
            Map changes = (Map)filesToChangesMap.get(childPath);
            if (changes == null) {
                return childPath;
            }
            VcsLogPathsIndex.ChangeData change = (VcsLogPathsIndex.ChangeData)changes.get(parent);
            if (change == null) {
                LOG.assertTrue(changes.size() > 1);
                return childPath;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_FROM)) {
                return null;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_TO)) {
                return VcsUtil.getFilePath((String)((IndexDataGetter)IndexDataGetter.this).myIndexStorage.paths.getPath(change.otherPath));
            }
            return childPath;
        }

        @Nullable
        public FilePath getPathInChildRevision(int commit, int parentIndex, @NotNull FilePath parentPath) {
            if (parentPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData", "getPathInChildRevision"));
            }
            Map filesToChangesMap = (Map)this.myCommitToPathAndChanges.get(commit);
            LOG.assertTrue(filesToChangesMap != null, (Object)("Missing commit " + commit));
            Map changes = (Map)filesToChangesMap.get(parentPath);
            if (changes == null) {
                return parentPath;
            }
            VcsLogPathsIndex.ChangeData change = (VcsLogPathsIndex.ChangeData)changes.get(parentIndex);
            if (change == null) {
                return parentPath;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_TO)) {
                return null;
            }
            if (change.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_FROM)) {
                return VcsUtil.getFilePath((String)((IndexDataGetter)IndexDataGetter.this).myIndexStorage.paths.getPath(change.otherPath));
            }
            return parentPath;
        }

        public boolean affects(int id, @NotNull FilePath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData", "affects"));
            }
            return this.myCommitToPathAndChanges.containsKey(id) && ((Map)this.myCommitToPathAndChanges.get(id)).containsKey(path);
        }

        @NotNull
        public Set<Integer> getCommits() {
            HashSet result2 = ContainerUtil.newHashSet();
            this.myCommitToPathAndChanges.forEach(result2::add);
            HashSet hashSet = result2;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData", "getCommits"));
            }
            return hashSet;
        }

        @NotNull
        public Map<Integer, FilePath> buildPathsMap() {
            HashMap result2 = ContainerUtil.newHashMap();
            this.myCommitToPathAndChanges.forEachEntry((commit, filesToChanges) -> {
                if (filesToChanges.size() == 1) {
                    result2.put(commit, ContainerUtil.getFirstItem(filesToChanges.keySet()));
                } else {
                    for (Map.Entry fileToChange : filesToChanges.entrySet()) {
                        VcsLogPathsIndex.ChangeData changeData = (VcsLogPathsIndex.ChangeData)ContainerUtil.find(((Map)fileToChange.getValue()).values(), ch -> ch != null && !ch.kind.equals((Object)VcsLogPathsIndex.ChangeKind.RENAMED_FROM));
                        if (changeData == null) continue;
                        result2.put(commit, fileToChange.getKey());
                        break;
                    }
                }
                return true;
            });
            HashMap hashMap = result2;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData", "buildPathsMap"));
            }
            return hashMap;
        }

        public boolean isTrivialMerge(int commit, @NotNull FilePath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/data/index/IndexDataGetter$FileNamesData", "isTrivialMerge"));
            }
            if (!this.myCommitToPathAndChanges.containsKey(commit)) {
                return false;
            }
            Map data = (Map)((Map)this.myCommitToPathAndChanges.get(commit)).get(path);
            return data != null && data.size() > 1 && data.containsValue(null);
        }
    }
}

