/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.api.elements;

import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphEdge
implements GraphElement {
    @Nullable
    private final Integer myUpNodeIndex;
    @Nullable
    private final Integer myDownNodeIndex;
    @Nullable
    private final Integer myTargetId;
    @NotNull
    private final GraphEdgeType myType;

    public static GraphEdge createNormalEdge(int nodeIndex1, int nodeIndex2, @NotNull GraphEdgeType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/api/elements/GraphEdge", "createNormalEdge"));
        }
        assert (type2.isNormalEdge()) : "Unexpected edge type: " + (Object)((Object)type2);
        return new GraphEdge(Math.min(nodeIndex1, nodeIndex2), Math.max(nodeIndex1, nodeIndex2), null, type2);
    }

    public static GraphEdge createEdgeWithTargetId(int nodeIndex, @Nullable Integer targetId, @NotNull GraphEdgeType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/api/elements/GraphEdge", "createEdgeWithTargetId"));
        }
        switch (type2) {
            case DOTTED_ARROW_UP: {
                return new GraphEdge(null, nodeIndex, targetId, type2);
            }
            case NOT_LOAD_COMMIT: 
            case DOTTED_ARROW_DOWN: {
                return new GraphEdge(nodeIndex, null, targetId, type2);
            }
        }
        throw new AssertionError((Object)("Unexpected edge type: " + (Object)((Object)type2)));
    }

    public GraphEdge(@Nullable Integer upNodeIndex, @Nullable Integer downNodeIndex, @Nullable Integer targetId, @NotNull GraphEdgeType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/api/elements/GraphEdge", "<init>"));
        }
        this.myUpNodeIndex = upNodeIndex;
        this.myDownNodeIndex = downNodeIndex;
        this.myTargetId = targetId;
        this.myType = type2;
    }

    @Nullable
    public Integer getUpNodeIndex() {
        return this.myUpNodeIndex;
    }

    @Nullable
    public Integer getDownNodeIndex() {
        return this.myDownNodeIndex;
    }

    @Nullable
    public Integer getTargetId() {
        return this.myTargetId;
    }

    @NotNull
    public GraphEdgeType getType() {
        GraphEdgeType graphEdgeType = this.myType;
        if (graphEdgeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/api/elements/GraphEdge", "getType"));
        }
        return graphEdgeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphEdge graphEdge = (GraphEdge)o;
        if (this.myType != graphEdge.myType) {
            return false;
        }
        if (this.myUpNodeIndex != null ? !this.myUpNodeIndex.equals(graphEdge.myUpNodeIndex) : graphEdge.myUpNodeIndex != null) {
            return false;
        }
        if (this.myDownNodeIndex != null ? !this.myDownNodeIndex.equals(graphEdge.myDownNodeIndex) : graphEdge.myDownNodeIndex != null) {
            return false;
        }
        return !(this.myTargetId != null ? !this.myTargetId.equals(graphEdge.myTargetId) : graphEdge.myTargetId != null);
    }

    public int hashCode() {
        int result2 = this.myUpNodeIndex != null ? this.myUpNodeIndex.hashCode() : 0;
        result2 = 31 * result2 + (this.myDownNodeIndex != null ? this.myDownNodeIndex.hashCode() : 0);
        result2 = 31 * result2 + (this.myTargetId != null ? this.myTargetId.hashCode() : 0);
        result2 = 31 * result2 + this.myType.hashCode();
        return result2;
    }
}

