/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import org.jetbrains.annotations.NotNull;

class GraphNodesVisibility {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private UnsignedBitSet myNodeVisibilityById;

    GraphNodesVisibility(@NotNull LinearGraph linearGraph, @NotNull UnsignedBitSet nodeVisibilityById) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/collapsing/GraphNodesVisibility", "<init>"));
        }
        if (nodeVisibilityById == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeVisibilityById", "com/intellij/vcs/log/graph/collapsing/GraphNodesVisibility", "<init>"));
        }
        this.myLinearGraph = linearGraph;
        this.myNodeVisibilityById = nodeVisibilityById;
    }

    @NotNull
    UnsignedBitSet getNodeVisibilityById() {
        UnsignedBitSet unsignedBitSet = this.myNodeVisibilityById;
        if (unsignedBitSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/collapsing/GraphNodesVisibility", "getNodeVisibilityById"));
        }
        return unsignedBitSet;
    }

    void setNodeVisibilityById(@NotNull UnsignedBitSet nodeVisibilityById) {
        if (nodeVisibilityById == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeVisibilityById", "com/intellij/vcs/log/graph/collapsing/GraphNodesVisibility", "setNodeVisibilityById"));
        }
        this.myNodeVisibilityById = nodeVisibilityById;
    }

    boolean isVisible(int nodeIndex) {
        return this.myNodeVisibilityById.get(this.nodeId(nodeIndex));
    }

    void show(int nodeIndex) {
        this.myNodeVisibilityById.set(this.nodeId(nodeIndex), true);
    }

    void hide(int nodeIndex) {
        this.myNodeVisibilityById.set(this.nodeId(nodeIndex), false);
    }

    Flags asFlags() {
        return new Flags(){

            @Override
            public int size() {
                return GraphNodesVisibility.this.myLinearGraph.nodesCount();
            }

            @Override
            public boolean get(int index) {
                return GraphNodesVisibility.this.myNodeVisibilityById.get(GraphNodesVisibility.this.nodeId(index));
            }

            @Override
            public void set(int index, boolean value2) {
                GraphNodesVisibility.this.myNodeVisibilityById.set(GraphNodesVisibility.this.nodeId(index), value2);
            }

            @Override
            public void setAll(boolean value2) {
                for (int index = 0; index < this.size(); ++index) {
                    this.set(index, value2);
                }
            }
        };
    }

    private int nodeId(int nodeIndex) {
        return this.myLinearGraph.getNodeId(nodeIndex);
    }
}

