/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.elements.GraphNodeType;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.bek.BekChecker;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BekBaseController
extends CascadeController {
    @NotNull
    private final BekIntMap myBekIntMap;
    @NotNull
    private final LinearGraph myBekGraph;

    public BekBaseController(@NotNull PermanentGraphInfo permanentGraphInfo, @NotNull BekIntMap bekIntMap) {
        if (permanentGraphInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphInfo", "com/intellij/vcs/log/graph/impl/facade/BekBaseController", "<init>"));
        }
        if (bekIntMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bekIntMap", "com/intellij/vcs/log/graph/impl/facade/BekBaseController", "<init>"));
        }
        super(null, permanentGraphInfo);
        this.myBekIntMap = bekIntMap;
        this.myBekGraph = new BekLinearGraph(this.myBekIntMap, this.myPermanentGraphInfo.getLinearGraph());
        BekChecker.checkLinearGraph(this.myBekGraph);
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        if (delegateAnswer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateAnswer", "com/intellij/vcs/log/graph/impl/facade/BekBaseController", "delegateGraphChanged"));
        }
        throw new IllegalStateException();
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/graph/impl/facade/BekBaseController", "performAction"));
        }
        return null;
    }

    @NotNull
    public BekIntMap getBekIntMap() {
        BekIntMap bekIntMap = this.myBekIntMap;
        if (bekIntMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/BekBaseController", "getBekIntMap"));
        }
        return bekIntMap;
    }

    @Override
    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/impl/facade/BekBaseController", "convertToDelegate"));
        }
        if (graphElement instanceof GraphEdge) {
            Integer upIndex = ((GraphEdge)graphElement).getUpNodeIndex();
            Integer downIndex = ((GraphEdge)graphElement).getDownNodeIndex();
            Integer convertedUpIndex = upIndex == null ? null : Integer.valueOf(this.myBekIntMap.getUsualIndex(upIndex));
            Integer convertedDownIndex = downIndex == null ? null : Integer.valueOf(this.myBekIntMap.getUsualIndex(downIndex));
            return new GraphEdge(convertedUpIndex, convertedDownIndex, ((GraphEdge)graphElement).getTargetId(), ((GraphEdge)graphElement).getType());
        }
        if (graphElement instanceof GraphNode) {
            return new GraphNode(this.myBekIntMap.getUsualIndex(((GraphNode)graphElement).getNodeIndex()), ((GraphNode)graphElement).getType());
        }
        return null;
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        LinearGraph linearGraph = this.myBekGraph;
        if (linearGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/BekBaseController", "getCompiledGraph"));
        }
        return linearGraph;
    }

    public static class BekLinearGraph
    implements LinearGraph {
        @NotNull
        private final LinearGraph myLinearGraph;
        @NotNull
        private final BekIntMap myBekIntMap;

        public BekLinearGraph(@NotNull BekIntMap bekIntMap, @NotNull LinearGraph linearGraph) {
            if (bekIntMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bekIntMap", "com/intellij/vcs/log/graph/impl/facade/BekBaseController$BekLinearGraph", "<init>"));
            }
            if (linearGraph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/facade/BekBaseController$BekLinearGraph", "<init>"));
            }
            this.myLinearGraph = linearGraph;
            this.myBekIntMap = bekIntMap;
        }

        @Override
        public int nodesCount() {
            return this.myLinearGraph.nodesCount();
        }

        @Nullable
        private Integer getNodeIndex(@Nullable Integer nodeId) {
            if (nodeId == null) {
                return null;
            }
            return this.myBekIntMap.getBekIndex(nodeId);
        }

        @Override
        @NotNull
        public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/graph/impl/facade/BekBaseController$BekLinearGraph", "getAdjacentEdges"));
            }
            List list2 = ContainerUtil.map(this.myLinearGraph.getAdjacentEdges(this.myBekIntMap.getUsualIndex(nodeIndex), filter), edge -> new GraphEdge(this.getNodeIndex(edge.getUpNodeIndex()), this.getNodeIndex(edge.getDownNodeIndex()), edge.getTargetId(), edge.getType()));
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/BekBaseController$BekLinearGraph", "getAdjacentEdges"));
            }
            return list2;
        }

        @Override
        @NotNull
        public GraphNode getGraphNode(int nodeIndex) {
            assert (this.inRanges(nodeIndex));
            GraphNode graphNode = new GraphNode(nodeIndex, GraphNodeType.USUAL);
            if (graphNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/BekBaseController$BekLinearGraph", "getGraphNode"));
            }
            return graphNode;
        }

        @Override
        public int getNodeId(int nodeIndex) {
            return this.myBekIntMap.getUsualIndex(nodeIndex);
        }

        @Override
        @Nullable
        public Integer getNodeIndex(int nodeId) {
            if (!this.inRanges(nodeId)) {
                return null;
            }
            return this.myBekIntMap.getBekIndex(nodeId);
        }

        private boolean inRanges(int index) {
            return index >= 0 && index < this.nodesCount();
        }
    }
}

