/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.BranchFilterController;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.BekBaseController;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.FilteredController;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutBuilder;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.linearBek.LinearBekController;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentGraphImpl<CommitId>
implements PermanentGraph<CommitId>,
PermanentGraphInfo<CommitId> {
    @NotNull
    private final PermanentCommitsInfoImpl<CommitId> myPermanentCommitsInfo;
    @NotNull
    private final PermanentLinearGraphImpl myPermanentLinearGraph;
    @NotNull
    private final GraphLayoutImpl myPermanentGraphLayout;
    @NotNull
    private final GraphColorManager<CommitId> myGraphColorManager;
    @NotNull
    private final Set<Integer> myBranchNodeIds;
    @NotNull
    private final ReachableNodes myReachableNodes;
    @NotNull
    private final Supplier<BekIntMap> myBekIntMap;

    @NotNull
    public static <CommitId> PermanentGraphImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<CommitId> branchesCommitId) {
        if (graphCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphCommits", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        if (graphColorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphColorManager", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        if (branchesCommitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchesCommitId", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        PermanentLinearGraphBuilder permanentLinearGraphBuilder = PermanentLinearGraphBuilder.newInstance(graphCommits);
        NotLoadedCommitsIdsGenerator idsGenerator = new NotLoadedCommitsIdsGenerator();
        PermanentLinearGraphImpl linearGraph = permanentLinearGraphBuilder.build(idsGenerator);
        PermanentCommitsInfoImpl commitIdPermanentCommitsInfo = PermanentCommitsInfoImpl.newInstance(graphCommits, idsGenerator.getNotLoadedCommits());
        GraphLayoutImpl permanentGraphLayout = GraphLayoutBuilder.build(linearGraph, (nodeIndex1, nodeIndex2) -> {
            if (graphColorManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphColorManager", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "lambda$newInstance$0"));
            }
            Object commitId1 = commitIdPermanentCommitsInfo.getCommitId((int)nodeIndex1);
            Object commitId2 = commitIdPermanentCommitsInfo.getCommitId((int)nodeIndex2);
            return graphColorManager.compareHeads(commitId2, commitId1);
        });
        PermanentGraphImpl permanentGraphImpl = new PermanentGraphImpl(linearGraph, permanentGraphLayout, commitIdPermanentCommitsInfo, graphColorManager, branchesCommitId);
        if (permanentGraphImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        return permanentGraphImpl;
    }

    public PermanentGraphImpl(@NotNull PermanentLinearGraphImpl permanentLinearGraph, @NotNull GraphLayoutImpl permanentGraphLayout, @NotNull PermanentCommitsInfoImpl<CommitId> permanentCommitsInfo, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<CommitId> branchesCommitId) {
        if (permanentLinearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentLinearGraph", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (permanentGraphLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphLayout", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (permanentCommitsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentCommitsInfo", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (graphColorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphColorManager", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (branchesCommitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchesCommitId", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        this.myPermanentGraphLayout = permanentGraphLayout;
        this.myPermanentCommitsInfo = permanentCommitsInfo;
        this.myPermanentLinearGraph = permanentLinearGraph;
        this.myGraphColorManager = graphColorManager;
        this.myBranchNodeIds = permanentCommitsInfo.convertToNodeIds(branchesCommitId);
        this.myReachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentLinearGraph));
        this.myBekIntMap = Suppliers.memoize(() -> BekSorter.createBekMap(this.myPermanentLinearGraph, this.myPermanentGraphLayout, this.myPermanentCommitsInfo.getTimestampGetter()));
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<CommitId> visibleHeads, @Nullable Set<CommitId> matchingCommits) {
        CascadeController controller;
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "createVisibleGraph"));
        }
        CascadeController baseController = sortType == PermanentGraph.SortType.Normal ? new BaseController(this) : (sortType == PermanentGraph.SortType.LinearBek ? new LinearBekController(new BekBaseController(this, (BekIntMap)this.myBekIntMap.get()), (PermanentGraphInfo)this) : new BekBaseController(this, (BekIntMap)this.myBekIntMap.get()));
        if (matchingCommits != null) {
            controller = new FilteredController(baseController, this, this.myPermanentCommitsInfo.convertToNodeIds(matchingCommits));
            if (visibleHeads != null) {
                controller = new BranchFilterController(controller, this, this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads, true));
            }
        } else if (sortType == PermanentGraph.SortType.LinearBek) {
            controller = visibleHeads != null ? new BranchFilterController(baseController, this, this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads, true)) : baseController;
        } else {
            Set<Integer> idOfVisibleBranches = null;
            if (visibleHeads != null) {
                idOfVisibleBranches = this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads, true);
            }
            controller = new CollapsedController(baseController, this, idOfVisibleBranches);
        }
        VisibleGraphImpl<CommitId> visibleGraphImpl = new VisibleGraphImpl<CommitId>(controller, this, this.myGraphColorManager);
        if (visibleGraphImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "createVisibleGraph"));
        }
        return visibleGraphImpl;
    }

    @NotNull
    public List<GraphCommit<CommitId>> getAllCommits() {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (int index = 0; index < this.myPermanentLinearGraph.nodesCount(); ++index) {
            CommitId commitId = this.myPermanentCommitsInfo.getCommitId(index);
            List<Integer> downNodes = LinearGraphUtils.getDownNodesIncludeNotLoad(this.myPermanentLinearGraph, index);
            List<CommitId> parentsCommitIds = this.myPermanentCommitsInfo.convertToCommitIdList(downNodes);
            GraphCommit<CommitId> graphCommit = GraphCommitImpl.createCommit(commitId, parentsCommitIds, this.myPermanentCommitsInfo.getTimestamp(index));
            result2.add(graphCommit);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getAllCommits"));
        }
        return arrayList;
    }

    @NotNull
    public List<CommitId> getChildren(@NotNull CommitId commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getChildren"));
        }
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit);
        List<CommitId> list2 = this.myPermanentCommitsInfo.convertToCommitIdList(LinearGraphUtils.getUpNodes(this.myPermanentLinearGraph, commitIndex));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getChildren"));
        }
        return list2;
    }

    @NotNull
    public Set<CommitId> getContainingBranches(@NotNull CommitId commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainingBranches"));
        }
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit);
        Set<CommitId> set2 = this.myPermanentCommitsInfo.convertToCommitIdSet(this.myReachableNodes.getContainingBranches(commitIndex, this.myBranchNodeIds));
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainingBranches"));
        }
        return set2;
    }

    @NotNull
    public Condition<CommitId> getContainedInBranchCondition(@NotNull Collection<CommitId> heads) {
        if (heads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainedInBranchCondition"));
        }
        List headIds = ContainerUtil.map(heads, head -> this.myPermanentCommitsInfo.getNodeId(head));
        if (!heads.isEmpty() && ContainerUtil.getFirstItem(heads) instanceof Integer) {
            TIntHashSet branchNodes = new TIntHashSet();
            this.myReachableNodes.walk(headIds, (Consumer<Integer>)((Consumer)node -> branchNodes.add(((Integer)this.myPermanentCommitsInfo.getCommitId((int)node)).intValue())));
            IntContainedInBranchCondition intContainedInBranchCondition = new IntContainedInBranchCondition(branchNodes);
            if (intContainedInBranchCondition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainedInBranchCondition"));
            }
            return intContainedInBranchCondition;
        }
        HashSet branchNodes = ContainerUtil.newHashSet();
        this.myReachableNodes.walk(headIds, (Consumer<Integer>)((Consumer)node -> branchNodes.add(this.myPermanentCommitsInfo.getCommitId((int)node))));
        ContainedInBranchCondition containedInBranchCondition = new ContainedInBranchCondition(branchNodes);
        if (containedInBranchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainedInBranchCondition"));
        }
        return containedInBranchCondition;
    }

    @Override
    @NotNull
    public PermanentCommitsInfoImpl<CommitId> getPermanentCommitsInfo() {
        PermanentCommitsInfoImpl<CommitId> permanentCommitsInfoImpl = this.myPermanentCommitsInfo;
        if (permanentCommitsInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getPermanentCommitsInfo"));
        }
        return permanentCommitsInfoImpl;
    }

    @Override
    @NotNull
    public PermanentLinearGraphImpl getLinearGraph() {
        PermanentLinearGraphImpl permanentLinearGraphImpl = this.myPermanentLinearGraph;
        if (permanentLinearGraphImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getLinearGraph"));
        }
        return permanentLinearGraphImpl;
    }

    @Override
    @NotNull
    public GraphLayoutImpl getPermanentGraphLayout() {
        GraphLayoutImpl graphLayoutImpl = this.myPermanentGraphLayout;
        if (graphLayoutImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getPermanentGraphLayout"));
        }
        return graphLayoutImpl;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        Set<Integer> set2 = this.myBranchNodeIds;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getBranchNodeIds"));
        }
        return set2;
    }

    private static class ContainedInBranchCondition<CommitId>
    implements Condition<CommitId> {
        private final Set<CommitId> myBranchNodes;

        public ContainedInBranchCondition(Set<CommitId> branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        public boolean value(CommitId commitId) {
            return this.myBranchNodes.contains(commitId);
        }
    }

    private static class IntContainedInBranchCondition<CommitId>
    implements Condition<CommitId> {
        private final TIntHashSet myBranchNodes;

        public IntContainedInBranchCondition(TIntHashSet branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        public boolean value(CommitId commitId) {
            return this.myBranchNodes.contains(((Integer)commitId).intValue());
        }
    }

    private static class NotLoadedCommitsIdsGenerator<CommitId>
    implements NotNullFunction<CommitId, Integer> {
        @NotNull
        private final Map<Integer, CommitId> myNotLoadedCommits = ContainerUtil.newHashMap();

        private NotLoadedCommitsIdsGenerator() {
        }

        @NotNull
        public Integer fun(CommitId dom) {
            int nodeId = -(this.myNotLoadedCommits.size() + 2);
            this.myNotLoadedCommits.put(nodeId, dom);
            Integer n = nodeId;
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl$NotLoadedCommitsIdsGenerator", "fun"));
            }
            return n;
        }

        @NotNull
        public Map<Integer, CommitId> getNotLoadedCommits() {
            Map<Integer, CommitId> map2 = this.myNotLoadedCommits;
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl$NotLoadedCommitsIdsGenerator", "getNotLoadedCommits"));
            }
            return map2;
        }
    }
}

