/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.Flags;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class BfsUtil {
    public static int getCorrespondingParent(@NotNull LiteLinearGraph graph, int startNode, int endNode, @NotNull Flags visited) {
        int emptyCount;
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/utils/BfsUtil", "getCorrespondingParent"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/vcs/log/graph/utils/BfsUtil", "getCorrespondingParent"));
        }
        List<Integer> candidates = graph.getNodes(startNode, LiteLinearGraph.NodeFilter.DOWN);
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        if (candidates.contains(endNode)) {
            return endNode;
        }
        ArrayList<LinkedList> queues = new ArrayList<LinkedList>(candidates.size());
        for (int candidate : candidates) {
            queues.add(ContainerUtil.newLinkedList((Object[])new Integer[]{candidate}));
        }
        visited.setAll(false);
        do {
            emptyCount = 0;
            for (Queue queue : queues) {
                if (queue.isEmpty()) {
                    ++emptyCount;
                    continue;
                }
                boolean found = BfsUtil.runNextBfsStep(graph, queue, visited, endNode);
                if (!found) continue;
                return candidates.get(queues.indexOf(queue));
            }
        } while (emptyCount < queues.size());
        return candidates.get(0);
    }

    private static boolean runNextBfsStep(@NotNull LiteLinearGraph graph, @NotNull Queue<Integer> queue, @NotNull Flags visited, int target2) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/utils/BfsUtil", "runNextBfsStep"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/vcs/log/graph/utils/BfsUtil", "runNextBfsStep"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/vcs/log/graph/utils/BfsUtil", "runNextBfsStep"));
        }
        while (!queue.isEmpty()) {
            Integer node = queue.poll();
            if (visited.get(node)) continue;
            visited.set(node, true);
            List<Integer> next = graph.getNodes(node, LiteLinearGraph.NodeFilter.DOWN);
            if (next.contains(target2)) {
                return true;
            }
            queue.addAll(next);
            return false;
        }
        return false;
    }
}

