/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFileRevision
extends VcsFileRevisionEx {
    @NotNull
    private final ContentRevision myRevision;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final VcsUser myAuthor;
    @NotNull
    private final VcsUser myCommitter;
    private final long myAuthorTime;
    private final long myCommitTime;
    @NotNull
    private final String myFullMessage;
    @Nullable
    private byte[] myContent;

    public VcsLogFileRevision(@NotNull VcsFullCommitDetails details, @NotNull ContentRevision revision, @NotNull FilePath path) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/history/VcsLogFileRevision", "<init>"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/vcs/log/history/VcsLogFileRevision", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/history/VcsLogFileRevision", "<init>"));
        }
        this.myContent = null;
        this.myRevision = revision;
        this.myPath = path;
        this.myAuthor = details.getAuthor();
        this.myCommitter = details.getCommitter();
        this.myAuthorTime = details.getAuthorTime();
        this.myCommitTime = details.getCommitTime();
        this.myFullMessage = details.getFullMessage();
    }

    @Nullable
    public String getAuthor() {
        return this.myAuthor.getName();
    }

    @Nullable
    public String getAuthorEmail() {
        return this.myAuthor.getEmail();
    }

    @Nullable
    public String getCommitterName() {
        return this.myCommitter.getName();
    }

    @Nullable
    public String getCommitterEmail() {
        return this.myCommitter.getName();
    }

    @Nullable
    public String getCommitMessage() {
        return this.myFullMessage;
    }

    @NotNull
    public FilePath getPath() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/VcsLogFileRevision", "getPath"));
        }
        return filePath;
    }

    @Nullable
    public String getBranchName() {
        return null;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public byte[] loadContent() throws IOException, VcsException {
        if (this.myContent == null) {
            if (this.myRevision instanceof ByteBackedContentRevision) {
                this.myContent = ((ByteBackedContentRevision)this.myRevision).getContentAsBytes();
            } else {
                String content = this.myRevision.getContent();
                if (content != null) {
                    this.myContent = content.getBytes(this.myPath.getCharset().name());
                }
            }
        }
        return this.myContent;
    }

    @Nullable
    public byte[] getContent() throws IOException, VcsException {
        return this.myContent;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = this.myRevision.getRevisionNumber();
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/VcsLogFileRevision", "getRevisionNumber"));
        }
        return vcsRevisionNumber;
    }

    public Date getRevisionDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.myCommitTime);
        return cal.getTime();
    }

    @Nullable
    public Date getAuthorDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.myAuthorTime);
        return cal.getTime();
    }
}

