/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleRefGroup
implements RefGroup {
    @NotNull
    private final String myName;
    @NotNull
    private final List<VcsRef> myRefs;

    public SimpleRefGroup(@NotNull String name2, @NotNull List<VcsRef> refs) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/impl/SimpleRefGroup", "<init>"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/impl/SimpleRefGroup", "<init>"));
        }
        this.myName = name2;
        this.myRefs = refs;
    }

    public boolean isExpanded() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/SimpleRefGroup", "getName"));
        }
        return string;
    }

    @NotNull
    public List<VcsRef> getRefs() {
        List<VcsRef> list2 = this.myRefs;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/SimpleRefGroup", "getRefs"));
        }
        return list2;
    }

    @NotNull
    public List<Color> getColors() {
        List<Color> list2 = SimpleRefGroup.getColors(this.myRefs);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/SimpleRefGroup", "getColors"));
        }
        return list2;
    }

    @NotNull
    public static List<Color> getColors(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/impl/SimpleRefGroup", "getColors"));
        }
        MultiMap referencesByType = ContainerUtil.groupBy(refs, VcsRef::getType);
        if (referencesByType.size() == 1) {
            Map.Entry firstItem = (Map.Entry)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)referencesByType.entrySet()));
            boolean multiple = ((Collection)firstItem.getValue()).size() > 1;
            Color color = ((VcsRefType)firstItem.getKey()).getBackgroundColor();
            List<Color> list2 = multiple ? Arrays.asList(color, color) : Collections.singletonList(color);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/SimpleRefGroup", "getColors"));
            }
            return list2;
        }
        ArrayList colorsList = ContainerUtil.newArrayList();
        for (VcsRefType type2 : referencesByType.keySet()) {
            if (referencesByType.get((Object)type2).size() > 1) {
                colorsList.add(type2.getBackgroundColor());
            }
            colorsList.add(type2.getBackgroundColor());
        }
        ArrayList arrayList = colorsList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/SimpleRefGroup", "getColors"));
        }
        return arrayList;
    }

    public static void buildGroups(@NotNull MultiMap<VcsRefType, VcsRef> groupedRefs, boolean compact, boolean showTagNames, @NotNull List<RefGroup> result2) {
        if (groupedRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupedRefs", "com/intellij/vcs/log/impl/SimpleRefGroup", "buildGroups"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/impl/SimpleRefGroup", "buildGroups"));
        }
        if (groupedRefs.isEmpty()) {
            return;
        }
        if (compact) {
            VcsRef firstRef = (VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)groupedRefs.values()));
            RefGroup group = (RefGroup)ContainerUtil.getFirstItem(result2);
            if (group == null) {
                result2.add(new SimpleRefGroup(firstRef.getType().isBranch() || showTagNames ? firstRef.getName() : "", ContainerUtil.newArrayList((Iterable)groupedRefs.values())));
            } else {
                group.getRefs().addAll(groupedRefs.values());
            }
        } else {
            for (Map.Entry entry : groupedRefs.entrySet()) {
                if (((VcsRefType)entry.getKey()).isBranch()) {
                    for (VcsRef ref : (Collection)entry.getValue()) {
                        result2.add(new SimpleRefGroup(ref.getName(), ContainerUtil.newArrayList((Object[])new VcsRef[]{ref})));
                    }
                    continue;
                }
                result2.add(new SimpleRefGroup(showTagNames ? ((VcsRef)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())))).getName() : "", ContainerUtil.newArrayList((Iterable)((Iterable)entry.getValue()))));
            }
        }
    }
}

