/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.NotNullFunction;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogContentProvider
implements ChangesViewContentProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogContentProvider.class);
    public static final String TAB_NAME = "Log";
    @NotNull
    private final VcsProjectLog myProjectLog;
    @NotNull
    private final JPanel myContainer;
    @Nullable
    private volatile VcsLogUiImpl myUi;

    public VcsLogContentProvider(@NotNull Project project2, @NotNull VcsProjectLog projectLog) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentProvider", "<init>"));
        }
        if (projectLog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectLog", "com/intellij/vcs/log/impl/VcsLogContentProvider", "<init>"));
        }
        this.myContainer = new JBPanel((LayoutManager)new BorderLayout());
        this.myProjectLog = projectLog;
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)projectLog);
        connection.subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager logManager) {
                if (logManager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/vcs/log/impl/VcsLogContentProvider$1", "logCreated"));
                }
                VcsLogContentProvider.this.addMainUi(logManager);
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager logManager) {
                if (logManager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/vcs/log/impl/VcsLogContentProvider$1", "logDisposed"));
                }
                VcsLogContentProvider.this.disposeMainUi();
            }
        });
        VcsLogManager manager = this.myProjectLog.getLogManager();
        if (manager != null) {
            this.addMainUi(manager);
        }
    }

    @Nullable
    public VcsLogUiImpl getUi() {
        return this.myUi;
    }

    private void addMainUi(@NotNull VcsLogManager logManager) {
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/vcs/log/impl/VcsLogContentProvider", "addMainUi"));
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myUi == null) {
            this.myUi = logManager.createLogUi("MAIN", TAB_NAME);
            this.myContainer.add((Component)((Object)new VcsLogPanel(logManager, this.myUi)), "Center");
        }
    }

    private void disposeMainUi() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        this.myContainer.removeAll();
        if (this.myUi != null) {
            VcsLogUiImpl ui = this.myUi;
            this.myUi = null;
            Disposer.dispose((Disposable)ui);
        }
    }

    @Override
    public JComponent initContent() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.myProjectLog.createLog());
        return this.myContainer;
    }

    @Override
    public void disposeContent() {
        this.disposeMainUi();
    }

    @Nullable
    public static VcsLogContentProvider getInstance(@NotNull Project project2) {
        ChangesViewContentEP[] extensions;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentProvider", "getInstance"));
        }
        for (ChangesViewContentEP ep : extensions = (ChangesViewContentEP[])project2.getExtensions(ChangesViewContentEP.EP_NAME)) {
            if (!ep.getClassName().equals(VcsLogContentProvider.class.getName())) continue;
            return (VcsLogContentProvider)ep.getCachedInstance();
        }
        return null;
    }

    public static class VcsLogVisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(Project project2) {
            Boolean bl = !VcsLogManager.findLogProviders(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project2).getAllVcsRoots()), project2).isEmpty();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogContentProvider$VcsLogVisibilityPredicate", "fun"));
            }
            return bl;
        }
    }
}

